/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import is.hugvit.util.Util;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class CertificateDetails {
    private String subjectCommonName;
    private String subjectSerialNumber;
    private String subjectOrganizationName;
    private String subjectCountry;
    private List<String> subjectOrganizationUnits = new ArrayList<String>();
    private String issuerCommonName;
    private String issuerSerialNumber;
    private String issuerOrganizationName;
    private String issuerCountry;
    private List<String> issuerOrganizationUnits = new ArrayList<String>();
    private X509Certificate certificate;
    private static final Logger logger = Logger.getLogger(CertificateDetails.class);

    public CertificateDetails(X509Certificate cert) {
        if (cert != null) {
            this.certificate = cert;
            this.inspect();
        }
    }

    public final String getSubjectCommonName() {
        return this.subjectCommonName;
    }

    public final String getSubjectSerialNumber() {
        return this.subjectSerialNumber;
    }

    public final String getSubjectOrganizationName() {
        return this.subjectOrganizationName;
    }

    public final String getSubjectCountry() {
        return this.subjectCountry;
    }

    public final List<String> getSubjectOrganizationUnits() {
        return this.subjectOrganizationUnits;
    }

    public final String getIssuerCommonName() {
        return this.issuerCommonName;
    }

    public final String getIssuerSerialNumber() {
        return this.issuerSerialNumber;
    }

    public final String getIssuerOrganizationName() {
        return this.issuerOrganizationName;
    }

    public final String getIssuerCountry() {
        return this.issuerCountry;
    }

    public final List<String> getIssuerOrganizationUnits() {
        return this.issuerOrganizationUnits;
    }

    public final Element getXml() {
        Element el = DocumentHelper.createElement((String)"certificate");
        if (this.certificate != null) {
            this.addAttribute(el, "serial", this.certificate.getSerialNumber().toString());
            this.addAttribute(el, "algo", this.certificate.getSigAlgName());
            Dom4JUtil.addElement(el, "validFrom", LocaleUtil.formatDateShort(this.certificate.getNotBefore().getTime()));
            Dom4JUtil.addElement(el, "validTo", LocaleUtil.formatDateShort(this.certificate.getNotAfter().getTime()));
            Element elSubject = el.addElement("subject");
            this.addAttribute(elSubject, "cn", this.subjectCommonName);
            this.addAttribute(elSubject, "o", this.subjectOrganizationName);
            this.addAttribute(elSubject, "c", this.subjectCountry);
            this.addAttribute(elSubject, "serial", this.subjectSerialNumber);
            for (String ou : this.subjectOrganizationUnits) {
                elSubject.addElement("ou").setText(ou);
            }
            Element elIssuer = el.addElement("issuer");
            this.addAttribute(elIssuer, "cn", this.issuerCommonName);
            this.addAttribute(elIssuer, "o", this.issuerOrganizationName);
            this.addAttribute(elIssuer, "c", this.issuerCountry);
            this.addAttribute(elIssuer, "serial", this.issuerSerialNumber);
            for (String ou : this.issuerOrganizationUnits) {
                elIssuer.addElement("ou").setText(ou);
            }
        }
        return el;
    }

    private void inspect() {
        if (this.certificate != null) {
            String subjectString = this.certificate.getSubjectDN().getName();
            String issuerString = this.certificate.getIssuerDN().getName();
            if (subjectString != null) {
                this.parse(subjectString, Selector.SUBJECT);
            }
            if (issuerString != null) {
                this.parse(issuerString, Selector.ISSUER);
            }
            if (!StringUtil.isValid(this.subjectSerialNumber)) {
                this.subjectSerialNumber = this.certificate.getSerialNumber().toString(16).toUpperCase();
            }
        }
    }

    private void parse(String s, Selector selector) {
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreElements()) {
            String value;
            X509Attribute att;
            String line = tok.nextToken().trim();
            List list = Util.splitList((String)line, (String)"=");
            if (list.size() == 2) {
                try {
                    att = X509Attribute.valueOf((String)list.get(0));
                    value = (String)list.get(1);
                    if (value == null) continue;
                    this.setValue(selector, att, value);
                }
                catch (Exception ex) {
                    logger.info((Object)("Unsupported attribute: " + list.get(0)));
                }
                continue;
            }
            if (list.size() != 3) continue;
            try {
                att = X509Attribute.valueOf((String)list.get(0));
                value = (String)list.get(1);
                if (value == null) continue;
                this.setValue(selector, att, value.replace("+ SERIALNUMBER", "").trim());
            }
            catch (Exception ex) {
                logger.info((Object)("Unsupported attribute: " + list.get(0)));
            }
        }
    }

    private final void setValue(Selector selector, X509Attribute att, String value) {
        if (selector.equals((Object)Selector.ISSUER)) {
            switch (att) {
                case C: {
                    this.issuerCountry = value;
                    break;
                }
                case CN: {
                    this.issuerCommonName = value;
                    break;
                }
                case O: {
                    this.issuerOrganizationName = value;
                    break;
                }
                case SERIALNUMBER: {
                    this.issuerSerialNumber = value;
                    break;
                }
                case OU: {
                    this.issuerOrganizationUnits.add(value);
                }
            }
        } else if (selector.equals((Object)Selector.SUBJECT)) {
            switch (att) {
                case C: {
                    this.subjectCountry = value;
                    break;
                }
                case CN: {
                    this.subjectCommonName = value;
                    break;
                }
                case O: {
                    this.subjectOrganizationName = value;
                    break;
                }
                case SERIALNUMBER: {
                    this.subjectSerialNumber = value;
                    break;
                }
                case OU: {
                    this.subjectOrganizationUnits.add(value);
                }
            }
        }
    }

    private final void addAttribute(Element el, String key, String value) {
        if (StringUtil.isValid(key) && StringUtil.isValid(value)) {
            el.addAttribute(key, value);
        }
    }

    private static enum X509Attribute {
        CN,
        OU,
        O,
        C,
        SERIALNUMBER;

    }

    private static enum Selector {
        SUBJECT,
        ISSUER;

    }
}

