/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.SubDocument;

public final class BaseDocumentUtil {
    public static final synchronized void removeDeletedDocuments(Collection<? extends BaseDocument> list) {
        if (list != null && list.size() > 0) {
            Iterator<? extends BaseDocument> it = list.iterator();
            while (it.hasNext()) {
                BaseDocument doc = it.next();
                if (!doc.isDeleted()) continue;
                it.remove();
            }
        }
    }

    public static final synchronized void filterSubdocuments(Collection<? extends BaseDocument> list) {
        if (list != null && list.size() > 0) {
            Iterator<? extends BaseDocument> it = list.iterator();
            while (it.hasNext()) {
                BaseDocument doc = it.next();
                if (doc instanceof SubDocument) continue;
                it.remove();
            }
        }
    }

    public static final Vector<String> getCollectionIds(Collection<? extends BaseDocument> list) {
        Vector<String> v = new Vector<String>();
        if (list != null && list.size() > 0) {
            for (BaseDocument baseDocument : list) {
                v.add(baseDocument.getId());
            }
        }
        return v;
    }

    public static final BaseDocument getDocumentFromList(String documentId, Collection<? extends BaseDocument> list) {
        if (list == null) {
            return null;
        }
        for (BaseDocument baseDocument : list) {
            if (!baseDocument.getId().equals(documentId)) continue;
            return baseDocument;
        }
        return null;
    }
}

