/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import java.io.IOException;
import java.net.SocketException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.util.ReportDataUtil;
import org.jCharts.Chart;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.PieChartDataSet;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IPieChartDataSet;
import org.jCharts.encoders.ServletEncoderHelper;
import org.jCharts.nonAxisChart.PieChart2D;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;

public class ReportingServlet
extends HttpServlet {
    private static final long serialVersionUID = 7462512903946619877L;
    private int width = 750;
    private int height = 400;

    public void init() {
    }

    public void service(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        try {
            AxisChart axisChart;
            String reportPeriod = req.getParameter("period");
            String reportType = req.getParameter("type");
            ReportDataUtil.ReportPeriod Period = ReportDataUtil.ReportPeriod.DAY;
            try {
                this.width = Integer.parseInt(req.getParameter("w"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Period = ReportDataUtil.ReportPeriod.valueOf(reportPeriod.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ChartProperties chartProperties = new ChartProperties();
            AxisProperties axisProperties = new AxisProperties();
            LegendProperties legendProperties = new LegendProperties();
            if ("users".equals(reportType)) {
                IAxisDataSeries userDataSeries = ReportDataUtil.getUserDataSeries(Period);
                axisChart = new AxisChart(userDataSeries, chartProperties, axisProperties, null, this.width, this.height);
                ServletEncoderHelper.encodePNG((Chart)axisChart, (HttpServletResponse)response);
            }
            if ("registrations".equals(reportType)) {
                IAxisDataSeries registrationDataSeries = ReportDataUtil.getRegistrationDataSeries(Period);
                axisChart = new AxisChart(registrationDataSeries, chartProperties, axisProperties, null, this.width, this.height);
                ServletEncoderHelper.encodePNG((Chart)axisChart, (HttpServletResponse)response);
            } else if ("cases".equals(reportType)) {
                IAxisDataSeries caseDataSeries = ReportDataUtil.getCaseDataSeries(Period);
                axisChart = new AxisChart(caseDataSeries, chartProperties, axisProperties, legendProperties, this.width, this.height);
                ServletEncoderHelper.encodePNG((Chart)axisChart, (HttpServletResponse)response);
            } else if ("subdocuments".equals(reportType)) {
                IAxisDataSeries documentDataSeries = ReportDataUtil.getSubDocumentDataSeries(Period);
                axisChart = new AxisChart(documentDataSeries, chartProperties, axisProperties, legendProperties, this.width, this.height);
                ServletEncoderHelper.encodePNG((Chart)axisChart, (HttpServletResponse)response);
            } else if ("casetypes".equals(reportType)) {
                PieChartDataSet pieChartDataSet = ReportDataUtil.getCaseTypeSeries(Period);
                legendProperties.setPlacement(1);
                legendProperties.setNumColumns(1);
                PieChart2D pieChart2D = new PieChart2D((IPieChartDataSet)pieChartDataSet, legendProperties, new ChartProperties(), this.width, this.height);
                ServletEncoderHelper.encodePNG((Chart)pieChart2D, (HttpServletResponse)response);
            }
        }
        catch (SocketException reportPeriod) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }
}

