/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.LotusFormTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.StringUtil;

public class LotusFormFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String requestId = request.getParameter("id");
            HttpSession session = ((HttpServletRequest)request).getSession();
            if (StringUtil.isValid(requestId)) {
                if (requestId.length() == 6) {
                    FormTemplate template = FormService.getFormTemplateByToken(requestId);
                    Organization org = null;
                    if (template instanceof LotusFormTemplate && (org = template.getOrganizationByLinkToken(requestId)) != null) {
                        session.setAttribute("is_new", (Object)"true");
                        session.setAttribute("template_id", (Object)template.getId());
                        session.setAttribute("organization_id", (Object)org.getId());
                    }
                    session.removeAttribute("application_id");
                } else {
                    ApplicationForm form;
                    SubDocument doc = CaseService.getSubDocument(requestId, false);
                    if (doc instanceof ApplicationForm && (form = (ApplicationForm)doc) != null) {
                        session.setAttribute("application_id", (Object)form.getId());
                    }
                    session.removeAttribute("organization_id");
                    session.removeAttribute("template_id");
                    session.removeAttribute("is_new");
                }
            }
            chain.doFilter(request, response);
        }
        catch (SelfServiceException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void destroy() {
    }
}

