/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.services;

import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.UserRole;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.gopro.GoProCompanyReference;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.filters.UserFilter;
import net.gopro.selfservice.services.BaseService;

public class UserService
extends BaseService {
    public static User getUser(String userId) throws SelfServiceException {
        return UserService.UserEngine().getUser(userId);
    }

    public static User getUserByEmail(String email) throws SelfServiceException {
        return UserService.UserEngine().getUserByEmail(email);
    }

    public static User getUserByUsername(String username) throws SelfServiceException {
        return UserService.UserEngine().getUserByUsername(username);
    }

    public static User getUserByIdNumber(String idNumber) throws SelfServiceException {
        return UserService.UserEngine().getUserByIdNumber(idNumber);
    }

    public static User getUserByGoProClientReferenceId(String goproReferenceId) throws SelfServiceException {
        return UserService.UserEngine().getUserByGoProClientReferenceId(goproReferenceId);
    }

    public static List<User> getUsers(UserFilter userFilter) throws SelfServiceException {
        return UserService.UserEngine().getUsers(userFilter);
    }

    public static List<User> getUsers(List<String> userIds) throws SelfServiceException {
        return UserService.UserEngine().getUsers(userIds);
    }

    public static List<UserRole> getUserRoles() throws SelfServiceException {
        return UserService.UserEngine().getUserRoles();
    }

    public static List<Company> getCompanies() throws SelfServiceException {
        return UserService.UserEngine().getCompanies();
    }

    public static List<Company> getCompaniesWithContacts() throws SelfServiceException {
        return UserService.UserEngine().getCompaniesWithContacts();
    }

    public static List<Company> getCompaniesByOrganization(String organizationId) throws SelfServiceException {
        return UserService.UserEngine().getCompaniesByOrganization(organizationId);
    }

    public static List<Company> getCompaniesByAccountManager(String accountManagerId) throws SelfServiceException {
        return UserService.UserEngine().getCompaniesByAccountManager(accountManagerId);
    }

    public static Company getCompany(String companyId) throws SelfServiceException, UserException {
        return UserService.UserEngine().getCompany(companyId);
    }

    public static void createUser(User user) throws UserException, SelfServiceException {
        UserService.UserEngine().createUser(user);
    }

    public static void updateUser(User user) throws UserException, SelfServiceException {
        UserService.UserEngine().updateUser(user);
    }

    public static void deleteUser(String userId) throws UserException, SelfServiceException {
        UserService.UserEngine().deleteUser(userId);
    }

    public static void createCompany(Company com) throws SelfServiceException {
        UserService.UserEngine().createCompany(com);
    }

    public static void updateCompany(Company com) throws SelfServiceException {
        UserService.UserEngine().updateCompany(com);
    }

    public static void deleteCompany(String documentId) throws UserException, SelfServiceException {
        UserService.UserEngine().deleteCompany(documentId);
    }

    public static void deleteCompanyContact(String companyId, String userId) throws UserException, SelfServiceException {
        UserService.UserEngine().deleteCompanyContact(companyId, userId);
    }

    public static List<Company> searchCompanies(String keyword) throws SelfServiceException {
        return UserService.UserEngine().searchCompanies(keyword);
    }

    public static Company getCompanyByName(String companyName) throws SelfServiceException {
        return UserService.UserEngine().getCompanyByName(companyName);
    }

    public static List<User> getContacts(String companyId) throws SelfServiceException, UserException {
        return UserService.UserEngine().getContacts(companyId);
    }

    public static UserRole getUserRole(String roleId) throws SelfServiceException {
        return UserService.UserEngine().getUserRole(roleId);
    }

    public static void createGoProClientReference(GoProClientBaseReference ref) throws SelfServiceException {
        UserService.UserEngine().createGoProClientReference(ref);
    }

    public static void updateGoProClientReference(GoProClientBaseReference ref) throws SelfServiceException {
        UserService.UserEngine().updateGoProClientReference(ref);
    }

    public static void createGoProCompanyReference(GoProCompanyReference ref) throws SelfServiceException {
        UserService.UserEngine().createGoProCompanyReference(ref);
    }

    public static byte[] getUserProfileImage(String userId) throws SelfServiceException {
        return UserService.UserEngine().getUserProfileImage(userId);
    }

    public static void createContact(Contact contact) throws SelfServiceException {
        UserService.UserEngine().createContact(contact);
    }

    public static Contact getContact(String contactId) throws SelfServiceException {
        return UserService.UserEngine().getContact(contactId);
    }

    public static void updateContact(Contact contact) throws SelfServiceException {
        UserService.UserEngine().updateContact(contact);
    }

    public static void deleteContact(String contactId) throws SelfServiceException {
        UserService.UserEngine().deleteContact(contactId);
    }

    public static void updateGoProCompanyReference(GoProCompanyReference companyRef) throws SelfServiceException {
        UserService.UserEngine().updateGoProCompanyReference(companyRef);
    }

    public static Contact getContactByEmail(String email) throws SelfServiceException {
        return UserService.UserEngine().getContactByEmail(email);
    }
}

