/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pdf;

import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.User;

public class PDFProperties {
    private String title;
    private String subject;
    private String author;
    private String keywords = "GoPro Self Service, Application";
    private String creator = "GoPro Self Service";
    private String producer = this.creator + " " + SelfServiceEngine.getConfig("version");

    public static PDFProperties getInstance(User user, BaseCase bc) {
        PDFProperties p = new PDFProperties();
        if (user != null) {
            p.setAuthor(user.getFullname());
        }
        if (bc != null) {
            p.setTitle(bc.getSubject());
            p.setSubject(bc.getSubject());
            p.setKeywords(p.getKeywords() + ", " + bc.getSubject());
        }
        return p;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getProducer() {
        return this.producer;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }
}

