/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.text.DecimalFormat;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.filters.DocumentSearchFilter;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.SearchService;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class SearchPage
extends BasePage {
    public static final String pageName = "search.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            String searchKey = context.getRequest().getParameter("s");
            if (StringUtil.isValid(searchKey) && searchKey.length() > 2) {
                long start = System.currentTimeMillis();
                DocumentSearchFilter filter = new DocumentSearchFilter();
                filter.setSearchKeyword(searchKey);
                filter.setDeletionStatus(DocumentSearchFilter.DeletionStatus.NOT_DELETED);
                filter.addDocumentType(Memo.class);
                filter.addDocumentType(CompletedFormDocument.class);
                filter.addDocumentType(Attachment.class);
                filter.addDocumentType(Email.class);
                filter.addDocumentType(FormTemplate.class);
                filter.addDocumentType(BaseCase.class);
                filter.addDocumentType(Message.class);
                List<BaseDocument> list = SearchService.searchDocuments(filter);
                long searchTime = System.currentTimeMillis() - start;
                Element resultEl = this.dataroot.addElement("results");
                resultEl.addAttribute("keyword", searchKey);
                resultEl.addAttribute("count", String.valueOf(list.size()));
                String pattern = "#.##";
                DecimalFormat nf = new DecimalFormat("#.##");
                String sTime = nf.format(new Float((float)searchTime / 1000.0f));
                resultEl.addAttribute("time", sTime);
                this.showList(resultEl, list);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }
}

