/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.DocumentComparator;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MyCasesPage
extends BasePage {
    public static final String pageName = "mycases.html";
    private static final int FALLBACK_RECORDS_PER_PAGE = 15;

    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            Element elFilter = context.getRootElement().addElement("filter");
            String all = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.all", "portal.common");
            String unsent = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.unsent", "portal.common");
            String submitted = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.submitted", "portal.common");
            String shared = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.shared", "portal.common");
            String viewTitle = "";
            User currentUser = this.getCurrentUser(context);
            List<Object> caseList = new ArrayList();
            String templateIdFilter = context.getRequest().getParameter("type");
            String statusIdFilter = context.getRequest().getParameter("status");
            String companyFilter = context.getRequest().getParameter("oid");
            String sortFilter = context.getRequest().getParameter("sort");
            boolean sortAscending = !"desc".equals(context.getRequest().getParameter("dir"));
            boolean isCompanyFilter = false;
            int submittedFilter = 0;
            try {
                if (context.getRequest().getParameter("view") != null) {
                    submittedFilter = Integer.parseInt(context.getRequest().getParameter("view"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtil.isValid(templateIdFilter)) {
                FormTemplate ft = FormService.getFormTemplate(templateIdFilter, false);
                if (ft != null) {
                    LinkedList<StatusListItem> statusList = ft.getExtendedData().getCaseStatusList();
                    List<FormCase> listByTemplate = this.getCasesByTemplateFilterId(currentUser, templateIdFilter);
                    this.showCaseStatusList(statusList, statusIdFilter, listByTemplate);
                    caseList.addAll(listByTemplate);
                    elFilter.addAttribute("template_id", ft.getId());
                    elFilter.addAttribute("template", ft.getSubject());
                    if (StringUtil.isValid(statusIdFilter)) {
                        StatusListItem currentStatus = null;
                        BaseDocument statusDoc = BaseDocumentUtil.getDocumentFromList(statusIdFilter, statusList);
                        if (statusDoc != null) {
                            currentStatus = (StatusListItem)statusDoc;
                            Iterator<Object> iterator = caseList.iterator();
                            while (iterator.hasNext()) {
                                BaseCase bc = (BaseCase)iterator.next();
                                if (statusIdFilter.equals(bc.getStatusId())) continue;
                                iterator.remove();
                            }
                            elFilter.addAttribute("status", currentStatus.getSubject());
                            elFilter.addAttribute("status_id", currentStatus.getId());
                        }
                    }
                } else {
                    CaseTemplate caseTemplate = CaseService.getCaseTemplate(templateIdFilter);
                    if (caseTemplate != null) {
                        caseList = CaseService.getCasesByCaseTemplate(templateIdFilter, currentUser.getId());
                        elFilter.addAttribute("template_id", caseTemplate.getId());
                        elFilter.addAttribute("template", caseTemplate.getSubject());
                    }
                }
            } else if (StringUtil.isValid(companyFilter) && currentUser.isContactForCompany(companyFilter)) {
                Company company = UserService.getCompany(companyFilter);
                if (company != null) {
                    caseList = CaseService.getCasesByCompany(companyFilter);
                    this.filterBySubmittedStatus(caseList, submittedFilter);
                    String viewFilter = all;
                    if (submittedFilter == 1) {
                        viewFilter = unsent;
                    } else if (submittedFilter == 2) {
                        viewFilter = submitted;
                    }
                    viewTitle = this.createViewTitle(new String[]{company.getName(), viewFilter});
                    this.setCaseVisibility(caseList);
                    elFilter.addAttribute("company_id", company.getId());
                    elFilter.addAttribute("company", company.getName());
                    elFilter.addAttribute("view", String.valueOf(submittedFilter));
                    isCompanyFilter = true;
                }
            } else {
                caseList = CaseService.getCases(currentUser.getId());
                BaseDocumentUtil.removeDeletedDocuments(caseList);
                if (submittedFilter > 0) {
                    this.filterBySubmittedStatus(caseList, submittedFilter);
                    viewTitle = submittedFilter == 1 ? this.createViewTitle(new String[]{unsent}) : (submittedFilter == 2 ? this.createViewTitle(new String[]{submitted}) : (submittedFilter == 3 ? this.createViewTitle(new String[]{shared}) : this.createViewTitle(new String[]{String.valueOf(submittedFilter)})));
                    elFilter.addAttribute("view", String.valueOf(submittedFilter));
                } else {
                    this.removeSecondaryCases(caseList);
                }
                if (submittedFilter == 0 && caseList.size() == 0) {
                    elFilter.addAttribute("status", "nocases");
                }
                this.setCaseVisibility(caseList);
            }
            if (!isCompanyFilter) {
                this.showCaseTypeList(currentUser.getId());
            }
            this.setCaseFilterSelection(currentUser, this.dataroot);
            this.filterCases(context, caseList);
            if (sortFilter != null) {
                this.sortCaseList(caseList, sortFilter, sortAscending);
            }
            int recordsPerPage = this.getRecordCountPerPage();
            if (caseList.size() > 0 && caseList.size() > recordsPerPage) {
                int pagerSize;
                int totalRecords = caseList.size();
                int currentPage = this.getPageNumber(context);
                if (currentPage > (pagerSize = this.getPagerSize(totalRecords, recordsPerPage))) {
                    currentPage = 1;
                }
                caseList = this.getPagedList(caseList, currentPage, recordsPerPage);
                this.createPager(totalRecords, currentPage, recordsPerPage, pagerSize, caseList.size());
            }
            List<FormTemplate> primaryFormTemplates = FormService.getPrimaryFormTemplates();
            List<CaseTemplate> primaryCaseTemplates = CaseService.getPrimaryCaseTemplates();
            Hashtable<String, List<String>> primariesTable = this.generatePrimariesHashtable(primaryFormTemplates, primaryCaseTemplates);
            for (BaseCase baseCase : caseList) {
                List<String> statusIdList;
                if (baseCase instanceof FormCase && primariesTable.containsKey(((FormCase)baseCase).getFormtemplateId())) {
                    statusIdList = primariesTable.get(((FormCase)baseCase).getFormtemplateId());
                    if (!statusIdList.contains(baseCase.getStatusId())) continue;
                    ((FormCase)baseCase).setPrimaryApplication(true);
                    continue;
                }
                if (!(baseCase instanceof Case) || !primariesTable.containsKey(baseCase.getCaseTemplateId()) || !(statusIdList = primariesTable.get(baseCase.getCaseTemplateId())).contains(baseCase.getStatusId())) continue;
                ((Case)baseCase).setHasChildApplications(true);
            }
            this.showCaseList(caseList);
            if (!"".equals(viewTitle)) {
                this.dataroot.addAttribute("title", viewTitle);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    protected void filterCases(WebContext context, List<BaseCase> caseList) {
    }

    protected List<FormCase> getCasesByTemplateFilterId(User currentUser, String templateId) throws SelfServiceException {
        List<FormCase> listByTemplate = CaseService.getCasesByFormTemplate(currentUser.getId(), templateId);
        return listByTemplate;
    }

    protected void showCaseList(List<BaseCase> list) throws SelfServiceException {
        List<FormTemplate> formTemplateList = FormService.getFormTemplates();
        if (list != null) {
            for (BaseDocument baseDocument : list) {
                this.dataroot.add(this.getXmlElement(baseDocument, formTemplateList));
            }
        }
    }

    private Element getXmlElement(BaseDocument doc, List<FormTemplate> templateList) {
        FormTemplate ft;
        Element el = doc.getXml();
        if (doc instanceof FormCase && (ft = (FormTemplate)BaseDocumentUtil.getDocumentFromList(((FormCase)doc).getFormtemplateId(), templateList)) != null && ft.isDateRestricted()) {
            DateFormat df = LocaleUtil.getTimeFormat();
            el.addElement("is_deadline").setText("true");
            el.addElement("is_expired").setText(String.valueOf(!ft.isWithinDateRestriction()));
            el.addElement("deadline").setText(df.format(ft.getDateValidTo()));
        }
        return el;
    }

    private List<BaseCase> getPagedList(List<BaseCase> list, int page, int recordsPerPage) {
        int endPos;
        int startPos = (page - 1) * recordsPerPage;
        if (startPos > list.size()) {
            startPos = 0;
        }
        if ((endPos = startPos + recordsPerPage) > list.size()) {
            endPos = list.size();
        }
        return list.subList(startPos, endPos);
    }

    private void createPager(int totalRecords, int currentPage, int recordsPerPage, int pagerSize, int currentRecordCount) {
        Element el = this.dataroot.addElement("pager");
        el.addAttribute("page", String.valueOf(currentPage));
        el.addAttribute("total", String.valueOf(totalRecords));
        el.addAttribute("perpage", String.valueOf(recordsPerPage));
        el.addAttribute("size", String.valueOf(pagerSize));
        int startPos = (currentPage - 1) * recordsPerPage;
        if (startPos > totalRecords) {
            startPos = 0;
        }
        int endPos = startPos + currentRecordCount;
        el.addAttribute("start", String.valueOf(startPos + 1));
        el.addAttribute("end", String.valueOf(endPos));
        for (int i = 1; i <= pagerSize; ++i) {
            el.addElement("page").setText(String.valueOf(i));
        }
    }

    private final int getPagerSize(int totalRecords, int recordsPerPage) {
        int pages = totalRecords / recordsPerPage;
        if (totalRecords % recordsPerPage != 0) {
            ++pages;
        }
        return pages;
    }

    private final int getPageNumber(WebContext context) {
        String s = context.getRequest().getParameter("page");
        int pageNumber = 1;
        if (StringUtil.isValid(s)) {
            try {
                pageNumber = Integer.parseInt(s);
                if (pageNumber < 1) {
                    pageNumber = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pageNumber;
    }

    private final int getRecordCountPerPage() {
        int pagerSize = 15;
        String sCount = SelfServiceEngine.getConfig("web.viewcount.mycases");
        if (StringUtil.isValid(sCount)) {
            try {
                pagerSize = Integer.parseInt(sCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pagerSize;
    }

    protected void showCaseTypeList(String userId) throws SelfServiceException {
        Hashtable<String, String> ht = CaseService.getCaseTypesInUse(userId);
        if (ht.size() > 1) {
            Element el = this.dataroot.addElement("casetypes");
            Enumeration<String> templateIds = ht.keys();
            while (templateIds.hasMoreElements()) {
                String templateId = templateIds.nextElement();
                Element tel = el.addElement("type");
                tel.addAttribute("id", templateId);
                tel.setText(ht.get(templateId));
            }
        }
    }

    protected void filterBySubmittedStatus(List<BaseCase> list, int filter) {
        block4: {
            block5: {
                block3: {
                    if (filter != 1) break block3;
                    Iterator<BaseCase> it = list.iterator();
                    while (it.hasNext()) {
                        BaseCase bc = it.next();
                        if (bc instanceof FormCase && !bc.isSent()) continue;
                        it.remove();
                    }
                    break block4;
                }
                if (filter != 2) break block5;
                Iterator<BaseCase> it = list.iterator();
                while (it.hasNext()) {
                    BaseCase bc = it.next();
                    if (bc instanceof FormCase && bc.isSent()) continue;
                    it.remove();
                }
                break block4;
            }
            if (filter != 3) break block4;
            Iterator<BaseCase> it = list.iterator();
            while (it.hasNext()) {
                BaseCase bc = it.next();
                if (bc instanceof Case) continue;
                it.remove();
            }
        }
    }

    private void removeSecondaryCases(List<BaseCase> caseList) {
        Vector<String> collectionIds = BaseDocumentUtil.getCollectionIds(caseList);
        Iterator<BaseCase> it = caseList.iterator();
        while (it.hasNext()) {
            BaseCase bc = it.next();
            if (!(bc instanceof FormCase) || ((FormCase)bc).getParentId() == null || !collectionIds.contains(((FormCase)bc).getParentId())) continue;
            it.remove();
        }
    }

    private void setCaseVisibility(List<BaseCase> caseList) throws SelfServiceException {
        boolean isLookupRequired = false;
        for (BaseCase bc : caseList) {
            if (bc instanceof FormCase) continue;
            isLookupRequired = true;
            break;
        }
        if (isLookupRequired) {
            List<CaseTemplate> templates = CaseService.getCaseTemplates();
            ArrayList<String> notVisibleIds = new ArrayList<String>();
            for (CaseTemplate ct : templates) {
                if (ct.isDeleted() || ct.isVisibleInDefaultView()) continue;
                notVisibleIds.add(ct.getId());
            }
            if (notVisibleIds.size() > 0) {
                Iterator<BaseCase> it = caseList.iterator();
                while (it.hasNext()) {
                    BaseCase bc = it.next();
                    if (bc instanceof FormCase || !notVisibleIds.contains(bc.getCaseTemplateId())) continue;
                    it.remove();
                }
            }
        }
    }

    private final void showCaseStatusList(List<StatusListItem> list, String selectedId, List<FormCase> caseList) {
        Hashtable<String, Integer> statusCount = new Hashtable<String, Integer>();
        for (FormCase formCase : caseList) {
            if (statusCount.containsKey(formCase.getStatusId())) {
                int counter = (Integer)statusCount.get(formCase.getStatusId());
                statusCount.put(formCase.getStatusId(), counter + 1);
                continue;
            }
            statusCount.put(formCase.getStatusId(), 1);
        }
        int statusCounter = 0;
        for (Integer count : statusCount.values()) {
            if (count <= 0) continue;
            ++statusCounter;
        }
        if (statusCounter > 1 && list != null && list.size() > 0) {
            Element element = this.dataroot.addElement("casestatuses");
            for (StatusListItem item : list) {
                Element sel = element.addElement("status");
                int counter = 0;
                if (statusCount.containsKey(item.getId())) {
                    counter = (Integer)statusCount.get(item.getId());
                }
                sel.setText(item.getSubject());
                sel.addAttribute("id", item.getId());
                sel.addAttribute("count", String.valueOf(counter));
                if (!item.getId().equals(selectedId)) continue;
                sel.addAttribute("selected", "true");
            }
        }
    }

    private Element setCaseFilterSelection(User user, Element root) {
        Element el = root.addElement("casemenu");
        String all = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.all", "portal.common");
        String unsent = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.unsent", "portal.common");
        String submitted = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.submitted", "portal.common");
        String shared = LocaleUtil.getStringSafe(this.resourceBundle, "mymenu.shared", "portal.common");
        Element elInd = el.addElement("item");
        elInd.addAttribute("type", "individual");
        elInd.add(this.createCaseFilterMenuItem(all, 0));
        elInd.add(this.createCaseFilterMenuItem(unsent, 1));
        elInd.add(this.createCaseFilterMenuItem(submitted, 2));
        elInd.add(this.createCaseFilterMenuItem(shared, 3));
        for (Contact con : user.getContactList()) {
            Element elCon = el.addElement("item");
            elCon.addAttribute("type", "contact");
            elCon.addAttribute("company", con.getCompanyName());
            elCon.addAttribute("id", con.getCompanyId());
            elCon.add(this.createCaseFilterMenuItem(all, 0));
            elCon.add(this.createCaseFilterMenuItem(unsent, 1));
            elCon.add(this.createCaseFilterMenuItem(submitted, 2));
        }
        return el;
    }

    private Element createCaseFilterMenuItem(String title, int type) {
        Element el = DocumentHelper.createElement((String)"sub");
        el.setText(title);
        el.addAttribute("type", String.valueOf(type));
        return el;
    }

    protected String createViewTitle(String[] data) {
        String title = this.resourceBundle.getString("my.title");
        if (data != null) {
            for (String entry : data) {
                title = title + " / " + entry;
            }
        }
        return title;
    }

    private Hashtable<String, List<String>> generatePrimariesHashtable(List<FormTemplate> formPrimaries, List<CaseTemplate> casePrimaries) {
        ArrayList<String> list;
        Hashtable<String, List<String>> ht = new Hashtable<String, List<String>>();
        for (FormTemplate ft : formPrimaries) {
            for (SecondaryForm sf : ft.getSecondaryReferences()) {
                if (ht.containsKey(ft.getId())) {
                    ht.get(ft.getId()).add(sf.getStatusId());
                    continue;
                }
                list = new ArrayList<String>();
                list.add(sf.getStatusId());
                ht.put(ft.getId(), list);
            }
        }
        for (CaseTemplate ct : casePrimaries) {
            for (SecondaryForm sf : ct.getSecondaryReferences()) {
                if (ht.containsKey(ct.getId())) {
                    ht.get(ct.getId()).add(sf.getStatusId());
                    continue;
                }
                list = new ArrayList();
                list.add(sf.getStatusId());
                ht.put(ct.getId(), list);
            }
        }
        return ht;
    }

    private void sortCaseList(List<BaseCase> list, String sortkey, boolean ascending) {
        try {
            SortOption option = SortOption.valueOf(sortkey);
            switch (option) {
                case Title: {
                    Collections.sort(list, new DocumentComparator.CaseTitleComparator(new DocumentComparator()));
                    break;
                }
                case Status: {
                    Collections.sort(list, new DocumentComparator.CaseStatusComparator(new DocumentComparator()));
                    break;
                }
                case Created: {
                    Collections.sort(list, new DocumentComparator.DocumentCreationDateComparator(new DocumentComparator()));
                    break;
                }
                case Modified: {
                    Collections.sort(list, new DocumentComparator.DocumentModifiedDateComparator(new DocumentComparator()));
                    break;
                }
                case DocumentCount: {
                    Collections.sort(list, new DocumentComparator.CaseResponseCountComparator(new DocumentComparator()));
                    break;
                }
                case Reference: {
                    Collections.sort(list, new DocumentComparator.ReferenceNumberComparator(new DocumentComparator()));
                    break;
                }
            }
            if (!ascending) {
                Collections.reverse(list);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static enum SortOption {
        Title,
        Reference,
        DocumentCount,
        Status,
        Created,
        Modified;

    }
}

