/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.LogService;

public class LogoutPage
extends BasePage {
    public static final String pageName = "logout.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            User user = this.getCurrentUser(context);
            AuditLogEntry logoutEntry = new AuditLogEntry();
            logoutEntry.setAction(AuditLogEntry.Action.LOGOUT);
            logoutEntry.setDataType(AuditLogEntry.DataType.USER);
            logoutEntry.setDocumentId(user.getId());
            logoutEntry.setIp(context.getRequest().getRemoteAddr());
            LogService.createLogEntry(logoutEntry);
            boolean isWebSphere = this.isWebSphere(context.getSession().getServletContext());
            if (isWebSphere) {
                String redirectPage = context.getRequest().getContextPath() + "/web/index.html";
                this.dataroot.addElement("websphere").setText("true");
                this.dataroot.addElement("redirect").setText(redirectPage);
            } else {
                HttpSession session = context.getRequest().getSession();
                session.invalidate();
                context.setRedirectURL("index.html");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
        this.doGet(context);
    }

    private final boolean isWebSphere(ServletContext context) {
        String serverInfo = context.getServerInfo();
        if (serverInfo != null) {
            return serverInfo.toLowerCase().contains("websphere");
        }
        return false;
    }
}

