/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.List;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.DocumentSecurityException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class AttachmentPage
extends BasePage {
    private static final boolean isTasksEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("tasks.enabled"));
    public static final String pageName = "attachment.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
        boolean isValidRequest = false;
        String attachmentId = context.getRequest().getParameter("id");
        try {
            ExternalDocument doc;
            if (StringUtil.isValid(attachmentId) && (doc = CaseService.getExternalDocument(attachmentId, false)) != null) {
                List<Task> tasks;
                int otherCount;
                User currentUser = this.getCurrentUser(context);
                DocumentSecurityUtil.validatePermission(doc, currentUser, AccessControl.Permission.READ);
                BaseCase bc = CaseService.getCase(doc.getCaseId());
                Element el = doc.getXml();
                boolean isEditable = DocumentSecurityUtil.getDocumentPermission(AccessControl.Permission.WRITE, currentUser, doc);
                el.addAttribute("edit", String.valueOf(isEditable));
                if (doc.isFromGoPro()) {
                    String caseWorkerTitle = LocaleUtil.getResourceBundle("portal.common", context.getRequest()).getString("sub.caseworker");
                    if (bc != null) {
                        Organization org = ConfigService.getOrganization(bc.getOrganizationId());
                        caseWorkerTitle = caseWorkerTitle + " " + org.getSubject();
                    }
                    el.addElement("author").setText(caseWorkerTitle);
                } else if (!currentUser.getId().equals(doc.getCreatedById())) {
                    User author = UserService.getUser(doc.getCreatedById());
                    if (author != null) {
                        el.addElement("author").setText(author.getFullname());
                    }
                } else {
                    el.addElement("author").setText(currentUser.getFullname());
                }
                boolean signable = false;
                if (doc instanceof Attachment && ((Attachment)doc).isSignaturePending()) {
                    List<User> signersList = ((Attachment)doc).getSignerList();
                    if (BaseDocumentUtil.getDocumentFromList(currentUser.getId(), signersList) != null) {
                        signable = true;
                        for (MetaData mi : doc.getMetadata()) {
                            if (!"Signature.Instance".equals(mi.getKey()) || !currentUser.getId().equals(mi.getUserId())) continue;
                            signable = false;
                            break;
                        }
                    }
                }
                el.addElement("is_signable").setText(Boolean.toString(signable));
                this.dataroot.add(el);
                isValidRequest = true;
                int n = otherCount = bc != null ? bc.getResponseCount() : 0;
                if (isTasksEnabled && !(tasks = TaskService.getTasksByParentDocument(doc.getId())).isEmpty()) {
                    Element elTasks = this.dataroot.addElement("tasks");
                    for (Task task : tasks) {
                        elTasks.add(task.getXml());
                    }
                }
                this.dataroot.addAttribute("othercount", String.valueOf(otherCount));
                if (bc != null) {
                    this.dataroot.add(bc.getXml());
                }
            }
            if (!isValidRequest) {
                this.redirect(context, "mycases.html");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (DocumentSecurityException ex) {
            AuditLogEntry entry = new AuditLogEntry(attachmentId, AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
            try {
                LogService.createLogEntry(entry);
            }
            catch (SelfServiceException sex) {
                throw new BirdException((Exception)sex);
            }
            log.warn(ex.getMessage());
            this.redirect(context, "mycases.html");
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }
}

