/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.data.routing.PickUpQueueEntry;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.filters.RoutingLogFilter;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.QueueService;
import net.gopro.selfservice.util.AdminUtil;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class WebPickUpList
extends WebBaseList {
    private static final int DEFAULT_DAYS_BACK = 1;

    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        try {
            String[] statusList;
            ResourceBundle rb = LocaleUtil.getResourceBundle("admin.admin", context.getSession().getLocale());
            List<Organization> organizationList = ConfigService.getOrganizations();
            BaseDocumentUtil.removeDeletedDocuments(organizationList);
            for (Organization organization : organizationList) {
                if (!RemoteGoPro.GoPro.BROKER_PICKUP.equals((Object)organization.getEndpoint().getGoproType())) continue;
                this.getStaticElement().add(organization.getXml());
            }
            for (String status : statusList = new String[]{"all", "sent", "notsent"}) {
                Element el = this.getStaticElement().addElement("status");
                el.addAttribute("id", status);
                el.setText(rb.getString("qu.status." + status));
            }
            String string = context.getRequest().getParameter("status");
            String organizationId = context.getRequest().getParameter("organization");
            String start = context.getRequest().getParameter("startdate");
            String end = context.getRequest().getParameter("enddate");
            Date startDate = AdminUtil.parseDateString(start, context.getSession().getLocale());
            Date endDate = AdminUtil.parseDateString(end, context.getSession().getLocale());
            if (startDate == null) {
                Calendar yesterday = Calendar.getInstance();
                yesterday.add(5, -1);
                startDate = yesterday.getTime();
            }
            if (endDate == null) {
                Calendar now = Calendar.getInstance();
                endDate = now.getTime();
            }
            Element el = this.getRootElement();
            Dom4JUtil.addElement(el, "status", string);
            Dom4JUtil.addElement(el, "organization", organizationId);
            Dom4JUtil.addElement(el, "startdate", start);
            Dom4JUtil.addElement(el, "enddate", end);
            if (!this.isFilter()) {
                RoutingLogFilter filter = new RoutingLogFilter(startDate, endDate);
                filter.setOrganizationId(organizationId);
                filter.setStatus(string);
                List<PickUpQueueEntry> list = QueueService.getPickUpQueue(filter);
                this.showList(list);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
        try {
            RoutingQueueEntry entry = QueueService.getRoutingQueueEntry(documentId);
            if (entry != null) {
                entry.setDeleted(true);
                QueueService.updateRoutingQueueEntry(entry);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

