/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.FormTemplateException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.TargetgroupService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import org.dom4j.Element;

public class WebFormTemplateList
extends WebBaseList {
    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        try {
            List<Organization> organizationList = ConfigService.getOrganizations();
            BaseDocumentUtil.removeDeletedDocuments(organizationList);
            for (Organization organization : organizationList) {
                if (organization.getFormTemplateCount() <= 0) continue;
                this.getStaticElement().add(organization.getXml());
            }
            List<TargetGroup> targetGroups = TargetgroupService.getTargetGroups();
            for (TargetGroup targetGroup : targetGroups) {
                this.getStaticElement().add(targetGroup.getXml());
            }
            if (!this.isFilter()) {
                List<FormTemplate> list = FormService.getFormTemplates();
                List<FormTranslation> translationsList = FormService.getTranslations();
                this.showFormTemplateList(list, translationsList);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
        try {
            FormService.deleteFormTemplate(documentId);
        }
        catch (FormTemplateException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
        try {
            List<FormTemplate> list = FormService.getFormTemplates(key);
            BaseDocumentUtil.removeDeletedDocuments(list);
            List<FormTranslation> translationsList = FormService.getTranslations();
            this.showFormTemplateList(list, translationsList);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private void showFormTemplateList(Collection<? extends BaseDocument> list, List<FormTranslation> translationsList) throws BirdException {
        BaseDocumentUtil.removeDeletedDocuments(list);
        for (BaseDocument baseDocument : list) {
            List<FormTranslation> availableList = this.filterTranslations(baseDocument.getId(), translationsList);
            if (availableList.size() > 0) {
                Element root = baseDocument.getXml();
                Element elTrans = root.addElement("translations");
                for (FormTranslation ft : availableList) {
                    Element el = elTrans.addElement("item");
                    el.setText(ft.getLanguage());
                    el.addAttribute("iso", ft.getIsocode());
                }
                this.getRootElement().add(root);
                continue;
            }
            this.getRootElement().add(baseDocument.getXml());
        }
    }

    private List<FormTranslation> filterTranslations(String templateId, List<FormTranslation> translationList) {
        ArrayList<FormTranslation> list = new ArrayList<FormTranslation>();
        for (FormTranslation ft : translationList) {
            if (!ft.getTemplateId().equals(templateId) || ft.isDeleted() || !ft.isEnabled()) continue;
            list.add(ft);
        }
        return list;
    }
}

