/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.excel.ExcelData;
import net.gopro.selfservice.excel.ExcelDataRow;
import net.gopro.selfservice.excel.ExcelWriter;
import net.gopro.selfservice.filters.AuditLogFilter;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.util.AdminUtil;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.WordUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebEventLog
extends WebForm {
    private static final ResourceBundle rb = LocaleUtil.getResourceBundle("admin.admin");

    public WebEventLog() {
        this.add(new Field("filter-user-id"));
        this.add(new Field("filter-user-info"));
        this.add(new Field("filter-case-type"));
        this.add(new Field("filter-document-id"));
        this.add(new Field("is-excel", 2));
        this.add(new Field("filter-datatype"));
        this.add(new Field("filter-action"));
        this.add(new Field("startdate"));
        this.add(new Field("enddate"));
    }

    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
    }

    public void doPost(WebContext context) throws BirdException {
        super.doPost(context);
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            String userId = data.getString("filter-user-id");
            String start = data.getString("startdate");
            String end = data.getString("enddate");
            String documentId = data.getString("filter-document-id");
            String action = data.getString("filter-action");
            String datatype = data.getString("filter-datatype");
            String casetype = data.getString("filter-case-type");
            Date dateFrom = AdminUtil.parseDateString(start, context.getSession().getLocale());
            Date dateTo = AdminUtil.parseDateString(end, context.getSession().getLocale());
            AuditLogFilter filter = new AuditLogFilter();
            filter.setDetailedResults(true);
            if (StringUtil.isValid(documentId)) {
                filter.setDocumentId(documentId);
            } else {
                if (StringUtil.isValid(userId)) {
                    filter.addUserId(userId);
                }
                if (StringUtil.isValid(action)) {
                    filter.addAction(AuditLogEntry.Action.valueOf(action));
                }
                if (StringUtil.isValid(datatype)) {
                    filter.addDataType(AuditLogEntry.DataType.valueOf(datatype));
                }
                if (StringUtil.isValid(casetype)) {
                    filter.setFormTemplateId(casetype);
                    filter.addDataType(AuditLogEntry.DataType.CASE);
                    data.put("filter-datatype", AuditLogEntry.DataType.CASE.toString());
                }
                if (dateTo != null) {
                    Calendar calTo = Calendar.getInstance();
                    calTo.setTime(dateTo);
                    calTo.set(11, 23);
                    calTo.set(12, 59);
                    dateTo = calTo.getTime();
                }
                filter.setDateFilter(dateFrom, dateTo);
            }
            if (!filter.isValid()) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
                data.setError(rb.getString("filter.invalid"));
                return;
            }
            AuditLog auditLog = LogService.getAuditLog(filter);
            Element elView = context.getRootElement().addElement("bird_view");
            elView.addAttribute("count", String.valueOf(auditLog.getEntries().size()));
            for (AuditLogEntry entry : auditLog.getEntries()) {
                elView.add(this.getElement(entry));
            }
            if (data.getBoolean("is-excel")) {
                ExcelData excel = new ExcelData(rb.getString("evlog.title"));
                ArrayList<ExcelDataRow> rl = new ArrayList<ExcelDataRow>();
                rl.add(new ExcelDataRow("title", rb.getString("evlog.subject"), 300));
                rl.add(new ExcelDataRow("typex", rb.getString("evlog.datatype")));
                rl.add(new ExcelDataRow("actionx", rb.getString("evlog.action")));
                rl.add(new ExcelDataRow("fullname", rb.getString("evlog.user")));
                rl.add(new ExcelDataRow("timestamp", rb.getString("evlog.stamp"), ExcelDataRow.RowType.DATE));
                List excelList = elView.selectNodes("//entry", ".");
                excel.loadFromXml(rl, excelList);
                ExcelWriter.write(context, excel);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        try {
            Element el;
            Element elStatic = context.getRootElement().addElement("static");
            List<FormTemplate> templateList = FormService.getFormTemplates();
            for (FormTemplate template : templateList) {
                Element el2 = DocumentHelper.createElement((String)"formtemplate");
                el2.addAttribute("id", template.getId());
                el2.addAttribute("deleted", String.valueOf(template.isDeleted()));
                el2.setText(template.getSubject());
                elStatic.add(el2);
            }
            for (AuditLogEntry.DataType dataType : AuditLogEntry.DataType.values()) {
                el = elStatic.addElement("datatype");
                el.addAttribute("id", dataType.toString());
                el.setText(this.getTextValue("dt", dataType.toString()));
            }
            for (Enum enum_ : AuditLogEntry.Action.values()) {
                el = elStatic.addElement("action");
                el.addAttribute("id", enum_.toString());
                el.setText(this.getTextValue("ac", enum_.toString()));
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private Element getElement(AuditLogEntry entry) {
        Element el = entry.getXml();
        Dom4JUtil.addElement(el, "typex", this.getTextValue("dt", entry.getDataType().toString()));
        Dom4JUtil.addElement(el, "actionx", this.getTextValue("ac", entry.getAction().toString()));
        return el;
    }

    private String getTextValue(String prefix, String enumType) {
        try {
            String key = prefix + "." + enumType;
            return rb.getString(key.toLowerCase());
        }
        catch (Exception ex) {
            return WordUtils.capitalize((String)enumType);
        }
    }
}

