/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.ITwoFactorAuthProvider;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class TwoFactorAuthenticationPage
extends WebElementBase {
    public void init(WebContext context) throws BirdException {
        super.init(context);
    }

    public void doGet(WebContext context) throws BirdException {
        Principal principal = context.getRequest().getUserPrincipal();
        if (principal == null) {
            context.setRedirectPage("index.html");
        }
    }

    public void doPost(WebContext context) throws BirdException {
        block27: {
            try {
                User user2;
                Principal principal = context.getRequest().getUserPrincipal();
                if (principal == null) {
                    context.setRedirectPage("index.html");
                    break block27;
                }
                HttpServletResponse res = context.getResponseExclusive();
                OutputFormat format = OutputFormat.createCompactFormat();
                format.setEncoding(SelfServiceEngine.getEncoding());
                format.setSuppressDeclaration(false);
                format.setOmitEncoding(false);
                Document doc = new DocumentFactory().createDocument();
                Element root = doc.addElement("data");
                String JSON = context.getRequest().getParameter("data");
                if (!StringUtil.isValid(JSON)) {
                    throw new IllegalArgumentException("No data was submitted with the request.");
                }
                JSONObject jo = new JSONObject(JSON);
                if (jo.has("token")) {
                    String authToken = jo.getString("token");
                    user2 = UserService.getUserByUsername(principal.getName());
                    MetaData metaToken = user2.getMetaDataByKey("twofactor.userid");
                    if (metaToken != null && !metaToken.isDeleted()) {
                        String userToken = metaToken.getValue();
                        ITwoFactorAuthProvider client = EngineFactory.getCustomEngine(ITwoFactorAuthProvider.class);
                        client.setApiKey(SelfServiceEngine.getConfig("security.twofactor.apikey"));
                        try {
                            boolean isSuccess = client.verify(userToken, authToken);
                            root.addElement("status").setText(isSuccess ? "true" : "false");
                            if (isSuccess) {
                                HttpSession session = context.getRequest().getSession();
                                session.setAttribute("twofactorauth", (Object)true);
                                session.removeAttribute("twofactor.pending");
                            } else {
                                String errorMessage = client.getAuthenticationError();
                                if (StringUtil.isValid(errorMessage)) {
                                    root.addElement("error").setText(errorMessage);
                                }
                            }
                        }
                        catch (SelfServiceException ex) {
                            root.addElement("status").setText("false");
                            root.addElement("error").setText(ex.getMessage());
                        }
                    } else {
                        root.addElement("status").setText("false");
                        root.addElement("error").setText("Two factor user reference was not found!");
                    }
                } else if (jo.has("otp") && jo.getBoolean("otp")) {
                    MetaData metaToken;
                    ITwoFactorAuthProvider.OneTimePassword type = ITwoFactorAuthProvider.OneTimePassword.SMS;
                    if (jo.has("type")) {
                        try {
                            type = ITwoFactorAuthProvider.OneTimePassword.valueOf(jo.getString("type").toUpperCase());
                        }
                        catch (Exception user2) {
                            // empty catch block
                        }
                    }
                    if ((metaToken = (user2 = UserService.getUserByUsername(principal.getName())).getMetaDataByKey("twofactor.userid")) != null && !metaToken.isDeleted()) {
                        String userToken = metaToken.getValue();
                        ITwoFactorAuthProvider client = EngineFactory.getCustomEngine(ITwoFactorAuthProvider.class);
                        client.setApiKey(SelfServiceEngine.getConfig("security.twofactor.apikey"));
                        try {
                            String errorMessage;
                            boolean isSuccess = client.requestOTP(userToken, type);
                            root.addElement("status").setText(isSuccess ? "true" : "false");
                            if (!isSuccess && StringUtil.isValid(errorMessage = client.getAuthenticationError())) {
                                root.addElement("error").setText(errorMessage);
                            }
                        }
                        catch (SelfServiceException ex) {
                            root.addElement("status").setText("false");
                            root.addElement("error").setText(ex.getMessage());
                        }
                    } else {
                        root.addElement("status").setText("false");
                        root.addElement("error").setText("Two factor user reference was not found!");
                    }
                } else if (jo.has("logout") && jo.getBoolean("logout")) {
                    HttpSession session = context.getRequest().getSession();
                    session.invalidate();
                    root.addElement("status").setText("true");
                }
                try {
                    JSONObject json = XML.toJSONObject((String)doc.asXML());
                    res.setContentType("application/json; charset=" + SelfServiceEngine.getEncoding() + "");
                    BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
                    out.write(json.toString().getBytes(SelfServiceEngine.getEncoding()));
                    out.close();
                }
                catch (IOException ex) {
                    throw new BirdException((Exception)ex);
                }
                catch (JSONException ex) {
                    throw new BirdException((Exception)((Object)ex));
                }
            }
            catch (SelfServiceException ex) {
                throw new BirdException((Exception)ex);
            }
        }
    }
}

