/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.net.HttpUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.PrintfFormat;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class RssPage
extends WebElementBase {
    private static final String GENERATOR = "GoPro Self Service";
    private static final String NAMESPACE = "http://purl.org/rss/1.1/";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final OutputFormat outFormat = OutputFormat.createPrettyPrint();
    private static ResourceBundle rb;
    private static String serverUrl;

    public void init(WebContext context) throws BirdException {
        serverUrl = this.getBasetUrl(context.getRequest());
    }

    public void doGet(WebContext context) throws BirdException {
        try {
            DocumentFactory dfact = new DocumentFactory();
            Element root = dfact.createElement("rss");
            root.addNamespace("dc", NAMESPACE);
            root.addAttribute("version", "2.0");
            Document doc = dfact.createDocument(root);
            Element channel = root.addElement("channel");
            channel.addElement("title").addText(SelfServiceEngine.getConfig("web.title"));
            channel.addElement("link").addText(SelfServiceEngine.getConfig("web.domain"));
            channel.addElement("webMaster").addText(SelfServiceEngine.getConfig("web.webmaster"));
            Dom4JUtil.addCDATAElement(channel, "description", rb.getString("channel.desc"));
            channel.addElement("pubDate").addText(dateFormat.format(new Date()));
            channel.addElement("generator").addText(GENERATOR);
            Organization organization = this.getOrganization(context);
            if (organization != null) {
                this.setOrganizationApplications(organization, channel);
            } else {
                this.setOrganizationsList(channel);
            }
            HttpServletResponse res = context.getResponseExclusive();
            res.setContentType("application/xml; charset=UTF-8");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            XMLWriter writer = new XMLWriter((OutputStream)out, outFormat);
            writer.write(doc);
            writer.close();
            out.close();
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private void setOrganizationsList(Element channel) throws SelfServiceException {
        List<Organization> list = ConfigService.getOrganizations();
        BaseDocumentUtil.removeDeletedDocuments(list);
        for (Organization org : list) {
            if (!org.isEnabled() || org.getFormTemplateCount() <= 0) continue;
            Element item = channel.addElement("item");
            item.addElement("title").setText(org.getSubject());
            String url = serverUrl + "web/rss.xml?organization=" + org.getAlias();
            item.addElement("link").setText(url);
            String desc = new PrintfFormat(rb.getString("list.desc")).sprintf(org.getSubject());
            Dom4JUtil.addCDATAElement(item, "description", desc);
            item.addElement("pubDate").setText(dateFormat.format(org.getDateCreated()));
            item.addElement("guid").setText(url);
        }
    }

    private void setOrganizationApplications(Organization organization, Element channel) throws SelfServiceException {
        if (organization != null) {
            List<FormTemplate> list = FormService.getFormTemplates(organization.getId());
            for (FormTemplate template : list) {
                boolean isOpenForAll = true;
                if (template.getExtendedData() != null) {
                    boolean bl = isOpenForAll = template.getExtendedData().getTargetGroupId() == null || "".equals(template.getExtendedData().getTargetGroupId());
                }
                if (template.isDeleted() || !isOpenForAll || !template.isVisible() || !template.isWithinDateRestriction()) continue;
                Element item = channel.addElement("item");
                item.addElement("title").setText(template.getSubject());
                String linkToken = template.getLinkToken(organization.getId());
                String url = serverUrl + "web/portal/application.html?id=" + linkToken;
                item.addElement("link").setText(url);
                item.addElement("guid").setText(url);
                Dom4JUtil.addCDATAElement(item, "description", template.getDescription());
                item.addElement("pubDate").setText(dateFormat.format(template.getDateCreated()));
            }
        }
    }

    private Organization getOrganization(WebContext context) throws SelfServiceException {
        String alias = context.getRequest().getParameter("organization");
        if (StringUtil.isValid(alias)) {
            List<Organization> list = ConfigService.getOrganizations();
            for (Organization o : list) {
                if (o.isDeleted() || !alias.equals(o.getAlias())) continue;
                return o;
            }
        }
        return null;
    }

    private String getBasetUrl(HttpServletRequest req) {
        String url = HttpUtil.getServerURL((HttpServletRequest)req);
        String context = req.getContextPath();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!"".equals(context)) {
            if (context.startsWith("/")) {
                context = context.substring(1, context.length());
            }
            url = url + context + "/";
        }
        return url;
    }

    static {
        outFormat.setEncoding("UTF-8");
        outFormat.setSuppressDeclaration(false);
        outFormat.setOmitEncoding(true);
        rb = LocaleUtil.getResourceBundle("portal.rss");
    }
}

