/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.security.SecureRandom;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.RecoveryTicket;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.services.SecurityService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.PasswordUtil;
import net.gopro.selfservice.util.StringUtil;

public class RecoveryPage
extends WebElementBase {
    private static final String ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%()";

    public void doGet(WebContext context) throws BirdException {
        try {
            User user;
            RecoveryTicket ticket;
            boolean success = false;
            String recoveryId = context.getRequest().getParameter("id");
            if (StringUtil.isValid(recoveryId) && (ticket = SecurityService.getRecoveryTicket(recoveryId)) != null && !ticket.isExpired() && !ticket.isUsed() && (user = UserService.getUser(ticket.getUserId())) != null) {
                String generatedPassword = this.generatePassword(12);
                user.setPassword(PasswordUtil.encryptPassword(generatedPassword));
                user.setTriggerGoProUpdate(false);
                UserService.updateUser(user);
                ticket.setUsed(true);
                SecurityService.updateRecoveryTicket(ticket);
                this.sendNotificationMessage(user, generatedPassword);
                success = true;
            }
            context.getRootElement().addElement("status").setText(success ? "true" : "false");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private final String generatePassword(int length) {
        SecureRandom random = new SecureRandom();
        StringBuilder returnValue = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            returnValue.append(ALPHABET.charAt(random.nextInt(ALPHABET.length())));
        }
        return new String(returnValue);
    }

    private final void sendNotificationMessage(User user, String password) throws SelfServiceException {
        try {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
            String subject = rb.getString("recovery.response.subject");
            String message = rb.getString("recovery.response.body");
            message = Translator.translate((BaseDocument)user, message);
            message = message.replace("[user.password]", password);
            Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.EMAIL, false);
        }
        catch (CommunicationException ex) {
            throw new SelfServiceException(ex);
        }
        catch (MessageException ex) {
            throw new SelfServiceException(ex);
        }
    }
}

