/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import java.util.ResourceBundle;
import net.gopro.selfservice.IFormTemplateRenderer;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.exceptions.FormDeadlineException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LotusFormRenderer
implements IFormTemplateRenderer {
    @Override
    public boolean doRender(WebContext context, Element root, FormTemplate formTemplate, Organization organization) throws SelfServiceException {
        Element el = DocumentHelper.createElement((String)"template");
        el.add(formTemplate.getXml());
        el.add(organization.getXml());
        root.add(el);
        return true;
    }

    @Override
    public boolean doRender(WebContext context, Element root, ApplicationForm form) throws SelfServiceException {
        FormTemplate formTemplate = FormService.getFormTemplate(form.getFormtemplateId(), false);
        Element el = DocumentHelper.createElement((String)"template");
        el.add(form.getXml());
        el.add(formTemplate.getXml());
        root.add(el);
        return true;
    }

    @Override
    public void doSave(WebContext context, Form data, FormTemplate formTemplate, Organization organization, IFormTemplateRenderer.FormStatus status) throws SelfServiceException, FormDeadlineException {
        boolean isFinalized = IFormTemplateRenderer.FormStatus.SEND.equals((Object)status);
        if (isFinalized && formTemplate.isDateRestricted() && !formTemplate.isWithinDateRestriction()) {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", context.getRequest());
            throw new FormDeadlineException(rb.getString("form.expired"));
        }
    }

    @Override
    public void doSave(WebContext context, Form data, ApplicationForm form, IFormTemplateRenderer.FormStatus status) throws SaveConflictException, SelfServiceException, FormDeadlineException {
        boolean isFinalized = IFormTemplateRenderer.FormStatus.SEND.equals((Object)status);
        FormTemplate formTemplate = FormService.getFormTemplate(form.getFormtemplateId(), false);
        if (isFinalized && formTemplate.isDateRestricted() && !formTemplate.isWithinDateRestriction()) {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", context.getRequest());
            throw new FormDeadlineException(rb.getString("form.expired"));
        }
    }
}

