/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import is.hugvit.bird.WebContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.Principal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.impl.renderers.GoProFormHelper;
import net.gopro.selfservice.impl.renderers.GoProFormRenderer;
import net.gopro.selfservice.impl.renderers.GoProFormV2Processor;
import net.gopro.selfservice.impl.renderers.IGoProFormProcessor;
import net.gopro.selfservice.pdf.FOPTransformer;
import net.gopro.selfservice.pdf.PDFProperties;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.SaxReader;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class GoProFormV2Renderer
extends GoProFormRenderer {
    private static Logger logger = Logger.getLogger(GoProFormV2Renderer.class);

    @Override
    protected String transformDocument(WebContext context, FormTemplateFile xml, FormTemplateFile xsl) throws SelfServiceException {
        try {
            if (FormTemplateFile.Tag.READ.equals((Object)xsl.getTag())) {
                SAXReader reader = SaxReader.createReader();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getStream());
                Document doc = reader.read((InputStream)in);
                this.setVisibility(doc);
                xml.setStream(doc.asXML().getBytes("UTF-8"));
            }
            ByteArrayInputStream xmlFile = new ByteArrayInputStream(xml.getStream());
            StreamSource sXml = new StreamSource(xmlFile);
            StreamSource sXsl = null;
            if (this.overrideXsl()) {
                InputStream in = null;
                String targetLocation = null;
                targetLocation = xsl.getTag().equals((Object)FormTemplateFile.Tag.EDIT) ? "/WEB-INF/" + SelfServiceEngine.getConfig("goproforms.v2.xsl.edit") : "/WEB-INF/" + SelfServiceEngine.getConfig("goproforms.v2.xsl.read");
                in = context.getSession().getServletContext().getResourceAsStream(targetLocation);
                if (in == null) {
                    throw new SelfServiceException("The XSL template " + targetLocation + " is missing!");
                }
                sXsl = new StreamSource(in);
            } else {
                ByteArrayInputStream xslFile = new ByteArrayInputStream(xsl.getStream());
                sXsl = new StreamSource(xslFile);
            }
            StringWriter strWriter = new StringWriter();
            TransformerFactory tFactory = null;
            if (SelfServiceEngine.getBirdSession().getConfig().containsKey("xsl_class")) {
                try {
                    String className = (String)SelfServiceEngine.getBirdSession().getConfig().get("xsl_class");
                    tFactory = (TransformerFactory)Class.forName(className).newInstance();
                }
                catch (Exception ex) {
                    tFactory = TransformerFactory.newInstance();
                }
            } else {
                TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
            }
            Transformer transformer = tFactory.newTransformer(sXsl);
            String basePath = this.getFilesSystemPath(context, "/WEB-INF/selfservice/v2");
            logger.debug((Object)("Setting transformation basepath as: " + basePath));
            File fileBase = new File(basePath);
            logger.debug((Object)("Setting transformation file basepath as: " + fileBase.toURI().toString()));
            transformer.setParameter("path", fileBase.toURI().toString());
            transformer.transform(sXml, new StreamResult(strWriter));
            return strWriter.toString();
        }
        catch (Exception ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    protected byte[] transFormToPDF(PDFProperties properties, Document doc, FormTemplateExtras.XSLFoType fo) throws SelfServiceException {
        this.setVisibility(doc);
        FOPTransformer trans = new FOPTransformer(properties);
        return trans.transFormToPDF(doc, fo, GoProFormTemplate.GoProFormType.GOPRO_FORM_V2);
    }

    @Override
    protected IGoProFormProcessor getFormProcessor() throws SelfServiceException {
        return new GoProFormV2Processor();
    }

    @Override
    protected void computeValues(WebContext context, FormTemplate ft, FormTemplateFile ff) throws SelfServiceException {
        try {
            Principal principal = context.getRequest().getUserPrincipal();
            User user = UserService.getUserByUsername(principal.getName());
            Company com = null;
            SAXReader reader = SaxReader.createReader();
            ByteArrayInputStream is = new ByteArrayInputStream(ff.getStream());
            Document doc = reader.read((InputStream)is);
            is.close();
            HashMap<String, String> uris = new HashMap<String, String>();
            uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
            XPath xpath = doc.createXPath("//gpf:input/gpf:value|//gpf:textarea/gpf:value");
            xpath.setNamespaceURIs(uris);
            List list = xpath.selectNodes((Object)doc);
            if (list != null && list.size() > 0) {
                Iterator it = list.iterator();
                if (user.isContact()) {
                    com = UserService.getCompany(user.getContactCompanyIds().get(0));
                }
                while (it.hasNext()) {
                    Element el = (Element)it.next();
                    String val = el.getText();
                    if (val == null || !val.startsWith("[") || !val.endsWith("]")) continue;
                    String value = "";
                    if (val.toLowerCase().startsWith("[form.")) {
                        value = GoProFormHelper.getComputedValue(val, ft);
                    } else if (val.toLowerCase().contains("company") && user.isContact()) {
                        if (com == null) {
                            com = UserService.getCompany(user.getContactCompanyIds().get(0));
                        }
                        if (com != null) {
                            value = GoProFormHelper.getComputedValue(val, com, GoProFormTemplate.GoProFormType.GOPRO_FORM_V2);
                        }
                    } else {
                        value = GoProFormHelper.getComputedValue(val, user, GoProFormTemplate.GoProFormType.GOPRO_FORM_V2);
                    }
                    if (value == null) {
                        value = "";
                    }
                    el.setText(value);
                }
                ff.setStream(doc.asXML().getBytes("UTF-8"));
            }
        }
        catch (DocumentException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private String getFilesSystemPath(WebContext context, String innerPath) {
        return context.getRequest().getServletContext().getRealPath(innerPath);
    }

    private void setVisibility(Document doc) {
        NumberFormat nf = NumberFormat.getInstance();
        ArrayList<String> markedVisible = new ArrayList<String>();
        HashMap<String, String> uris = new HashMap<String, String>();
        uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
        XPath xpath = doc.createXPath("//gpf:visibility");
        xpath.setNamespaceURIs(uris);
        List visibilityNodes = xpath.selectNodes((Object)doc);
        if (visibilityNodes != null && visibilityNodes.size() > 0) {
            for (Element node : visibilityNodes) {
                String comparison = node.valueOf("@comparison");
                String fieldId = node.valueOf("@field");
                xpath = node.createXPath("gpf:visibleIf | gpf:hiddenIf");
                xpath.setNamespaceURIs(uris);
                Node conditionNode = xpath.selectSingleNode((Object)node);
                if (conditionNode == null) continue;
                xpath = node.createXPath("gpf:option[@selected='true'] | gpf:optionGroup/gpf:option[@selected='true'] | gpf:value");
                xpath.setNamespaceURIs(uris);
                List valueNodes = new ArrayList<Node>();
                if ("selection".equals(node.getParent().getName()) && ("Checkbox".equals(node.getParent().valueOf("@type")) || "Select".equals(node.getParent().valueOf("@type")) && "true".equalsIgnoreCase(node.getParent().valueOf("@multiple")))) {
                    valueNodes = xpath.selectNodes((Object)node.getParent());
                } else {
                    valueNodes.add(xpath.selectSingleNode((Object)node.getParent()));
                }
                boolean isMultiCondition = valueNodes.size() > 1;
                for (Node valueNode : valueNodes) {
                    Number conditionNumber;
                    Number valueNumber;
                    if (valueNode == null || valueNode.getText() == null || conditionNode.getText() == null) continue;
                    String nodeValue = valueNode.getText();
                    if (valueNode.valueOf("@value") != null) {
                        nodeValue = valueNode.valueOf("@value");
                    }
                    String conditionValue = conditionNode.getText();
                    String xpathQuery = String.format("//gpf:*[@id='%s']", fieldId);
                    xpath = conditionNode.createXPath(xpathQuery);
                    xpath.setNamespaceURIs(uris);
                    Node targetNode = xpath.selectSingleNode((Object)conditionNode);
                    if (targetNode == null) {
                        logger.warn((Object)"Target Node for visibility is invalid.  Ignoring visibility element.");
                        continue;
                    }
                    if ("Equals".equalsIgnoreCase(comparison)) {
                        if (conditionValue.equalsIgnoreCase(nodeValue)) {
                            if ("hiddenIf".equalsIgnoreCase(conditionNode.getName())) {
                                ((Element)targetNode).addAttribute("no-print", "true");
                                continue;
                            }
                            if (!isMultiCondition) continue;
                            markedVisible.add(targetNode.valueOf("@id"));
                            ((Element)targetNode).addAttribute("no-print", "false");
                            continue;
                        }
                        if (!"visibleIf".equalsIgnoreCase(conditionNode.getName()) || isMultiCondition && markedVisible.contains(targetNode.valueOf("@id"))) continue;
                        ((Element)targetNode).addAttribute("no-print", "true");
                        continue;
                    }
                    if ("NotEquals".equalsIgnoreCase(comparison)) {
                        if (conditionValue.equalsIgnoreCase(nodeValue)) {
                            if (!"visibleIf".equalsIgnoreCase(conditionNode.getName())) continue;
                            ((Element)targetNode).addAttribute("no-print", "true");
                            continue;
                        }
                        if (!"hiddenIf".equalsIgnoreCase(conditionNode.getName())) continue;
                        ((Element)targetNode).addAttribute("no-print", "true");
                        continue;
                    }
                    if ("Greater".equalsIgnoreCase(comparison)) {
                        try {
                            valueNumber = nf.parse(nodeValue);
                            conditionNumber = NumberFormat.getNumberInstance().parse(conditionValue);
                            if (valueNumber.floatValue() > conditionNumber.floatValue()) {
                                if (!"hiddenIf".equalsIgnoreCase(conditionNode.getName())) continue;
                                ((Element)targetNode).addAttribute("no-print", "true");
                                continue;
                            }
                            if (!"visibleIf".equalsIgnoreCase(conditionNode.getName())) continue;
                            ((Element)targetNode).addAttribute("no-print", "true");
                        }
                        catch (Exception ex) {
                            logger.warn((Object)ex);
                        }
                        continue;
                    }
                    if (!"Less".equalsIgnoreCase(comparison)) continue;
                    try {
                        valueNumber = nf.parse(nodeValue);
                        conditionNumber = NumberFormat.getNumberInstance().parse(conditionValue);
                        if (valueNumber.floatValue() > conditionNumber.floatValue()) {
                            if (!"hiddenIf".equalsIgnoreCase(conditionNode.getName())) continue;
                            ((Element)targetNode).addAttribute("no-print", "true");
                            continue;
                        }
                        if (!"visibleIf".equalsIgnoreCase(conditionNode.getName())) continue;
                        ((Element)targetNode).addAttribute("no-print", "true");
                    }
                    catch (Exception ex) {
                        logger.warn((Object)ex);
                    }
                }
            }
        }
    }
}

