/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import is.hugvit.bird.Form;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.FormTranslationFactory;
import net.gopro.selfservice.forms.IFormTranslation;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.impl.renderers.BaseGoProFormProcessor;
import net.gopro.selfservice.impl.renderers.IGoProFormProcessor;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.SaxReader;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class GoProFormV1Processor
extends BaseGoProFormProcessor
implements IGoProFormProcessor {
    @Override
    public Document processForm(ApplicationForm form, FormCase fc, Form data) throws SelfServiceException {
        return this.processForm(form.getAsFormTemplateFile(), fc, data);
    }

    @Override
    public Document processForm(FormTemplate template, FormCase fc, Form data, String languageId) throws SelfServiceException {
        try {
            FormTemplateFile templateData = this.getTemplateDataFile(template);
            if (StringUtil.isValid(languageId)) {
                BaseDocument trans = null;
                for (FormTranslation translation : template.getTranslations()) {
                    if (!translation.getIsocode().equals(languageId) || !translation.isEnabled()) continue;
                    trans = translation;
                    break;
                }
                if (trans != null) {
                    FormTranslation translation = FormService.getTranslation(trans.getId());
                    Document translationDocument = FormsUtil.createDocument(translation.getStream());
                    IFormTranslation ift = FormTranslationFactory.getInstance(template);
                    Document translatedTemplate = ift.translateForm(templateData, translationDocument);
                    templateData.setStream(translatedTemplate.asXML().getBytes("UTF-8"));
                }
            }
            return this.processForm(templateData, fc, data);
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public int processFileAttachments(Document doc, Form data, FormCase fc, ApplicationForm form) throws SelfServiceException, CaseException {
        int attachmentCount = 0;
        List uploadNodes = doc.selectNodes("//SECTIONS/SECTION/FIELDS/FIELD[@TYPE='FILE']", ".");
        if (uploadNodes != null && uploadNodes.size() > 0) {
            Document lastDoc = null;
            try {
                SAXReader reader = SaxReader.createReader();
                ByteArrayInputStream is = new ByteArrayInputStream(form.getStream());
                lastDoc = reader.read((InputStream)is);
                is.close();
            }
            catch (DocumentException ex) {
                throw new SelfServiceException((Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SelfServiceException(ex);
            }
            catch (SAXException ex) {
                throw new SelfServiceException(ex);
            }
            for (Element el : uploadNodes) {
                String fileId = el.valueOf("@ID");
                try {
                    String attachmentId;
                    SubDocument aa;
                    String xQuery;
                    Node node;
                    InputStream in = data.getInputStream(fileId);
                    if (in != null && in.available() > 0) {
                        Attachment att = new Attachment();
                        att.setCaseId(fc.getId());
                        String filename = data.getFilename(fileId);
                        att.setFilename(filename);
                        att.setFilesize(in.available());
                        String mimetype = SelfServiceEngine.getContext().getMimeType(att.getFilename());
                        if (mimetype == null) {
                            mimetype = "application/octet-stream";
                        }
                        att.setMimetype(mimetype);
                        byte[] bytes = new byte[in.available()];
                        in.read(bytes);
                        in.close();
                        att.setStream(bytes);
                        att.setSubject(Util.changeFileExt((String)att.getFilename(), (String)""));
                        String attachmentId2 = UID.getUID();
                        att.setId(attachmentId2);
                        ++attachmentCount;
                        fc.addSubDocument(att);
                        Node attachmentIdNode = el.selectSingleNode("VALUE");
                        if (attachmentIdNode == null) {
                            attachmentIdNode = el.addElement("VALUE").addText(attachmentId2);
                            continue;
                        }
                        attachmentIdNode.setText(attachmentId2);
                        continue;
                    }
                    if (lastDoc == null || (node = lastDoc.selectSingleNode(xQuery = "//SECTIONS/SECTION/FIELDS/FIELD[@TYPE='FILE' and @ID='" + fileId + "']/VALUE")) == null || (aa = CaseService.getSubDocument(attachmentId = node.getText(), false)) == null) continue;
                    Node attachmentIdNode = el.selectSingleNode("VALUE");
                    if (attachmentIdNode == null) {
                        attachmentIdNode = el.addElement("VALUE").addText(attachmentId);
                        continue;
                    }
                    attachmentIdNode.setText(attachmentId);
                }
                catch (IOException ex) {
                    throw new SelfServiceException(ex);
                }
            }
        }
        return attachmentCount;
    }

    private Document processForm(FormTemplateFile template, FormCase fc, Form data) throws SelfServiceException {
        Document doc = this.getDocumentFromTemplate(template);
        List formNodes = doc.selectNodes("//SECTIONS/SECTION/FIELDS/FIELD", ".");
        Iterator nodeIt = formNodes.iterator();
        Hashtable map = data.getHashtable();
        this.sanitizeMapValues(map);
        while (nodeIt.hasNext()) {
            Node fieldNode = (Node)nodeIt.next();
            String fieldId = fieldNode.valueOf("@ID");
            String fieldName = fieldNode.valueOf("@NAME");
            String fieldType = fieldNode.valueOf("@TYPE");
            Object value = map.get(fieldId);
            if (value == null) {
                value = map.get(fieldName);
            }
            if (fieldType.equals(GoProFormTemplate.FieldType.CHECKBOX.toString())) {
                Enumeration e = map.keys();
                Vector<String> v = new Vector<String>();
                while (e.hasMoreElements()) {
                    String key = e.nextElement().toString();
                    if (!key.startsWith(fieldName) || key.contains("repeater")) continue;
                    v.add((String)map.get(key));
                }
                value = v;
            }
            if (fieldType.equals(GoProFormTemplate.FieldType.MATRIX.toString())) {
                value = this.processMatrixNode(fieldNode, data);
            }
            if (fieldType.equals(GoProFormTemplate.FieldType.BLOCK.toString())) {
                List blockFields = fieldNode.selectNodes("BLOCKFIELDS/FIELD", ".");
                for (Node blockNode : blockFields) {
                    fieldId = blockNode.valueOf("@ID");
                    fieldName = blockNode.valueOf("@NAME");
                    fieldType = blockNode.valueOf("@TYPE");
                    value = map.get(fieldId);
                    if (value == null) {
                        value = map.get(fieldName);
                    }
                    if (fieldType.equals(GoProFormTemplate.FieldType.CHECKBOX.toString())) {
                        Enumeration e = map.keys();
                        Vector<String> v = new Vector<String>();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement().toString();
                            if (!key.startsWith(fieldName)) continue;
                            v.add((String)map.get(key));
                        }
                        value = v;
                    }
                    this.processNode(blockNode, value, fieldType);
                }
            }
            this.processNode(fieldNode, value, fieldType);
        }
        this.processRepeatableSections(doc, fc, data);
        return doc;
    }

    private void addTextValue(Node node, String textValue, boolean selected) {
        Node valueNode = node.selectSingleNode("VALUE");
        if (valueNode == null) {
            valueNode = ((Element)node).addElement("VALUE").addText(textValue);
        } else {
            valueNode.setText(textValue);
        }
        if (selected) {
            ((Element)valueNode).addAttribute("SELECTED", "YES");
        }
    }

    private final void processNode(Node node, Object value, String type) {
        if (value != null) {
            GoProFormTemplate.FieldType fieldType;
            try {
                fieldType = GoProFormTemplate.FieldType.valueOf(type);
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)("Unsupported FieldType: " + type));
                return;
            }
            String textValue = "";
            if (value instanceof String) {
                textValue = (String)value;
            } else if (value instanceof Vector) {
                textValue = Util.expand((Vector)((Vector)value), (String)", ");
            } else if (!(value instanceof HashMap)) {
                value = value.toString();
            }
            switch (fieldType) {
                case TEXT: 
                case TEXTAREA: 
                case DATE: {
                    this.addTextValue(node, textValue, false);
                    break;
                }
                case LISTBOX: 
                case BLOCKHEADER: 
                case RADIO: {
                    boolean found = false;
                    if (value != "") {
                        List values = node.selectNodes("VALUE");
                        for (Element el : values) {
                            Attribute att = (Attribute)el.selectSingleNode("@SELECTED");
                            if (att == null) continue;
                            el.remove(att);
                        }
                        for (Element el : values) {
                            Iterator iter = el.attributeIterator();
                            while (iter.hasNext()) {
                                Attribute att = (Attribute)iter.next();
                                if (!att.getName().toLowerCase().equals("ALIAS".toLowerCase()) || !att.getText().equals(value)) continue;
                                found = true;
                            }
                            if (!found) continue;
                            el.addAttribute("SELECTED", "YES");
                            break;
                        }
                    }
                    if (found) break;
                    this.addTextValue(node, textValue, true);
                    break;
                }
                case CHECKBOX: {
                    List values = node.selectNodes("VALUE");
                    for (Element el : values) {
                        Attribute at = el.attribute("SELECTED");
                        if (at == null) continue;
                        el.remove(at);
                    }
                    if (!(value instanceof Vector) || ((Vector)value).size() <= 0) break;
                    Vector v = (Vector)value;
                    for (Element el : values) {
                        if (!v.contains(el.getText())) continue;
                        el.addAttribute("SELECTED", "YES");
                    }
                    break;
                }
                case MATRIX: {
                    if (!(value instanceof HashMap)) break;
                    HashMap map = (HashMap)value;
                    Set set = map.keySet();
                    List list = node.selectNodes("VALUES/VALUE");
                    if (list == null || list.size() == 0) {
                        Element root = ((Element)node).addElement("VALUES");
                        for (String key : set) {
                            Element el = root.addElement("VALUE");
                            el.addAttribute("KEY", key);
                            el.addText((String)map.get(key));
                        }
                    } else {
                        Element root = (Element)node.selectSingleNode("VALUES");
                        for (String key : set) {
                            Node target = root.selectSingleNode("VALUE[@KEY='" + key + "']");
                            if (target != null) {
                                target.setText((String)map.get(key));
                                continue;
                            }
                            root.addElement("VALUE").addAttribute("KEY", key).addText((String)map.get(key));
                        }
                    }
                    break;
                }
            }
        }
    }

    private final int processRepeatableSections(Document doc, FormCase fc, Form data) throws SelfServiceException {
        int attachmentCount = 0;
        List sections = doc.selectNodes("//SECTIONS/SECTION[@REPEATABLE = 'yes']");
        Iterator sectionIt = sections.iterator();
        Hashtable ht = data.getHashtable();
        Hashtable htFiles = data.getHtFiles();
        ArrayList<RepeatableSectionItem> itemList = null;
        while (sectionIt.hasNext()) {
            Node setNode;
            RepeatableSectionItem rsi2;
            String dataKey;
            Node sectionNode = (Node)sectionIt.next();
            String sectionId = sectionNode.valueOf("@ID");
            String lookupKey = ":repeater:" + sectionId + ":";
            itemList = new ArrayList<RepeatableSectionItem>();
            for (Object key : ht.keySet()) {
                dataKey = (String)key;
                if (!dataKey.contains(lookupKey) || (rsi2 = this.getRepeatableFieldValue(sectionId, dataKey, ht, doc)) == null) continue;
                itemList.add(rsi2);
            }
            if (htFiles != null) {
                for (Object key : htFiles.keySet()) {
                    dataKey = (String)key;
                    if (!dataKey.contains(lookupKey) || (rsi2 = this.getRepeatableFileValue(sectionId, dataKey, htFiles, doc, fc, data)) == null) continue;
                    itemList.add(rsi2);
                    ++attachmentCount;
                }
            }
            if ((setNode = sectionNode.selectSingleNode("VALUES")) != null) {
                setNode.detach();
            }
            if (itemList.size() <= 0) continue;
            Element el = ((Element)sectionNode).addElement("VALUES");
            for (RepeatableSectionItem rsi2 : itemList) {
                Node node = el.selectSingleNode("SET[@INDEX='" + rsi2.getRowIndex() + "']");
                if (node == null) {
                    node = el.addElement("SET").addAttribute("INDEX", String.valueOf(rsi2.getRowIndex()));
                }
                ((Element)node).add(rsi2.getXml());
            }
        }
        return attachmentCount;
    }

    private final HashMap<String, String> processMatrixNode(Node node, Form data) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> fieldlist = new ArrayList<String>();
        Element el = (Element)node;
        List headers = el.selectNodes("HEADERS/HEADER");
        List columns = el.selectNodes("COLUMNS/COLUMN");
        for (Node header : headers) {
            String headerAlias = header.valueOf("@ALIAS");
            for (Node column : columns) {
                String fieldname = column.valueOf("@ALIAS") + "_" + headerAlias;
                Node cbNode = column.selectSingleNode("FIELD[@TYPE='CHECKBOX']");
                if (cbNode != null) {
                    int cbValueCount = cbNode.selectNodes("VALUE").size();
                    Vector<String> cbData = new Vector<String>();
                    for (int i = 1; i <= cbValueCount; ++i) {
                        String cbHtmlName = fieldname + "_" + i;
                        String tmp = data.getString(cbHtmlName);
                        if (tmp == null || "".equals(tmp)) continue;
                        cbData.add(tmp);
                    }
                    map.put(fieldname, Util.expand(cbData, (String)","));
                    continue;
                }
                fieldlist.add(fieldname);
            }
        }
        for (String fieldname : fieldlist) {
            String value = data.getString(fieldname);
            map.put(fieldname, value);
        }
        return map;
    }

    private RepeatableSectionItem getRepeatableFieldValue(String sectionId, String dataKey, Hashtable data, Document doc) {
        RepeatableSectionItem rsi = null;
        Vector vTokens = Util.split((String)dataKey, (String)":");
        Node itemNode = null;
        if ("UPLOADED".equals(vTokens.get(0))) {
            vTokens.remove(0);
            String vDataKey = dataKey.substring(dataKey.indexOf(":") + 1);
            Object fieldValue = data.get(dataKey);
            rsi = new RepeatableSectionItem(vDataKey, fieldValue);
        } else {
            String xPath = "//SECTION[@ID='" + sectionId + "']/FIELDS/FIELD[@NAME='" + (String)vTokens.get(0) + "']";
            itemNode = doc.selectSingleNode(xPath);
            GoProFormTemplate.FieldType fieldType = null;
            if (itemNode != null) {
                fieldType = GoProFormTemplate.FieldType.valueOf(itemNode.valueOf("@TYPE"));
            }
            if (fieldType != null) {
                Object fieldValue = data.get(dataKey);
                if (GoProFormTemplate.FieldType.CHECKBOX.equals((Object)fieldType)) {
                    String checkKey = dataKey.substring(0, dataKey.lastIndexOf("_"));
                    rsi = new RepeatableSectionItem(checkKey, fieldValue);
                } else {
                    rsi = new RepeatableSectionItem(dataKey, fieldValue);
                }
            } else {
                logger.warn((Object)("Repeatable section: NULL fieldtype: " + xPath));
            }
        }
        return rsi;
    }

    private RepeatableSectionItem getRepeatableFileValue(String sectionId, String dataKey, Hashtable fileData, Document doc, FormCase fc, Form data) throws SelfServiceException {
        RepeatableSectionItem rsi = null;
        Vector vTokens = Util.split((String)dataKey, (String)":");
        String xPath = "//SECTION[@ID='" + sectionId + "']/FIELDS/FIELD[@NAME='" + (String)vTokens.get(0) + "']";
        Node itemNode = doc.selectSingleNode(xPath);
        GoProFormTemplate.FieldType fieldType = null;
        if (itemNode != null) {
            fieldType = GoProFormTemplate.FieldType.valueOf(itemNode.valueOf("@TYPE"));
        }
        if (fieldType != null) {
            String fieldValue = null;
            String fileId = dataKey;
            String filename = this.getFilename(fileData.get(fileId));
            try {
                InputStream in = data.getInputStream(fileId);
                if (in != null && in.available() > 0) {
                    Attachment att = new Attachment();
                    att.setCaseId(fc.getId());
                    att.setFilename(filename);
                    att.setFilesize(in.available());
                    String mimetype = SelfServiceEngine.getContext().getMimeType(att.getFilename());
                    if (mimetype == null) {
                        mimetype = "application/octet-stream";
                    }
                    att.setMimetype(mimetype);
                    byte[] bytes = new byte[in.available()];
                    in.read(bytes);
                    in.close();
                    att.setStream(bytes);
                    att.setSubject(Util.changeFileExt((String)att.getFilename(), (String)""));
                    String attachmentId = UID.getUID();
                    att.setId(attachmentId);
                    fc.addSubDocument(att);
                    fieldValue = attachmentId;
                }
            }
            catch (IOException ex) {
                throw new SelfServiceException(ex);
            }
            rsi = new RepeatableSectionItem(dataKey, fieldValue);
        } else {
            logger.warn((Object)("Repeatable section: NULL fieldtype: " + xPath));
        }
        return rsi;
    }

    private class RepeatableSectionItem {
        private int rowIndex;
        private String key;
        private String value;
        private String sectionId;

        public RepeatableSectionItem(String s, Object value) {
            this.value = (String)value;
            this.populate(s);
        }

        private void populate(String s) {
            Vector v = Util.split((String)s, (String)":");
            if (v.size() == 4) {
                this.key = (String)v.get(0);
                this.sectionId = (String)v.get(2);
                this.rowIndex = Integer.valueOf((String)v.get(3));
            }
        }

        public String toString() {
            return this.rowIndex + " : " + this.sectionId + " : " + this.key + " : " + this.value;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public Element getXml() {
            Element el = DocumentHelper.createElement((String)"VALUE");
            el.addAttribute("KEY", this.key);
            String v = this.value;
            if (v == null) {
                v = "";
            }
            el.setText(v);
            return el;
        }
    }
}

