/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.IMessageEngine;
import net.gopro.selfservice.ITargetGroupEngine;
import net.gopro.selfservice.IUserEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.dalc.MessageDalc;
import net.gopro.selfservice.data.Announcement;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.impl.BaseImpl;

public class MessageImpl
extends BaseImpl
implements IMessageEngine {
    protected MessageDalc dalc;
    protected ITargetGroupEngine targetgroupEngine;
    protected IUserEngine userEngine;

    public MessageImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new MessageDalc();
        this.targetgroupEngine = EngineFactory.getTargetGroupEngine();
        this.userEngine = EngineFactory.getUserEngine();
    }

    @Override
    public void createMessage(Message message) throws MessageException, SelfServiceException {
        this.throwIfNull(message, "Message is null");
        try {
            this.throwIfNotValid(message.getRecipientId(), "The recipient Id is missing");
            this.throwIfNotValid(message.getSubject(), "Message subject is missing");
            this.throwIfNotValid(message.getBody(), "Message body is null or empty");
            this.assertStringLength(message.getSubject(), 255);
            this.assertStringLength(message.getSenderName(), 128);
            if (!this.isValid(message.getSenderName())) {
                message.setSenderName("administrator");
            }
            if (!this.isValid(message.getCreatedById())) {
                message.setCreatedById("0037EAAB42E3551100000121168DB847");
            }
            this.checkDocumentId(message);
            this.dalc.createMessage(message);
            this.createMetaData(message, this.dalc);
            this.logAction(message.getId(), AuditLogEntry.DataType.MESSAGE, AuditLogEntry.Action.CREATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new MessageException(ex);
        }
    }

    @Override
    public void deleteMessage(String messageId) throws MessageException, SelfServiceException {
        Message m = this.getMessage(messageId);
        if (m == null) {
            throw new SelfServiceException("Invalid message Id");
        }
        m.setDeleted(true);
        this.updateMessage(m);
        this.logAction(messageId, AuditLogEntry.DataType.MESSAGE, AuditLogEntry.Action.DELETE);
    }

    @Override
    public Message getMessage(String messageId) throws SelfServiceException {
        try {
            Message message = this.dalc.getMessage(messageId);
            if (message != null) {
                this.setMetaData(message, this.dalc);
                this.logAction(messageId, AuditLogEntry.DataType.MESSAGE, AuditLogEntry.Action.READ);
            }
            return message;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<Message> getMessages(String userId) throws SelfServiceException {
        try {
            List<Message> list = this.dalc.getMessages(userId);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<Message> getMessages(String userId, Date dateSince) throws SelfServiceException {
        try {
            if (dateSince != null) {
                return this.dalc.getMessages(userId, dateSince);
            }
            return new ArrayList<Message>();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void markMessageRead(String messageId) throws MessageException, SelfServiceException {
        Message message = this.getMessage(messageId);
        if (message == null) {
            throw new SelfServiceException("Invalid message Id");
        }
        message.setRead(true);
        this.updateMessage(message);
        this.logAction(messageId, AuditLogEntry.DataType.MESSAGE, AuditLogEntry.Action.READ);
    }

    @Override
    public void updateMessage(Message message) throws MessageException, SelfServiceException {
        this.throwIfNull(message, "Message is null");
        try {
            this.throwIfNotValid(message.getRecipientId(), "The recipient Id is missing");
            this.throwIfNotValid(message.getSubject(), "Message subject is missing");
            this.throwIfNotValid(message.getBody(), "Message body is null or empty");
            this.assertStringLength(message.getSubject(), 255);
            this.assertStringLength(message.getSenderName(), 128);
            message.setDateModified(new Date().getTime());
            this.dalc.updateMessage(message);
            this.logAction(message.getId(), AuditLogEntry.DataType.MESSAGE, AuditLogEntry.Action.UPDATE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new MessageException(ex);
        }
    }

    @Override
    public int getUnreadMessageCount(String userId) throws SelfServiceException {
        try {
            return this.dalc.getUnreadMessageCount(userId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void markAllMessagesRead(String userId) throws SelfServiceException {
        this.throwIfNull(userId, "Invalid User Id");
        try {
            this.dalc.markAllMessagesRead(userId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createAnnouncement(Announcement ann, boolean send) throws SelfServiceException, TargetGroupException, CommunicationException, MessageException {
        this.throwIfNull(ann, "The announcement cannot be null");
        try {
            this.throwIfNotValid(ann.getSubject(), "The subject is missing");
            this.throwIfNotValid(ann.getBody(), "The announcement body is missing");
            this.throwIfNotValid(ann.getTargetGroupId(), "No targetgroup has been set");
            this.assertStringLength(ann.getSubject(), 255);
            if (!ann.isEmail() && !ann.isInternal()) {
                throw new IllegalArgumentException("At least one delivery method must be selected");
            }
            TargetGroup targetgroup = this.targetgroupEngine.getTargetGroup(ann.getTargetGroupId(), true);
            if (targetgroup == null) {
                Company com = this.userEngine.getCompany(ann.getTargetGroupId());
                if (com == null) {
                    throw new SelfServiceException("The specified target group/company was not found");
                }
                TargetGroup contactGroup = new TargetGroup();
                contactGroup.setGenerator(TargetGroup.Generator.CONTACTS);
                contactGroup.setCompanyId(com.getId());
                contactGroup.setSubject(com.getName() + " / (" + new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date()) + ")");
                contactGroup.getGroupUsers().addAll(this.getContactsAsTargetGroupUsers(com));
                contactGroup.setDescription("Generated group based on company contacts.");
                this.targetgroupEngine.createTargetGroup(contactGroup);
                targetgroup = contactGroup;
                ann.setTargetGroupId(contactGroup.getId());
            }
            ann.setRecipientCount(targetgroup.getGroupUsers().size());
            if (send) {
                ann.setDateSent(new Date().getTime());
            }
            this.checkDocumentId(ann);
            this.dalc.createAnnouncement(ann);
            this.createMetaData(ann, this.dalc);
            this.logAction(ann.getId(), AuditLogEntry.DataType.ANNOUNCEMENT, AuditLogEntry.Action.CREATE);
            if (send) {
                this.sendAnnouncement(ann, targetgroup);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteAnnouncement(String announcementId) throws SelfServiceException {
        this.throwIfNull(announcementId, "The announcement Id cannot be null");
        try {
            Announcement ann = this.getAnnouncement(announcementId);
            if (ann == null) {
                throw new SelfServiceException("The specified announcement was not found");
            }
            ann.setDateModified(new Date().getTime());
            ann.setDeleted(true);
            this.dalc.updateAnnouncement(ann);
            this.logAction(ann.getId(), AuditLogEntry.DataType.ANNOUNCEMENT, AuditLogEntry.Action.DELETE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Announcement getAnnouncement(String announcementId) throws SelfServiceException {
        try {
            return this.dalc.getAnnouncement(announcementId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<Announcement> getAnnouncements() throws SelfServiceException {
        try {
            return this.dalc.getAnnouncements();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateAnnouncement(Announcement ann, boolean send) throws SelfServiceException, TargetGroupException, CommunicationException, MessageException {
        this.throwIfNull(ann, "The announcement cannot be null");
        try {
            this.throwIfNotValid(ann.getId(), "The announcement Id is missing");
            this.throwIfNotValid(ann.getSubject(), "The subject is missing");
            this.throwIfNotValid(ann.getBody(), "The announcement body is missing");
            this.throwIfNotValid(ann.getTargetGroupId(), "No targetgroup has been set");
            if (!ann.isEmail() && !ann.isInternal()) {
                throw new IllegalArgumentException("At least one delivery method must be selected");
            }
            TargetGroup targetgroup = this.targetgroupEngine.getTargetGroup(ann.getTargetGroupId(), true);
            if (targetgroup == null) {
                Company com = this.userEngine.getCompany(ann.getTargetGroupId());
                if (com == null) {
                    throw new SelfServiceException("The specified target group/company was not found");
                }
                TargetGroup contactGroup = new TargetGroup();
                contactGroup.setGenerator(TargetGroup.Generator.CONTACTS);
                contactGroup.setCompanyId(com.getId());
                contactGroup.setSubject(com.getName() + " / (" + new SimpleDateFormat("yyyy/MM/dd HH:mm").format(new Date()) + ")");
                contactGroup.getGroupUsers().addAll(this.getContactsAsTargetGroupUsers(com));
                contactGroup.setDescription("Generated group based on company contacts.");
                this.targetgroupEngine.createTargetGroup(contactGroup);
                targetgroup = contactGroup;
                ann.setTargetGroupId(contactGroup.getId());
            }
            ann.setRecipientCount(targetgroup.getGroupUsers().size());
            ann.setDateModified(new Date().getTime());
            if (send) {
                ann.setDateSent(new Date().getTime());
            }
            this.dalc.updateAnnouncement(ann);
            this.updateMetaData(ann, this.dalc);
            this.logAction(ann.getId(), AuditLogEntry.DataType.ANNOUNCEMENT, AuditLogEntry.Action.UPDATE);
            if (send) {
                this.sendAnnouncement(ann, targetgroup);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void sendAnnouncement(Announcement ann, TargetGroup targetgroup) throws CommunicationException, SelfServiceException, MessageException {
        Set<TargetGroupUser> targetUsers = targetgroup.getGroupUsers();
        for (TargetGroupUser targetUser : targetUsers) {
            User recipient = this.userEngine.getUser(targetUser.getUserId());
            if (ann.isEmail() && ann.isInternal()) {
                Messenger.sendMessage(recipient, new SimpleMessage(ann.getSubject(), ann.getBody()), User.Communications.EMAIL, true);
                continue;
            }
            if (ann.isEmail() && !ann.isInternal()) {
                Messenger.sendMessage(recipient, new SimpleMessage(ann.getSubject(), ann.getBody()), User.Communications.EMAIL, false);
                continue;
            }
            if (ann.isEmail() || !ann.isInternal()) continue;
            Messenger.sendMessage(recipient, new SimpleMessage(ann.getSubject(), ann.getBody()), User.Communications.NONE, true);
        }
    }

    private List<TargetGroupUser> getContactsAsTargetGroupUsers(Company com) {
        ArrayList<TargetGroupUser> list = new ArrayList<TargetGroupUser>();
        for (User contact : com.getContacts()) {
            if (!contact.isVerified() || contact.isDeleted()) continue;
            list.add(new TargetGroupUser(null, contact.getId()));
        }
        return list;
    }
}

