/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.gopro.selfservice.IConfigEngine;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.ConfigDalc;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.MessageTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Module;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.StatusList;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.datastore.ServiceCache;
import net.gopro.selfservice.exceptions.ConfigException;
import net.gopro.selfservice.exceptions.OrganizationException;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.util.BaseDocumentUtil;

public class ConfigImpl
extends BaseImpl
implements IConfigEngine {
    protected ConfigDalc dalc;

    public ConfigImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new ConfigDalc();
    }

    @Override
    public void createConfig(ConfigEntry entry) throws ConfigException, SelfServiceException {
        this.throwIfNull(entry, "Config entry is null");
        try {
            this.throwIfNotValid(entry.getKey(), "Config key is missing");
            this.throwIfNotValid(entry.getValue(), "Config value is missing");
            this.assertStringLength(entry.getKey(), 64);
            this.assertStringLength(entry.getValue(), 255);
            this.assertStringLength(entry.getSection(), 64);
            BaseDocument deletedEntry = null;
            Set<ConfigEntry> config = this.dalc.getConfig(true);
            for (ConfigEntry ce : config) {
                if (!ce.getKey().equalsIgnoreCase(entry.getKey())) continue;
                if (ce.isDeleted()) {
                    deletedEntry = ce;
                    continue;
                }
                throw new SelfServiceException("Key " + entry.getKey() + " is already defined");
            }
            if (deletedEntry != null) {
                deletedEntry.setDeleted(false);
                ((ConfigEntry)deletedEntry).setValue(entry.getValue());
                ((ConfigEntry)deletedEntry).setSection(entry.getSection());
                this.updateConfig((ConfigEntry)deletedEntry);
            } else {
                this.checkDocumentId(entry);
                this.dalc.createConfig(entry);
                this.logAction(entry.getId(), AuditLogEntry.DataType.CONFIG, AuditLogEntry.Action.CREATE);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createList(List list) throws ConfigException, SelfServiceException {
        this.throwIfNull(list, "List is null");
        try {
            this.throwIfNotValid(list.getSubject(), "The list name is missing");
            this.assertStringLength(list.getSubject(), 255);
            this.assertStringLength(list.getDescription(), 255);
            this.checkDocumentId(list);
            if (this.isDuplicate(list)) {
                throw new SelfServiceException("A list named " + list.getSubject() + " already exists!");
            }
            this.dalc.createList(list);
            for (ListItem item : list.getListItems()) {
                this.checkDocumentId(item);
                item.setListId(list.getId());
                this.createListItem(item);
            }
            this.createMetaData(list, this.dalc);
            this.logAction(list.getId(), AuditLogEntry.DataType.LIST, AuditLogEntry.Action.CREATE);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteConfig(String configEntryId) throws ConfigException, SelfServiceException {
        Set<ConfigEntry> set = this.getConfig();
        for (ConfigEntry ce : set) {
            if (!ce.getId().equals(configEntryId)) continue;
            ce.setDeleted(true);
            ce.setDateModified(new Date().getTime());
            this.updateConfig(ce);
            this.logAction(ce.getId(), AuditLogEntry.DataType.CONFIG, AuditLogEntry.Action.DELETE);
        }
    }

    @Override
    public void deleteList(String listId) throws ConfigException, SelfServiceException {
        List list = this.getList(listId);
        if (list == null) {
            throw new SelfServiceException("Invalid List Id");
        }
        if (list.isSystemList()) {
            throw new SelfServiceException("System lists cannot be deleted");
        }
        list.setDeleted(true);
        this.updateList(list);
        this.logAction(listId, AuditLogEntry.DataType.LIST, AuditLogEntry.Action.DELETE);
    }

    @Override
    public void deleteListItem(String listItemId) throws ConfigException, SelfServiceException {
        ListItem item = this.getListItem(listItemId);
        if (item == null) {
            throw new ConfigException("Invalid listitem Id");
        }
        List parentList = this.getList(item.getListId());
        if (parentList == null) {
            throw new ConfigException("The parent List of the ListItem was not found");
        }
        ArrayList<ListItem> parentListItems = parentList.getListItems();
        for (ListItem li : parentListItems) {
            if (!li.isDeleted()) continue;
            parentListItems.remove(li);
        }
        if (parentList instanceof StatusList && parentListItems.size() <= 1) {
            throw new ConfigException("At least 1 status item must be available in the Status list.");
        }
        if (parentList.getDefaultId().equals(item.getId())) {
            if (parentListItems.size() > 1) {
                ListItem newDefaultItem = (ListItem)parentListItems.get(0);
                parentList.setDefaultId(newDefaultItem.getId());
                this.updateList(parentList);
            } else {
                parentList.setDefaultId(null);
                this.updateList(parentList);
            }
        }
        this.deleteListItem(item);
    }

    @Override
    public Set<ConfigEntry> getConfig() throws SelfServiceException {
        try {
            return this.dalc.getConfig(false);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Set<ConfigEntry> getConfig(String section) throws SelfServiceException {
        Set<ConfigEntry> set = this.getConfig();
        HashSet<ConfigEntry> sectionSet = new HashSet<ConfigEntry>();
        try {
            java.util.List<String> configKeys = SelfServiceEngine.getConfigKeys(section);
            for (String key : configKeys) {
                sectionSet.add(new ConfigEntry(key, SelfServiceEngine.getConfig(key)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isValid(section)) {
            for (ConfigEntry ce : set) {
                if (!section.equalsIgnoreCase(ce.getSection())) continue;
                sectionSet.add(ce);
            }
        }
        return sectionSet;
    }

    @Override
    public synchronized ConfigEntry getConfigByKey(String key) throws SelfServiceException {
        if (key.equalsIgnoreCase("case.serial.number")) {
            try {
                return this.dalc.getRefNumber();
            }
            catch (SQLException ex) {
                throw new SelfServiceException(ex);
            }
        }
        Set<ConfigEntry> set = this.getConfig();
        for (ConfigEntry ce : set) {
            if (!ce.getKey().equalsIgnoreCase(key)) continue;
            return ce;
        }
        return null;
    }

    @Override
    public List getList(String listId) throws SelfServiceException {
        try {
            boolean isStatusList = StatusList.isStatusList(listId);
            List list = this.dalc.getList(listId, isStatusList);
            if (list != null) {
                this.setMetaData(list, this.dalc, false);
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public java.util.List<List> getLists() throws SelfServiceException {
        try {
            return this.dalc.getLists();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public java.util.List<MetaData> getMetaDataList(java.util.List<String> documentIds) throws SelfServiceException {
        try {
            return this.dalc.getMetData(documentIds);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateConfig(ConfigEntry entry) throws ConfigException, SelfServiceException {
        this.throwIfNull(entry, "Config entry is null");
        try {
            this.throwIfNotValid(entry.getKey(), "Config key is missing");
            this.throwIfNotValid(entry.getValue(), "Config value is missing");
            this.assertStringLength(entry.getKey(), 64);
            this.assertStringLength(entry.getValue(), 255);
            this.assertStringLength(entry.getSection(), 64);
            entry.setDateModified(new Date().getTime());
            this.dalc.updateConfig(entry);
            this.logAction(entry.getId(), AuditLogEntry.DataType.CONFIG, AuditLogEntry.Action.UPDATE);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateList(List list) throws ConfigException, SelfServiceException {
        this.throwIfNull(list, "List is null");
        try {
            this.throwIfNotValid(list.getSubject(), "The list name is missing");
            this.assertStringLength(list.getSubject(), 255);
            this.assertStringLength(list.getDescription(), 255);
            if (this.isDuplicate(list)) {
                throw new SelfServiceException("A list named " + list.getSubject() + " already exists!");
            }
            list.setDateModified(new Date().getTime());
            if (list instanceof StatusList && list.getItemCount(false) == 0) {
                throw new ConfigException("Status List must contain at least 1 status item");
            }
            for (ListItem item : list.getListItems()) {
                if (item.isDirty() && item.isDeleted()) {
                    this.deleteListItem(item);
                    continue;
                }
                if (item.getId() != null && !item.isDirty()) continue;
                item.setListId(list.getId());
                this.createListItem(item);
            }
            ListItem defaultItem = list.getDefaultListItem();
            if (defaultItem != null && defaultItem.isDeleted()) {
                ArrayList<ListItem> listItems = list.getListItems();
                BaseDocumentUtil.removeDeletedDocuments(listItems);
                if (listItems.size() > 0) {
                    list.setDefaultId(((ListItem)listItems.get(0)).getId());
                }
            }
            this.dalc.updateList(list);
            this.updateMetaData(list, this.dalc);
            this.logAction(list.getId(), AuditLogEntry.DataType.LIST, AuditLogEntry.Action.UPDATE);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createOrganization(Organization org) throws OrganizationException, SelfServiceException {
        this.throwIfNull(org, "Organization is null");
        try {
            this.throwIfNotValid(org.getSubject(), "Organization name is missing");
            this.throwIfNotValid(org.getAlias(), "Organization alias is missing");
            this.assertStringLength(org.getSubject(), 128);
            this.assertStringLength(org.getAlias(), 64);
            this.assertStringLength(org.getCssFile(), 256);
            this.assertStringLength(org.getCertificateKey(), 64);
            this.checkDocumentId(org);
            this.throwIfNull(org.getEndpoint(), "Endpoint setting are not set");
            if (!org.getEndpoint().validate()) {
                throw new OrganizationException("The endpoint settings are unsufficient");
            }
            org.setAlias(org.getAlias().replaceAll("[^a-zA-Z0-9]+", "").replace("", ""));
            java.util.List<Organization> orgList = this.getOrganizations();
            if (this.isDuplicateOrganizationAlias(orgList, org)) {
                throw new OrganizationException("The alias " + org.getAlias() + " is in use by another organization!");
            }
            this.dalc.createOrganization(org);
            this.createMetaData(org, this.dalc);
            this.logAction(org.getId(), AuditLogEntry.DataType.ORGANIZATION, AuditLogEntry.Action.CREATE);
        }
        catch (IllegalArgumentException ex) {
            throw new OrganizationException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteOrganization(String organizationId) throws OrganizationException, SelfServiceException {
        Organization org = this.getOrganization(organizationId);
        if (org == null) {
            throw new OrganizationException("Invalid organization Id");
        }
        org.setDeleted(true);
        this.updateOrganization(org);
        this.logAction(org.getId(), AuditLogEntry.DataType.ORGANIZATION, AuditLogEntry.Action.DELETE);
        ServiceCache.remove(org.getId());
    }

    @Override
    public Organization getOrganization(String organizationId) throws SelfServiceException {
        try {
            Organization o = this.dalc.getOrganization(organizationId);
            if (o != null) {
                this.setMetaData(o, this.dalc, false);
            }
            return o;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException("Error loading certificate: " + ex.getMessage());
        }
    }

    @Override
    public java.util.List<Organization> getOrganizations() throws SelfServiceException {
        try {
            java.util.List<Organization> list = this.dalc.getOrganizations();
            for (Organization o : list) {
                this.setMetaData(o, this.dalc, false);
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateOrganization(Organization org) throws OrganizationException, SelfServiceException {
        this.throwIfNull(org, "Organization is null");
        try {
            this.throwIfNotValid(org.getSubject(), "Organization name is missing");
            this.throwIfNotValid(org.getAlias(), "Organization alias is missing");
            this.assertStringLength(org.getSubject(), 128);
            this.assertStringLength(org.getAlias(), 64);
            this.assertStringLength(org.getCssFile(), 256);
            this.assertStringLength(org.getCertificateKey(), 64);
            org.setAlias(org.getAlias().replaceAll("[^a-zA-Z0-9]+", "").replace("", ""));
            this.throwIfNull(org.getEndpoint(), "Endpoint setting are not set");
            if (!org.getEndpoint().validate()) {
                throw new OrganizationException("The endpoint setting are unsufficient");
            }
            java.util.List<Organization> orgList = this.getOrganizations();
            if (this.isDuplicateOrganizationAlias(orgList, org)) {
                throw new OrganizationException("The alias " + org.getAlias() + " is in use by another organization!");
            }
            org.setDateModified(new Date().getTime());
            this.dalc.updateOrganization(org);
            this.updateMetaData(org, this.dalc);
            this.logAction(org.getId(), AuditLogEntry.DataType.ORGANIZATION, AuditLogEntry.Action.UPDATE);
            ServiceCache.remove(org.getId());
        }
        catch (IllegalArgumentException ex) {
            throw new OrganizationException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createMetaData(MetaData metaData) throws SelfServiceException {
        try {
            MetaData existingMeta;
            boolean isCompleted = false;
            this.throwIfNull(metaData, "Metadata cannot be null");
            this.throwIfNotValid(metaData.getReferenceId(), "The metadata document reference is missing");
            this.throwIfNotValid(metaData.getKey(), "The metadata key is missing");
            this.throwIfNotValid(metaData.getValue(), "The metadata value is missing");
            this.assertStringLength(metaData.getKey(), 64);
            this.checkDocumentId(metaData);
            if (metaData.isDirty() && (existingMeta = this.dalc.findMetaDataEntry(metaData.getReferenceId(), metaData.getKey())) != null) {
                existingMeta.setValue(metaData.getValue());
                this.updateMetaData(existingMeta);
                isCompleted = true;
            }
            if (!isCompleted) {
                this.dalc.createMetaDataEntry(metaData);
                this.logAction(metaData.getId(), AuditLogEntry.DataType.METADATA, AuditLogEntry.Action.CREATE);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateMetaData(MetaData metaData) throws SelfServiceException {
        try {
            this.throwIfNull(metaData, "Metadata cannot be null");
            this.throwIfNotValid(metaData.getId(), "The metadata Id is missing");
            this.throwIfNotValid(metaData.getReferenceId(), "The metadata document reference is missing");
            this.throwIfNotValid(metaData.getKey(), "The metadata key is missing");
            this.throwIfNotValid(metaData.getValue(), "The metadata value is missing");
            metaData.setDateModified(new Date().getTime());
            this.dalc.updateMetadataEntry(metaData);
            if (!metaData.getKey().startsWith("sync.")) {
                this.logAction(metaData.getId(), AuditLogEntry.DataType.METADATA, AuditLogEntry.Action.UPDATE);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public java.util.List<Module> getModules() throws SelfServiceException {
        try {
            return this.dalc.getModules();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createMessageTemplate(MessageTemplate mt) throws SelfServiceException {
        try {
            this.throwIfNull(mt, "Message template cannot be null");
            this.throwIfNotValid(mt.getTitle(), "The title is missing");
            this.throwIfNotValid(mt.getCategoryId(), "The category Id is missing");
            this.throwIfNotValid(mt.getSubject(), "The subject is missing");
            this.throwIfNotValid(mt.getBody(), "The template body is missing");
            this.assertStringLength(mt.getSubject(), 256);
            this.assertStringLength(mt.getTitle(), 256);
            this.checkDocumentId(mt);
            this.dalc.createMessageTemplate(mt);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateMessageTemplate(MessageTemplate mt) throws SelfServiceException {
        try {
            this.throwIfNull(mt, "Message template cannot be null");
            this.throwIfNotValid(mt.getTitle(), "The title is missing");
            this.throwIfNotValid(mt.getCategoryId(), "The category Id is missing");
            this.throwIfNotValid(mt.getSubject(), "The subject is missing");
            this.throwIfNotValid(mt.getBody(), "The template body is missing");
            this.assertStringLength(mt.getSubject(), 256);
            this.assertStringLength(mt.getTitle(), 256);
            mt.setDateModified(new Date().getTime());
            this.dalc.updateMessageTemplate(mt);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public MessageTemplate getMessageTemplate(String templateId) throws SelfServiceException {
        try {
            return this.dalc.getMessageTemplate(templateId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public java.util.List<MessageTemplate> getMessageTemplates() throws SelfServiceException {
        try {
            return this.dalc.getMessageTemplates();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteMessageTemplate(String templateId) throws SelfServiceException {
        try {
            MessageTemplate mt = this.getMessageTemplate(templateId);
            if (mt == null) {
                throw new SelfServiceException("Invalid message template Id");
            }
            mt.setDeleted(true);
            mt.setDateModified(new Date().getTime());
            this.dalc.updateMessageTemplate(mt);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void createListItem(ListItem item) throws ConfigException, SelfServiceException {
        this.throwIfNull(item, "List item is null");
        try {
            this.throwIfNotValid(item.getSubject(), "List item subject is missing");
            this.throwIfNotValid(item.getAlias(), "List item alias is missing");
            this.throwIfNotValid(item.getListId(), "The parent list Id is missing");
            this.assertStringLength(item.getSubject(), 128);
            this.assertStringLength(item.getAlias(), 64);
            if (item instanceof StatusListItem) {
                StatusListItem.Status status = ((StatusListItem)item).getStatus();
                this.throwIfNull((Object)status, "Base status for Status List item cannot be null");
            }
            this.checkDocumentId(item);
            this.dalc.createListItem(item);
            this.logAction(item.getId(), AuditLogEntry.DataType.LISTITEM, AuditLogEntry.Action.CREATE);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void deleteListItem(ListItem item) throws SelfServiceException {
        this.throwIfNull(item, "List item is null");
        try {
            item.setDateModified(new Date().getTime());
            this.dalc.deleteListItem(item);
            this.logAction(item.getId(), AuditLogEntry.DataType.LISTITEM, AuditLogEntry.Action.DELETE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public ListItem getListItem(String listItemId) throws SelfServiceException {
        try {
            return this.dalc.getListItem(listItemId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateListItem(ListItem listItem) throws SelfServiceException {
        try {
            this.throwIfNotValid(listItem.getSubject(), "List item subject is missing");
            this.throwIfNotValid(listItem.getAlias(), "List item alias is missing");
            this.assertStringLength(listItem.getSubject(), 128);
            this.assertStringLength(listItem.getAlias(), 64);
            this.dalc.updateListItem(listItem);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private boolean isDuplicate(List list) throws SelfServiceException {
        java.util.List<List> lists = this.getLists();
        for (List l : lists) {
            if (l.getId().equals(list.getId()) || l.isDeleted() || !l.getSubject().equalsIgnoreCase(list.getSubject())) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicateOrganizationAlias(java.util.List<Organization> orglist, Organization o) {
        for (Organization org : orglist) {
            if (org.isDeleted() || org.getId().equals(o.getId()) || !org.getAlias().equalsIgnoreCase(o.getAlias())) continue;
            return true;
        }
        return false;
    }
}

