/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.gopro.gdf.data.ListType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ListValueType;
import net.gopro.gdf.data.PhoneNumberType;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.GDFDataHelper;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;

public class RESTPhoneNumber {
    private static final Logger logger = Logger.getLogger(RESTPhoneNumber.class);

    public static List<PhoneNumberType> createPhoneNumberTypes(Organization org, String homeNumber, String mobileNumber) throws GoProDataStoreException {
        ArrayList<PhoneNumberType> list = new ArrayList<PhoneNumberType>();
        if (StringUtil.isValid(homeNumber) || StringUtil.isValid(mobileNumber)) {
            ListType lt = RestHelper.getList(org, "PhoneNumberTypes");
            if (lt != null && lt.getListEntriesCount() > 0) {
                ListValueRefType lvr;
                if (StringUtil.isValid(homeNumber)) {
                    ListValueType homeNumberType = GDFDataHelper.getListValueType(Arrays.asList("Private", "Home"), lt);
                    if (homeNumberType != null) {
                        PhoneNumberType homePhone = new PhoneNumberType();
                        homePhone.setNumber(homeNumber);
                        homePhone.setID("00000000-0000-0000-0000-000000000000");
                        lvr = new ListValueRefType();
                        lvr.setID(homeNumberType.getID());
                        lvr.setName(homeNumberType.getName());
                        homePhone.setType(lvr);
                        list.add(homePhone);
                    } else {
                        logger.warn((Object)"GDF: The Home Phone Number type was not found in the PhoneType List.");
                    }
                }
                if (StringUtil.isValid(mobileNumber)) {
                    ListValueType mobileNumberType = GDFDataHelper.getListValueType("Mobile", lt);
                    if (mobileNumberType != null) {
                        PhoneNumberType mobilePhone = new PhoneNumberType();
                        mobilePhone.setNumber(mobileNumber);
                        mobilePhone.setID("00000000-0000-0000-0000-000000000000");
                        lvr = new ListValueRefType();
                        lvr.setID(mobileNumberType.getID());
                        lvr.setName(mobileNumberType.getName());
                        mobilePhone.setType(lvr);
                        list.add(mobilePhone);
                    } else {
                        logger.warn((Object)"GDF: The Mobile Phone Number type was not found in the PhoneType List.");
                    }
                }
            } else {
                logger.warn((Object)"GDF: Phone Number List Type from GDF is empty.");
            }
        }
        return list;
    }
}

