/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import is.hugvit.util.Util;
import java.util.Vector;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.ListType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ListValueType;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;

public final class RESTAddress {
    private static Logger logger = Logger.getLogger(RESTAddress.class);

    public static final AddressType createAddressType(Organization org, Address address) {
        AddressType addressType = new AddressType();
        addressType.setID("00000000-0000-0000-0000-000000000000");
        if (StringUtil.isValid(address.getPostcode())) {
            addressType.setPostCode(address.getPostcode());
        }
        if (StringUtil.isValid(address.getCity())) {
            addressType.setCity(address.getCity());
        }
        if (StringUtil.isValid(address.getState())) {
            addressType.setState(address.getState());
        }
        RESTAddress.setCountry(org, address.getCountry(), addressType);
        Vector v = Util.split((String)address.getStreetName(), (String)" ");
        if (v != null && v.size() > 0) {
            if (v.size() > 1) {
                String lastElem = (String)v.lastElement();
                char first = lastElem.charAt(0);
                try {
                    Integer.parseInt(String.valueOf(first));
                    v.removeElementAt(v.size() - 1);
                    addressType.setStreetName(Util.expand((Vector)v, (String)" ").trim());
                    if (StringUtil.isValid(lastElem)) {
                        addressType.setStreetNumber(lastElem);
                    }
                }
                catch (NumberFormatException ex) {
                    addressType.setStreetName(address.getStreetName());
                }
            } else {
                addressType.setStreetName(address.getStreetName());
            }
        }
        return addressType;
    }

    private static void setCountry(Organization org, String country, AddressType address) {
        try {
            if (StringUtil.isValid(country)) {
                country = RESTAddress.checkCountryString(country);
                ListType countriesList = RestHelper.getList(org, "Countries");
                if (countriesList != null && countriesList.getListEntriesCount() > 0) {
                    for (ListValueType listValue : countriesList.getListEntries()) {
                        if (!country.equalsIgnoreCase(listValue.getName())) continue;
                        ListValueRefType ref = new ListValueRefType();
                        ref.setID(listValue.getID());
                        ref.setName(listValue.getName());
                        address.setCountry(ref);
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error setting country to address.", (Throwable)ex);
        }
    }

    private static String checkCountryString(String country) {
        String ret = country.trim();
        if ("\u00cdsland".equalsIgnoreCase(ret)) {
            ret = "Iceland";
        } else if ("USA".equals(ret)) {
            ret = "United States";
        } else if ("UK".equalsIgnoreCase(ret)) {
            ret = "United Kingdom";
        }
        return ret;
    }
}

