/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.XPath;

public class GDFMetadata {
    private static Map<String, String> uris = new HashMap<String, String>();

    public static void setMetadata(BaseDocument doc, DocumentBaseType docType) {
        List<MetaData> metadataList = doc.getMetadata();
        Document xdoc = null;
        boolean enforceMetaType = Boolean.parseBoolean(SelfServiceEngine.getConfig("goproforms.metatype.enforce", "true"));
        try {
            if (doc instanceof ApplicationForm) {
                ApplicationForm app = (ApplicationForm)doc;
                FormTemplate ft = FormService.getFormTemplate(((ApplicationForm)doc).getFormtemplateId(), false);
                if (ft != null && ft.getSchemaVersion() >= 2.0) {
                    if (app.getStream() == null || app.getStream().length == 0) {
                        app = (ApplicationForm)CaseService.getSubDocument(app.getId(), true);
                    }
                    xdoc = FormsUtil.createDocument(app.getStream());
                }
            }
        }
        catch (SelfServiceException ex) {
            SelfServiceEngine.getLogger().warn("Could not load form template for metadata type definitions", (Exception)ex);
        }
        catch (FormException ex) {
            SelfServiceEngine.getLogger().warn("Could not load xml form for metadata type definitions", (Exception)ex);
        }
        for (MetaData md : metadataList) {
            if (!StringUtil.isValid(md.getKey()) || !StringUtil.isValid(md.getValue())) continue;
            boolean isNew = false;
            MetaDataType mt = GDFMetadata.getMetadataByKey(docType.getMetaDataEntries(), md.getKey());
            if (mt == null) {
                mt = new MetaDataType();
                mt.setName(md.getKey());
                isNew = true;
            }
            mt.setValue(md.getValue());
            if (enforceMetaType) {
                if (xdoc != null) {
                    MetaValueType valueType = GDFMetadata.getMetadataValue(xdoc, md.getKey());
                    if (MetaValueType.INT.equals(valueType)) {
                        try {
                            Integer.parseInt(md.getValue());
                        }
                        catch (NumberFormatException ex) {
                            valueType = MetaValueType.STRING;
                        }
                    } else if (MetaValueType.FLOAT.equals(valueType)) {
                        try {
                            Float.parseFloat(md.getValue());
                        }
                        catch (NumberFormatException ex) {
                            valueType = MetaValueType.STRING;
                        }
                    }
                    mt.setValueType(valueType);
                } else if (NumberUtils.isDigits((String)md.getValue()) && !GDFMetadata.isSocialSecurityNumber(md.getValue())) {
                    try {
                        Integer.parseInt(md.getValue());
                        mt.setValueType(MetaValueType.INT);
                    }
                    catch (NumberFormatException ex) {
                        mt.setValueType(MetaValueType.STRING);
                    }
                } else {
                    mt.setValueType(MetaValueType.STRING);
                }
            } else {
                mt.setValueType(MetaValueType.STRING);
            }
            if (!isNew) continue;
            docType.addMetaDataEntry(mt);
        }
    }

    public static void updateMetadata(BaseDocument doc, DocumentBaseType docType) {
        List<MetaData> metadataList = doc.getMetadata();
        Document xdoc = null;
        boolean enforceMetaType = Boolean.parseBoolean(SelfServiceEngine.getConfig("goproforms.metatype.enforce", "true"));
        try {
            if (doc instanceof ApplicationForm) {
                ApplicationForm app = (ApplicationForm)doc;
                FormTemplate ft = FormService.getFormTemplate(((ApplicationForm)doc).getFormtemplateId(), false);
                if (ft != null && ft.getSchemaVersion() >= 2.0) {
                    if (app.getStream() == null || app.getStream().length == 0) {
                        app = (ApplicationForm)CaseService.getSubDocument(app.getId(), true);
                    }
                    xdoc = FormsUtil.createDocument(app.getStream());
                }
            }
        }
        catch (SelfServiceException ex) {
            SelfServiceEngine.getLogger().warn("Could not load form template for metadata type definitions", (Exception)ex);
        }
        catch (FormException ex) {
            SelfServiceEngine.getLogger().warn("Could not load xml form for metadata type definitions", (Exception)ex);
        }
        for (MetaData md : metadataList) {
            if (!StringUtil.isValid(md.getKey()) || (!StringUtil.isValid(md.getValue()) || md.isDeleted()) && !md.isDirty()) continue;
            MetaDataType existingMeta = GDFMetadata.getMetadataByKey(docType.getMetaDataEntries(), md.getKey());
            if (existingMeta != null) {
                existingMeta.setValue(md.getValue());
                continue;
            }
            MetaDataType mt = new MetaDataType();
            mt.setName(md.getKey());
            mt.setValue(md.getValue());
            if (enforceMetaType) {
                if (xdoc != null) {
                    MetaValueType valueType = GDFMetadata.getMetadataValue(xdoc, md.getKey());
                    mt.setValueType(valueType);
                } else if (NumberUtils.isDigits((String)md.getValue()) && !GDFMetadata.isSocialSecurityNumber(md.getValue())) {
                    try {
                        Integer.parseInt(md.getValue());
                        mt.setValueType(MetaValueType.INT);
                    }
                    catch (NumberFormatException ex) {
                        mt.setValueType(MetaValueType.STRING);
                    }
                } else {
                    mt.setValueType(MetaValueType.STRING);
                }
            } else {
                mt.setValueType(MetaValueType.STRING);
            }
            docType.addMetaDataEntry(mt);
        }
    }

    private static MetaDataType getMetadataByKey(MetaDataType[] list, String metaKey) {
        for (MetaDataType meta : list) {
            if (meta.getName().equalsIgnoreCase(metaKey)) {
                return meta;
            }
            if (!meta.getName().equalsIgnoreCase(metaKey.replaceAll("-", "_"))) continue;
            return meta;
        }
        return null;
    }

    private static MetaValueType getMetadataValue(Document doc, String fieldId) {
        String query = String.format("//gpf:*[@id='%s']", fieldId);
        XPath xpath = doc.createXPath(query);
        xpath.setNamespaceURIs(uris);
        Node node = xpath.selectSingleNode((Object)doc);
        if (node != null) {
            if ("range".equals(node.getName())) {
                return MetaValueType.INT;
            }
            String dataType = node.valueOf("@datatype");
            if (dataType != null) {
                if ("number".equals(dataType) || "int".equals(dataType)) {
                    return MetaValueType.INT;
                }
                if ("boolean".equals(dataType)) {
                    return MetaValueType.BOOLEAN;
                }
                if ("float".equals(dataType)) {
                    return MetaValueType.FLOAT;
                }
                return MetaValueType.STRING;
            }
        }
        return MetaValueType.STRING;
    }

    private static boolean isSocialSecurityNumber(String kennitala) {
        if (kennitala == null) {
            return false;
        }
        if (kennitala.length() != 10) {
            return false;
        }
        if (!kennitala.matches("[0-9]{10}")) {
            return false;
        }
        int sum = Integer.parseInt(String.valueOf(kennitala.charAt(0))) * 3;
        sum += Integer.parseInt(String.valueOf(kennitala.charAt(1))) * 2;
        sum += Integer.parseInt(String.valueOf(kennitala.charAt(2))) * 7;
        sum += Integer.parseInt(String.valueOf(kennitala.charAt(3))) * 6;
        sum += Integer.parseInt(String.valueOf(kennitala.charAt(4))) * 5;
        sum += Integer.parseInt(String.valueOf(kennitala.charAt(5))) * 4;
        sum += Integer.parseInt(String.valueOf(kennitala.charAt(6))) * 3;
        int leftovers = (sum += Integer.parseInt(String.valueOf(kennitala.charAt(7))) * 2) % 11;
        int validationNumber = 11 - leftovers;
        int vartala = Integer.parseInt(String.valueOf(kennitala.charAt(8)));
        if (validationNumber == 11) {
            validationNumber = 0;
        }
        return validationNumber == vartala;
    }

    static {
        uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
    }
}

