/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.forms;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.IFormTranslation;
import net.gopro.selfservice.services.FormService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jsoup.Jsoup;

public abstract class BaseFormTranslation
implements IFormTranslation {
    protected static final SimpleDateFormat dfIso = new SimpleDateFormat(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
    protected FormTemplate formTemplate;

    protected BaseFormTranslation(FormTemplate template) {
        this.formTemplate = template;
    }

    @Override
    public Hashtable<String, String> getTranslationBucket(Document doc) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        List pageNodes = doc.selectNodes("//pages/page");
        for (int i = 0; i < pageNodes.size(); ++i) {
            Node node = (Node)pageNodes.get(i);
            String pageKey = node.valueOf("@key");
            ht.put(this.createFieldKey(pageKey, FieldType.PAGE, i + 1), node.getText());
        }
        List sectionNodes = doc.selectNodes("//sections/section");
        for (int i = 0; i < sectionNodes.size(); ++i) {
            Node node = (Node)sectionNodes.get(i);
            String sectionKey = node.valueOf("@key");
            ht.put(this.createFieldKey(sectionKey, FieldType.SECTION, i + 1), node.getText());
            String buttonValue = node.valueOf("@repeatable-label");
            if (buttonValue == null || "".equals(buttonValue)) continue;
            ht.put(this.createFieldKey(sectionKey, FieldType.BUTTON, i + 1), buttonValue);
        }
        List fieldNodes = doc.selectNodes("//fields/field");
        for (int i = 0; i < fieldNodes.size(); ++i) {
            Node helpNode;
            Node placeholderNode;
            List<String> multiTypes;
            Node node = (Node)fieldNodes.get(i);
            String fieldKey = node.valueOf("@key");
            String fieldType = node.valueOf("@type");
            Node nodeLabel = node.selectSingleNode("label");
            if (nodeLabel != null) {
                ht.put(this.createFieldKey(fieldKey, FieldType.LABEL, i + 1), nodeLabel.getText());
            }
            if ((multiTypes = Arrays.asList("listbox", "checkbox", "radio", "selection", "matrix")).contains(fieldType)) {
                List valueNodes = node.selectNodes("option");
                for (int j = 0; j < valueNodes.size(); ++j) {
                    Node valueNode = (Node)valueNodes.get(j);
                    ht.put(this.createFieldKey(fieldKey, FieldType.OPTION, j + 1), valueNode.getText());
                }
                List headerNodes = node.selectNodes("header");
                for (int j = 0; j < headerNodes.size(); ++j) {
                    Node headerNode = (Node)headerNodes.get(j);
                    ht.put(this.createFieldKey(fieldKey, FieldType.HEADER, j + 1), headerNode.getText());
                }
            }
            if ((placeholderNode = node.selectSingleNode("placeholder")) != null) {
                ht.put(this.createFieldKey(fieldKey, FieldType.PLACEHOLDER, i + 1), placeholderNode.getText());
            }
            if ((helpNode = node.selectSingleNode("helptext")) == null) continue;
            ht.put(this.createFieldKey(fieldKey, FieldType.HELPTEXT, i + 1), helpNode.getText());
        }
        return ht;
    }

    @Override
    public Document generateTranslationFile(Locale locale, Hashtable<String, String> bucket) throws FormException, SelfServiceException {
        Document doc = this.getTranslationTemplate();
        Element root = doc.getRootElement();
        Element langNode = (Element)root.selectSingleNode("form/language/translation");
        langNode.setText(locale.getDisplayLanguage());
        langNode.addAttribute("isocode", locale.getLanguage().toLowerCase());
        List pageNodes = doc.selectNodes("//pages/page");
        for (Object node : pageNodes) {
            String pageKey = node.valueOf("@key");
            if (!bucket.containsKey(pageKey + "-page")) continue;
            node.setText(this.parseHtmlEntities(bucket.get(pageKey + "-page")));
        }
        List sectionNodes = doc.selectNodes("//sections/section");
        for (Node node : sectionNodes) {
            String sectionKey = node.valueOf("@key");
            if (bucket.containsKey(sectionKey + "-section")) {
                node.setText(this.parseHtmlEntities(bucket.get(sectionKey + "-section")));
            }
            if (!bucket.containsKey(sectionKey + "-button")) continue;
            ((Element)node).addAttribute("repeatable-label", this.parseHtmlEntities(bucket.get(sectionKey + "-button")));
        }
        List fieldNodes = doc.selectNodes("//fields/field");
        for (Node node : fieldNodes) {
            List<String> multiTypes;
            Node helpNode;
            Node placeNode;
            String fieldKey = node.valueOf("@key");
            String fieldType = node.valueOf("@type");
            Node nodeLabel = node.selectSingleNode("label");
            if (nodeLabel != null && bucket.containsKey(fieldKey + "-label")) {
                nodeLabel.setText(this.parseHtmlEntities(bucket.get(fieldKey + "-label")));
            }
            if ((placeNode = node.selectSingleNode("placeholder")) != null && bucket.containsKey(fieldKey + "-placeholder")) {
                placeNode.setText(this.parseHtmlEntities(bucket.get(fieldKey + "-placeholder")));
            }
            if ((helpNode = node.selectSingleNode("helptext")) != null && bucket.containsKey(fieldKey + "-helptext")) {
                helpNode.setText(this.parseHtmlEntities(bucket.get(fieldKey + "-helptext")));
            }
            if (!(multiTypes = Arrays.asList("listbox", "checkbox", "radio", "selection", "matrix")).contains(fieldType)) continue;
            List valueNodes = node.selectNodes("option");
            for (int i = 0; i < valueNodes.size(); ++i) {
                String optionKey = fieldKey + "-option-" + (i + 1);
                if (!bucket.containsKey(optionKey)) continue;
                ((Node)valueNodes.get(i)).setText(this.parseHtmlEntities(bucket.get(optionKey)));
            }
            List headerNodes = node.selectNodes("header");
            for (int i = 0; i < headerNodes.size(); ++i) {
                String headerKey = fieldKey + "-header-" + (i + 1);
                if (!bucket.containsKey(headerKey)) continue;
                ((Node)headerNodes.get(i)).setText(this.parseHtmlEntities(bucket.get(headerKey)));
            }
        }
        return doc;
    }

    protected String parseHtmlEntities(String in) {
        return StringEscapeUtils.unescapeHtml((String)Jsoup.parse((String)in).text());
    }

    protected Document createTranslationTemplate() throws SelfServiceException {
        FormTemplateFile file = FormService.getFormTemplateFile(this.formTemplate.getId(), FormTemplateFile.Tag.DATA, true);
        Element root = DocumentHelper.createElement((String)"application");
        Document doc = DocumentHelper.createDocument((Element)root);
        root.addComment(" It is now your job to translate the texts within each element.\nDo no alter texts within attributes. ");
        Element form = root.addElement("form");
        form.addElement("modified").setText(dfIso.format(new Date(file.getDateModified())));
        form.addElement("checksum").setText(DigestUtils.md5Hex((byte[])file.getStream()));
        Element elLanguage = form.addElement("language");
        String defaultLanguage = SelfServiceEngine.getConfig("web.locale.language");
        String[] langParts = defaultLanguage.split(",");
        Element elLangOriginal = elLanguage.addElement("original");
        Element elLangTranslated = elLanguage.addElement("translation");
        Locale loc = new Locale(langParts[0], langParts[1]);
        elLangOriginal.addAttribute("isocode", loc.getCountry().toLowerCase());
        elLangOriginal.setText(loc.getDisplayLanguage());
        elLangTranslated.addAttribute("isocode", "Set ISO code here");
        elLangTranslated.setText("Set language name here");
        Element elTranslation = root.addElement("translation");
        elTranslation.addElement("pages");
        elTranslation.addElement("sections");
        elTranslation.addElement("fields");
        return doc;
    }

    protected void translateNode(String key, FieldType type, Node node, Hashtable<String, String> bucket) {
        String translation;
        String uniqueKey = null;
        uniqueKey = FieldType.OPTION.equals((Object)type) || FieldType.HEADER.equals((Object)type) ? this.createFieldKey(key, type, 0) : this.createFieldKey(key, type, -1);
        if ((FieldType.PAGE.equals((Object)type) || FieldType.SECTION.equals((Object)type) || FieldType.LABEL.equals((Object)type) || FieldType.HELPTEXT.equals((Object)type) || FieldType.PLACEHOLDER.equals((Object)type) || FieldType.BUTTON.equals((Object)type)) && bucket.containsKey(uniqueKey) && (translation = bucket.get(uniqueKey)) != null && !"".equals(translation)) {
            if (FieldType.PLACEHOLDER.equals((Object)type)) {
                ((Element)node).addAttribute("placeholder", translation);
            } else if (FieldType.BUTTON.equals((Object)type)) {
                ((Element)node).addAttribute("repeatable-label", translation);
            } else {
                node.setText(translation);
            }
        }
    }

    protected String createFieldKey(String fieldKey, FieldType type, int counter) {
        if (FieldType.LABEL.equals((Object)type) || FieldType.PAGE.equals((Object)type) || FieldType.HELPTEXT.equals((Object)type) || FieldType.PLACEHOLDER.equals((Object)type) || FieldType.BUTTON.equals((Object)type) || FieldType.SECTION.equals((Object)type)) {
            return fieldKey + "-" + type.toString().toLowerCase();
        }
        return fieldKey + "-" + type.toString().toLowerCase() + "-" + counter;
    }

    protected static enum FieldType {
        PAGE,
        SECTION,
        LABEL,
        OPTION,
        HELPTEXT,
        PLACEHOLDER,
        HEADER,
        BUTTON;

    }
}

