/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.excel;

import is.hugvit.bird.WebContext;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import jxl.CellView;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Boolean;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.excel.ExcelData;
import net.gopro.selfservice.excel.ExcelDataRow;

public class ExcelWriter {
    public static final void write(WebContext context, ExcelData exl) throws SelfServiceException {
        try {
            HttpServletResponse response = context.getResponseExclusive();
            response.setContentType("application/vnd.ms-excel");
            String filename = exl.getFilename() + ".xls";
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\" ");
            WritableWorkbook w = Workbook.createWorkbook((OutputStream)response.getOutputStream());
            WritableSheet s = w.createSheet(exl.getSheetName() != null ? exl.getSheetName() : "Sheet 1", 0);
            for (int i = 0; i < exl.getHeaders().size(); ++i) {
                ExcelDataRow row = exl.getHeaders().get(i);
                WritableFont headerFont = new WritableFont(WritableFont.ARIAL, 11, WritableFont.BOLD);
                headerFont.setColour(Colour.BLACK);
                s.addCell((WritableCell)new Label(i, 0, row.getValue(), (CellFormat)new WritableCellFormat(headerFont)));
                CellView cv = new CellView();
                cv.setSize(row.getRowSize());
                cv.setAutosize(true);
                s.setColumnView(i, cv);
                int rowCounter = 1;
                List<Object> data = exl.getData(row.getKey());
                if (data == null) continue;
                for (Object val : data) {
                    if (row.getRowtype().equals((Object)ExcelDataRow.RowType.NUMBER)) {
                        Double dVal = new Double(val.toString());
                        WritableCellFormat floatFormat = new WritableCellFormat(NumberFormats.FLOAT);
                        s.addCell((WritableCell)new Number(i, rowCounter, dVal.doubleValue(), (CellFormat)floatFormat));
                    } else if (row.getRowtype().equals((Object)ExcelDataRow.RowType.BOOLEAN)) {
                        java.lang.Boolean bval = new java.lang.Boolean((String)val);
                        s.addCell((WritableCell)new Boolean(i, rowCounter, bval.booleanValue()));
                    } else {
                        s.addCell((WritableCell)new Label(i, rowCounter, (String)val));
                    }
                    ++rowCounter;
                }
            }
            w.write();
            w.close();
        }
        catch (Exception ex) {
            throw new SelfServiceException("Error creating Excel document", ex);
        }
    }
}

