/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.targetgroup;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TargetGroupUser {
    private String targetGroupId;
    private String userId;
    private long joinDate;
    private String rolename;
    private String fullname;
    private String email;

    public TargetGroupUser(String targetgroupId, String userId) {
        this.targetGroupId = targetgroupId;
        this.userId = userId;
        this.joinDate = new Date().getTime();
    }

    public TargetGroupUser(String targetgroupId, String userId, String role) {
        this(targetgroupId, userId);
        this.rolename = role;
    }

    public TargetGroupUser(ResultSet rs) throws SQLException {
        this.targetGroupId = rs.getString("targetgroup_id");
        this.userId = rs.getString("user_id");
        this.joinDate = rs.getTimestamp("date_in").getTime();
        this.rolename = rs.getString("rolename");
    }

    public String getTargetGroupId() {
        return this.targetGroupId;
    }

    public void setTargetGroupId(String targetGroupId) {
        this.targetGroupId = targetGroupId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public long getJoinDate() {
        return this.joinDate;
    }

    public void setJoinDate(long joinDate) {
        this.joinDate = joinDate;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getRolename() {
        return this.rolename;
    }

    public void setRolename(String rolename) {
        this.rolename = rolename;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"targetgroupuser");
        DateFormat df = LocaleUtil.getTimeFormat();
        Dom4JUtil.addElement(el, "user_id", this.userId);
        Dom4JUtil.addElement(el, "fullname", this.fullname);
        Dom4JUtil.addElement(el, "email", this.email);
        Dom4JUtil.addElement(el, "joined", df.format(this.joinDate));
        Dom4JUtil.addElement(el, "joined_alt", LocaleUtil.formatDate(this.joinDate));
        Dom4JUtil.addElement(el, "role", this.rolename);
        return el;
    }
}

