/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.routing;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class PickUpQueueEntry
extends BaseDocument {
    private String createdById;
    private String createdByName;
    private String documentSubject;
    private String documentType;
    private String organizationId;
    private String organizationName;
    private long dateCompleted;
    private List<RemotePickUp> pickups = new ArrayList<RemotePickUp>();

    public PickUpQueueEntry(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("documentId");
        this.documentSubject = rs.getString("subject");
        this.documentType = rs.getString("documentType");
        this.organizationName = rs.getString("organization");
        this.organizationId = rs.getString("organization_id");
        this.createdById = rs.getString("userId");
        this.createdByName = rs.getString("fullname");
        Timestamp tsCompleted = rs.getTimestamp("completed");
        if (tsCompleted != null) {
            this.dateCompleted = tsCompleted.getTime();
        }
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getCreatedByName() {
        return this.createdByName;
    }

    public String getDocumentSubject() {
        return this.documentSubject;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public long getDateCompleted() {
        return this.dateCompleted;
    }

    public void addPickUpEntry(AuditLogEntry entry) {
        this.pickups.add(new RemotePickUp(entry));
    }

    public boolean isPickedUp() {
        return this.pickups.size() > 0;
    }

    private void sortPickupEntries() {
        Collections.sort(this.pickups);
    }

    @Override
    public Element getXml() {
        this.sortPickupEntries();
        Element el = super.getBaseXml("queue");
        el.addAttribute("pickupcount", String.valueOf(this.pickups.size()));
        Dom4JUtil.addElement(el, "fullname", this.createdByName);
        Dom4JUtil.addElement(el, "user_id", this.createdById);
        Dom4JUtil.addElement(el, "document_type", this.documentType);
        Dom4JUtil.addElement(el, "organization", this.organizationName);
        Dom4JUtil.addElement(el, "subject", this.documentSubject);
        Dom4JUtil.addElement(el, "subject_short", StringUtil.shortenText(this.documentSubject, 20));
        if (this.pickups.size() > 0) {
            RemotePickUp pickup = this.pickups.get(0);
            Dom4JUtil.addElement(el, "pickup_date", LocaleUtil.formatDate(pickup.getDatePickedUp()));
            Dom4JUtil.addElement(el, "pickup_host", pickup.getHostname());
            Dom4JUtil.addElement(el, "pickup_user", pickup.getUserId());
        }
        return el;
    }

    protected class RemotePickUp
    implements Comparable<RemotePickUp> {
        private long datePickedUp;
        private String hostname;
        private String userId;

        public RemotePickUp(AuditLogEntry entry) {
            this.datePickedUp = entry.getTimestamp();
            this.hostname = entry.getIp();
            this.userId = entry.getUserId();
        }

        public long getDatePickedUp() {
            return this.datePickedUp;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getUserId() {
            return this.userId;
        }

        @Override
        public int compareTo(RemotePickUp o) {
            if (o.getDatePickedUp() < this.getDatePickedUp()) {
                return -1;
            }
            if (o.getDatePickedUp() > this.getDatePickedUp()) {
                return 1;
            }
            return 0;
        }
    }
}

