/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.gopro;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class Endpoint {
    private RemoteGoPro.GoPro goproType;
    private String hostname;
    private String username;
    private String password;
    private String brokerDestinationId;

    public Endpoint() {
    }

    public Endpoint(ResultSet rs) throws SQLException {
        this.goproType = RemoteGoPro.GoPro.valueOf(rs.getString("type"));
        this.hostname = rs.getString("hostname");
        this.username = rs.getString("username");
        this.password = rs.getString("password");
        this.brokerDestinationId = rs.getString("brokerdestination");
    }

    public RemoteGoPro.GoPro getGoproType() {
        return this.goproType;
    }

    public void setGoproType(RemoteGoPro.GoPro goproType) {
        this.goproType = goproType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBrokerDestinationId() {
        return this.brokerDestinationId;
    }

    public void setBrokerDestinationId(String brokerDestinationId) {
        this.brokerDestinationId = brokerDestinationId;
    }

    public String getGoProTypeName() {
        if (this.goproType != null) {
            return RemoteGoPro.getDataStoreTitle(this.goproType);
        }
        return "";
    }

    public boolean validate() {
        if (this.goproType == null) {
            return false;
        }
        switch (this.goproType) {
            case GOPRO_NET: 
            case GOPRO_PORTAL: 
            case GOPRO_CASE: {
                return this.isValid(Arrays.asList(this.hostname, this.username, this.password));
            }
            case GOPRO_BROKER: {
                return this.isValid(Arrays.asList(this.hostname, this.brokerDestinationId));
            }
            case BROKER_PICKUP: {
                return true;
            }
        }
        return false;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"endpoint");
        el.addAttribute("type", this.goproType.toString());
        Dom4JUtil.addElement(el, "gopro", this.getGoProTypeName());
        Dom4JUtil.addElement(el, "hostname", this.hostname);
        Dom4JUtil.addElement(el, "username", this.username);
        Dom4JUtil.addElement(el, "password", this.password);
        Dom4JUtil.addElement(el, "brokerdest_id", this.brokerDestinationId);
        return el;
    }

    private boolean isValid(List<String> list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        boolean isValid = true;
        for (String s : list) {
            isValid &= this.isValid(s);
        }
        return isValid;
    }

    private boolean isValid(String s) {
        return s != null && !"".equals(s);
    }
}

