/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ResourceBundle;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class Task
extends BaseDocument {
    private String parentId;
    private String topParentId;
    private String subject;
    private String description;
    private String createdById;
    private String responsibleId;
    private String responsibleName;
    private String modifiedById;
    private String startedById;
    private String completedById;
    private TaskStatus status;
    private String priorityId;
    private String prioritySubject;
    private String categoryId;
    private String categorySubject;
    private long startDate;
    private long completedDate;
    private long deadline;

    public Task() {
    }

    public Task(ResultSet rs) throws SQLException {
        super(rs);
        Timestamp completedStamp;
        this.documentId = rs.getString("task_id");
        this.parentId = rs.getString("parent_id");
        this.topParentId = rs.getString("topparent_id");
        this.createdById = rs.getString("createdby_id");
        this.responsibleId = rs.getString("responsible_id");
        this.modifiedById = rs.getString("modifiedby_id");
        this.startedById = rs.getString("startedby_id");
        this.completedById = rs.getString("completedby_id");
        this.status = TaskStatus.of(rs.getInt("status"));
        this.priorityId = rs.getString("priority_id");
        this.categoryId = rs.getString("category_id");
        this.subject = rs.getString("subject");
        this.description = rs.getString("description");
        this.startDate = rs.getTimestamp("startdate").getTime();
        Timestamp deadlineStamp = rs.getTimestamp("deadline");
        if (deadlineStamp != null) {
            this.deadline = deadlineStamp.getTime();
        }
        if ((completedStamp = rs.getTimestamp("completed")) != null) {
            this.completedDate = completedStamp.getTime();
        }
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getTopParentId() {
        return this.topParentId;
    }

    public void setTopParentId(String topParentId) {
        this.topParentId = topParentId;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(String createdById) {
        this.createdById = createdById;
    }

    public String getResponsibleId() {
        return this.responsibleId;
    }

    public void setResponsibleId(String responsibleId) {
        this.responsibleId = responsibleId;
    }

    public String getModifiedById() {
        return this.modifiedById;
    }

    public void setModifiedById(String modifiedById) {
        this.modifiedById = modifiedById;
    }

    public String getStartedById() {
        return this.startedById;
    }

    public void setStartedById(String startedById) {
        this.startedById = startedById;
    }

    public String getCompletedById() {
        return this.completedById;
    }

    public void setCompletedById(String completedById) {
        this.completedById = completedById;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public boolean isCompleted() {
        return TaskStatus.Completed.equals((Object)this.status);
    }

    public String getPriorityId() {
        return this.priorityId;
    }

    public void setPriorityId(String priorityId) {
        this.priorityId = priorityId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getPrioritySubject() {
        return this.prioritySubject;
    }

    public void setPrioritySubject(String prioritySubject) {
        this.prioritySubject = prioritySubject;
    }

    public String getCategorySubject() {
        return this.categorySubject;
    }

    public void setCategorySubject(String categorySubject) {
        this.categorySubject = categorySubject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public long getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(long completedDate) {
        this.completedDate = completedDate;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }

    public String getResponsibleName() {
        return this.responsibleName;
    }

    public void setResponsibleName(String responsibleName) {
        this.responsibleName = responsibleName;
    }

    @Override
    public Element getXml() {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common");
        Element el = super.getBaseXml("task");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addCDATAElement(el, "description", this.description);
        Dom4JUtil.addElement(el, "parent_id", this.parentId);
        Dom4JUtil.addElement(el, "topparent_id", this.topParentId);
        Dom4JUtil.addElement(el, "createby_id", this.createdById);
        Dom4JUtil.addElement(el, "responsible_id", this.responsibleId);
        Dom4JUtil.addElement(el, "responsible", this.responsibleName);
        Dom4JUtil.addElement(el, "status", this.status.toString());
        Dom4JUtil.addElement(el, "category", this.categorySubject);
        Dom4JUtil.addElement(el, "category_id", this.categoryId);
        Dom4JUtil.addElement(el, "priority", this.prioritySubject);
        Dom4JUtil.addElement(el, "priority_id", this.priorityId);
        if (rb.containsKey("task.status." + this.status.toString().toLowerCase())) {
            Dom4JUtil.addElement(el, "statustext", rb.getString("task.status." + this.status.toString().toLowerCase()));
        } else {
            Dom4JUtil.addElement(el, "statustext", this.status.toString());
        }
        el.addElement("startdate").setText(LocaleUtil.formatDateShort(this.startDate));
        el.addElement("startdate_alt").setText(LocaleUtil.formatDate(this.startDate));
        if (this.deadline > 0L) {
            el.addElement("deadline").setText(LocaleUtil.formatDateShort(this.deadline));
            el.addElement("deadline_alt").setText(LocaleUtil.formatDate(this.deadline));
            el.addElement("deadline_sortable").setText(LocaleUtil.formatDateAsSortable(this.deadline));
        }
        if (this.completedDate > 0L) {
            el.addElement("completed").setText(LocaleUtil.formatDateShort(this.completedDate));
            el.addElement("completed_alt").setText(LocaleUtil.formatDate(this.completedDate));
        }
        return el;
    }

    public static enum TaskStatus {
        NotStarted(0),
        InProgress(1),
        Completed(2);

        private int code;

        private TaskStatus(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public static TaskStatus of(int code) {
            switch (code) {
                case 0: {
                    return NotStarted;
                }
                case 1: {
                    return InProgress;
                }
                case 2: {
                    return Completed;
                }
            }
            return null;
        }
    }
}

