/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.util.CertificateDetails;
import net.gopro.selfservice.util.PKCS7Util;
import net.gopro.selfservice.util.XMLSignatureUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SignedFormDocument
extends ExternalDocument {
    private static final PKCS7Util pkcs7Util = new PKCS7Util();
    private static final XMLSignatureUtil xmldigsigUtil = new XMLSignatureUtil();
    private static final String MIMETYPE_PKCS7 = "application/pkcs7-signed-data";
    private static final String MIMETYPE_XMLDIGSIG = "application/xml";

    public SignedFormDocument() {
        this.mimetype = this.getMimetype(SignedDocumentType.PKCS7);
        this.isFromGoPro = false;
    }

    public SignedFormDocument(SignedDocumentType type) {
        this.mimetype = this.getMimetype(type);
        this.isFromGoPro = false;
    }

    public final boolean verifySignature() throws CertificateException, SelfServiceException {
        if (this.stream != null) {
            throw new SelfServiceException("Not Implemented");
        }
        return false;
    }

    public final List<X509Certificate> getCertificates() throws CertificateException, SelfServiceException {
        SignedDocumentType type = this.getSignedDocumentType();
        if (this.stream != null) {
            if (SignedDocumentType.PKCS7.equals((Object)type)) {
                return pkcs7Util.getCertificates(this.stream);
            }
            if (SignedDocumentType.XML_SIGNATURE.equals((Object)type)) {
                return xmldigsigUtil.getCertificates(this.stream);
            }
        }
        return new ArrayList<X509Certificate>();
    }

    public final String getSignedContent() throws CertificateException, SelfServiceException {
        SignedDocumentType type = this.getSignedDocumentType();
        if (this.stream != null) {
            if (SignedDocumentType.PKCS7.equals((Object)type)) {
                return pkcs7Util.getSignedContent(this.stream);
            }
            if (SignedDocumentType.XML_SIGNATURE.equals((Object)type)) {
                return xmldigsigUtil.getSignedContent(this.stream);
            }
        }
        return null;
    }

    public Element getCertificateDataAsXml() throws CertificateException, SelfServiceException {
        Element el = DocumentHelper.createElement((String)"certificates");
        for (X509Certificate cert : this.getCertificates()) {
            CertificateDetails cde = new CertificateDetails(cert);
            el.add(cde.getXml());
        }
        return el;
    }

    public String getExtension(SignedDocumentType type) {
        if (SignedDocumentType.PKCS7.equals((Object)type)) {
            return "p7s";
        }
        if (SignedDocumentType.XML_SIGNATURE.equals((Object)type)) {
            return "xml";
        }
        throw new RuntimeException("Extension not configured for " + type.toString());
    }

    public String getMimetype(SignedDocumentType type) {
        if (SignedDocumentType.PKCS7.equals((Object)type)) {
            return MIMETYPE_PKCS7;
        }
        if (SignedDocumentType.XML_SIGNATURE.equals((Object)type)) {
            return MIMETYPE_XMLDIGSIG;
        }
        throw new RuntimeException("Mimetype not configured for " + type.toString());
    }

    public SignedDocumentType getSignedDocumentType() {
        if (MIMETYPE_PKCS7.equals(this.mimetype)) {
            return SignedDocumentType.PKCS7;
        }
        if (MIMETYPE_XMLDIGSIG.equals(this.mimetype)) {
            return SignedDocumentType.XML_SIGNATURE;
        }
        throw new RuntimeException(String.format("Mimetype %s is not a Signed document format!", this.mimetype));
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("signedformdocument");
        return el;
    }

    public static enum SignedDocumentType {
        PKCS7,
        XML_SIGNATURE;

    }
}

