/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Iterator;
import net.gopro.selfservice.IMessageProcessHookIn;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.util.Dom4JUtil;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class Organization
extends BaseDocument {
    public static final String KEYSALT = "_G0$Pro#.S3lf";
    private static final Logger logger = Logger.getLogger(Organization.class);
    private String subject;
    private String alias;
    private String cssFile;
    private String footer;
    private boolean isEnabled;
    private boolean isRemoteTemplatesEnabled = false;
    private boolean isServiceAccountEnabled = false;
    private String serviceAccountEmail;
    private String customClass;
    private Endpoint endpoint;
    private boolean isSigning;
    private byte[] certificate;
    private String certificateKey;
    private int formTemplateCount = 0;
    private int mailOptions;

    public Organization() {
        this.isEnabled = true;
        EnumSet<MailPreference> prefs = EnumSet.allOf(MailPreference.class);
        Iterator it = prefs.iterator();
        while (it.hasNext()) {
            this.mailOptions += ((MailPreference)((Object)it.next())).value;
        }
    }

    public Organization(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("organization_id");
        this.subject = rs.getString("subject");
        this.alias = rs.getString("alias");
        this.cssFile = rs.getString("cssfile");
        this.footer = rs.getString("footer");
        this.isSigning = rs.getInt("is_signature") == 1;
        this.isEnabled = rs.getInt("is_enabled") == 1;
        this.isRemoteTemplatesEnabled = rs.getInt("is_remote") == 1;
        this.isServiceAccountEnabled = rs.getInt("is_service") == 1;
        this.serviceAccountEmail = rs.getString("serviceemail");
        this.mailOptions = rs.getInt("mailoptions");
        this.customClass = rs.getString("customclass");
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public String getCssFile() {
        return this.cssFile;
    }

    public void setCssFile(String cssFile) {
        this.cssFile = cssFile;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isSigning() {
        return this.isSigning;
    }

    public void setSigning(boolean isSigning) {
        this.isSigning = isSigning;
    }

    public boolean isRemoteTemplatesEnabled() {
        return this.isRemoteTemplatesEnabled;
    }

    public void setRemoteTemplatesEnabled(boolean isRemoteTemplatesEnabled) {
        this.isRemoteTemplatesEnabled = isRemoteTemplatesEnabled;
    }

    public boolean isServiceAccountEnabled() {
        return this.isServiceAccountEnabled;
    }

    public void setServiceAccountEnabled(boolean isServiceAccountEnabled) {
        this.isServiceAccountEnabled = isServiceAccountEnabled;
    }

    public int getMailOptions() {
        return this.mailOptions;
    }

    public void setMailOptions(int mailOptions) {
        this.mailOptions = mailOptions;
    }

    public String getServiceAccountEmail() {
        return this.serviceAccountEmail;
    }

    public void setServiceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public String getCertificateKey() {
        return this.certificateKey;
    }

    public void setCertificateKey(String certificateKey) {
        this.certificateKey = certificateKey;
    }

    public final int getFormTemplateCount() {
        return this.formTemplateCount;
    }

    public final void setFormTemplateCount(int formTemplateCount) {
        this.formTemplateCount = formTemplateCount;
    }

    public boolean isMailOptionEnabled(MailPreference pref) {
        return (this.mailOptions & pref.getValue()) != 0;
    }

    public String getCustomClass() {
        return this.customClass;
    }

    public void setCustomClass(String customClass) {
        this.customClass = customClass;
    }

    public IMessageProcessHookIn getMessageProcessHookIn() throws RuntimeException {
        try {
            Object o;
            if (this.customClass != null && !"".equals(this.customClass) && (o = Class.forName(this.customClass).newInstance()) instanceof IMessageProcessHookIn) {
                return (IMessageProcessHookIn)o;
            }
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)String.format("IMessageProcessHookIn Class \"%s\" not found.", this.customClass), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            logger.error((Object)String.format("Could not instantiate IMessageProcessHookIn class \"%s\"", this.customClass), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            logger.error((Object)String.format("Illegal Access on IMessageProcessHookIn class \"%s\"", this.customClass), (Throwable)ex);
        }
        return null;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("organization");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addElement(el, "alias", this.alias);
        Dom4JUtil.addElement(el, "cssfile", this.cssFile);
        Dom4JUtil.addElement(el, "templates", String.valueOf(this.formTemplateCount));
        Dom4JUtil.addCDATAElement(el, "footer", this.footer);
        Dom4JUtil.addElement(el, "is_enabled", String.valueOf(this.isEnabled));
        Dom4JUtil.addElement(el, "is_remote", String.valueOf(this.isRemoteTemplatesEnabled));
        if (this.endpoint != null) {
            el.add(this.endpoint.getXml());
        }
        return el;
    }

    public Element getXml(boolean hideEndpoint) {
        if (hideEndpoint) {
            Element el = this.getXml();
            el.selectSingleNode("endpoint").detach();
            return el;
        }
        return this.getXml();
    }

    @Override
    public int compareTo(BaseDocument o) {
        if (o instanceof Organization) {
            return this.subject.compareTo(((Organization)o).getSubject());
        }
        return super.compareTo(o);
    }

    public static enum MailPreference {
        ApplicationConfirmation(1),
        CaseStatusUpdates(2),
        NewCaseDocuments(4),
        CaseReminders(8),
        ContactNotifications(16),
        TaskReminders(32);

        private int value;

        private MailPreference(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

