/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import is.hugvit.util.UID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class List
extends BaseDocument {
    protected String subject;
    protected String description;
    protected String defaultId;
    protected boolean isSystemList;
    protected ArrayList<ListItem> listItems = new ArrayList();

    public List() {
    }

    public List(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("list_id");
        this.defaultId = rs.getString("default_id");
        this.subject = rs.getString("subject");
        this.description = rs.getString("description");
        this.isSystemList = rs.getInt("is_system") == 1;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public boolean isSystemList() {
        return this.isSystemList;
    }

    public void setSystemList(boolean isSystemList) {
        this.isSystemList = isSystemList;
    }

    public ArrayList<ListItem> getListItems() {
        return this.listItems;
    }

    public ListItem getListItem(String itemId) {
        for (ListItem item : this.listItems) {
            if (!item.getId().equals(itemId)) continue;
            return item;
        }
        return null;
    }

    public ListItem getDefaultListItem() {
        if (this.defaultId == null) {
            return null;
        }
        for (ListItem item : this.listItems) {
            if (!item.getId().equals(this.defaultId)) continue;
            return item;
        }
        return null;
    }

    public void addListItem(ListItem item) {
        this.addListItem(item, false);
    }

    public void addListItem(ListItem item, boolean isDefault) {
        item.setDirty(true);
        if (item.getId() == null) {
            item.setId(UID.getUID());
        }
        if (isDefault) {
            this.defaultId = item.getId();
        }
        this.listItems.add(item);
    }

    public int getItemCount(boolean includeDeleted) {
        if (includeDeleted) {
            return this.listItems.size();
        }
        int itemCount = 0;
        for (ListItem item : this.listItems) {
            if (item.isDeleted()) continue;
            ++itemCount;
        }
        return itemCount;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("list");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addElement(el, "description", this.description);
        Dom4JUtil.addElement(el, "default_id", this.defaultId);
        el.addElement("is_system").setText(String.valueOf(this.isSystemList));
        if (this.listItems.size() > 0) {
            Element elItems = el.addElement("listitems");
            for (ListItem li : this.listItems) {
                elItems.add(li.getXml());
            }
        }
        return el;
    }
}

