/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.SignedFormDocument;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class FormCase
extends BaseCase {
    public static final String CASETEMPLATE_ID = "00278849E25F336B0000012E156D54D9";
    protected String formtemplateId;
    protected boolean isShared = false;
    protected boolean isPrimaryApplication = false;
    protected boolean isNewMemoAvailable = true;
    protected boolean isNewAttachmentAvailable = true;
    protected String parentId;

    public FormCase() {
    }

    public FormCase(String formtemplateId) {
        this.formtemplateId = formtemplateId;
    }

    public FormCase(FormTemplate template) {
        this.formtemplateId = template.getId();
        this.isNewMemoAvailable = template.isMemoVisible();
        this.isNewAttachmentAvailable = template.isAttachmentVisible();
        this.subject = template.getSubject();
        if (template.getExtendedData() != null) {
            this.caseFlow = template.getExtendedData().getCaseStatusList();
        }
    }

    @Override
    public void loadInstance(ResultSet rs) throws SQLException {
        super.loadInstance(rs);
        this.formtemplateId = rs.getString("formtemplate_id");
        this.isShared = rs.getInt("is_shared") == 1;
        this.parentId = rs.getString("parent_id");
    }

    public String getFormtemplateId() {
        return this.formtemplateId;
    }

    public void setFormtemplateId(String formtemplateId) {
        this.formtemplateId = formtemplateId;
    }

    public ApplicationForm getApplicationForm() {
        for (SubDocument doc : this.subDocuments) {
            if (!(doc instanceof ApplicationForm)) continue;
            return (ApplicationForm)doc;
        }
        return null;
    }

    public void setApplicationForm(ApplicationForm form) {
        Iterator it = this.subDocuments.iterator();
        while (it.hasNext()) {
            SubDocument doc = (SubDocument)it.next();
            if (!(doc instanceof ApplicationForm)) continue;
            it.remove();
        }
        this.addSubDocument(form);
    }

    public CompletedFormDocument getCompletedFormDocument() {
        for (SubDocument doc : this.subDocuments) {
            if (!(doc instanceof CompletedFormDocument) || doc.isDeleted()) continue;
            return (CompletedFormDocument)doc;
        }
        return null;
    }

    public SignedFormDocument getSignedFormDocument() {
        if (this.isSigned) {
            for (SubDocument doc : this.subDocuments) {
                if (!(doc instanceof SignedFormDocument)) continue;
                return (SignedFormDocument)doc;
            }
        }
        return null;
    }

    public boolean isNewMemoAvailable() {
        return this.isNewMemoAvailable;
    }

    public void setNewMemoAvailable(boolean isNewMemoAvailable) {
        this.isNewMemoAvailable = isNewMemoAvailable;
    }

    public boolean isNewAttachmentAvailable() {
        return this.isNewAttachmentAvailable;
    }

    public void setNewAttachmentAvailable(boolean isNewAttachmentAvailable) {
        this.isNewAttachmentAvailable = isNewAttachmentAvailable;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("case");
        Dom4JUtil.addElement(el, "formtemplate_id", this.formtemplateId);
        Dom4JUtil.addElement(el, "is_attachment", String.valueOf(this.isNewAttachmentAvailable));
        Dom4JUtil.addElement(el, "is_memo", String.valueOf(this.isNewMemoAvailable));
        Dom4JUtil.addElement(el, "is_shared", String.valueOf(this.isShared));
        Dom4JUtil.addElement(el, "is_primary", String.valueOf(this.isPrimaryApplication));
        Dom4JUtil.addElement(el, "parent_id", this.parentId);
        return el;
    }

    @Override
    public int getVisibleSubdocumentCount() {
        int totalCount = super.getSubDocumentCount();
        --totalCount;
        if (this.isSent) {
            --totalCount;
        }
        if (this.isSigned) {
            --totalCount;
        }
        if (totalCount < 0) {
            return 0;
        }
        return totalCount;
    }

    @Override
    public boolean isCheckOutRequired() {
        return (this.isShared() || this.isCompanyCase()) && !this.isSent;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean isShared) {
        this.isShared = isShared;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setPrimaryApplication(boolean isPrimaryApplication) {
        this.isPrimaryApplication = isPrimaryApplication;
    }
}

