/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.gopro.selfservice.data.SubDocument;
import org.apache.commons.io.FileUtils;
import org.dom4j.Element;

public abstract class ExternalDocument
extends SubDocument {
    protected long filesize;
    protected byte[] stream;
    protected String filename;
    protected String mimetype;

    public void loadInstance(ResultSet rs) throws SQLException {
        this.documentId = rs.getString("document_id");
        this.caseId = rs.getString("case_id");
        this.parentId = rs.getString("parent_id");
        this.goProId = rs.getString("gopro_id");
        this.createdById = rs.getString("createdby_id");
        this.statusId = rs.getString("status_id");
        this.subject = rs.getString("subject");
        this.body = rs.getString("body");
        this.isSent = rs.getInt("is_sent") == 1;
        this.filesize = rs.getLong("filesize");
        this.filename = rs.getString("filename");
        this.mimetype = rs.getString("mimetype");
        this.saveCounter = rs.getInt("savecounter");
        this.responseCount = rs.getInt("responsecount");
        this.isFromGoPro = rs.getInt("is_fromgopro") == 1;
        this.isPersonalSensitive = rs.getInt("is_sensitive") == 1;
        this.isDeleted = rs.getInt("is_deleted") == 1;
        this.dateCreated = rs.getTimestamp("created").getTime();
        this.dateModified = rs.getTimestamp("modified").getTime();
        Timestamp tsCompleted = rs.getTimestamp("completed");
        if (tsCompleted != null) {
            this.dateCompleted = tsCompleted.getTime();
        }
        this.modifiedById = rs.getString("modifiedby_id");
        this.completedById = rs.getString("completedby_id");
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public byte[] getStream() {
        return this.stream;
    }

    public void setStream(byte[] stream) {
        this.stream = stream;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFileName(String filename, String extension) {
        this.filename = filename + "." + extension;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    @Override
    protected Element getBaseXml(String rootName) {
        Element el = super.getBaseXml(rootName);
        el.addElement("filename").setText(this.filename);
        el.addElement("filesize").setText(Long.toString(this.filesize));
        el.addElement("humanfilesize").addText(FileUtils.byteCountToDisplaySize((long)this.filesize));
        return el;
    }
}

