/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class EmailRecipient {
    private String name;
    private String emailaddress;
    Email.RecipientType type = Email.RecipientType.TO;

    public EmailRecipient() {
    }

    public EmailRecipient(String name, String address, Email.RecipientType type) {
        this(address, type);
        this.name = name;
    }

    public EmailRecipient(String address, Email.RecipientType type) {
        this.emailaddress = address;
        this.type = type;
    }

    public EmailRecipient(ResultSet rs) throws SQLException {
        this.name = rs.getString("name");
        this.emailaddress = rs.getString("email");
        try {
            this.type = Email.RecipientType.valueOf(rs.getString("type"));
        }
        catch (Exception ex) {
            this.type = Email.RecipientType.TO;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmailaddress() {
        return this.emailaddress;
    }

    public void setEmailaddress(String emailaddress) {
        this.emailaddress = emailaddress;
    }

    public Email.RecipientType getType() {
        return this.type;
    }

    public void setType(Email.RecipientType type) {
        this.type = type;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"recipient");
        Dom4JUtil.addElement(el, "name", this.name);
        Dom4JUtil.addElement(el, "emailaddress", this.emailaddress);
        if (this.type != null) {
            el.addElement("type").setText(this.type.toString());
        }
        return el;
    }
}

