/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.gopro.selfservice.data.EmailAttachment;
import net.gopro.selfservice.data.EmailRecipient;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class Email
extends SubDocument {
    private String fromName;
    private String fromEmail;
    private List<EmailRecipient> recipients = new ArrayList<EmailRecipient>();
    private List<EmailAttachment> attachments = new ArrayList<EmailAttachment>();

    public Email() {
    }

    public Email(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("email_id");
        this.fromName = rs.getString("fromname");
        this.fromEmail = rs.getString("fromemail");
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public List<EmailRecipient> getRecipients() {
        return this.recipients;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("subdocument");
        Dom4JUtil.addElement(el, "fromname", this.fromName);
        Dom4JUtil.addElement(el, "fromemail", this.fromEmail);
        for (EmailRecipient rec : this.recipients) {
            el.add(rec.getXml());
        }
        Dom4JUtil.addElement(el, "attacmentcount", String.valueOf(this.attachments.size()));
        for (EmailAttachment att : this.attachments) {
            el.add(att.getXml());
        }
        return el;
    }

    public static enum RecipientType {
        TO,
        CC,
        BCC;

    }
}

