/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DirectoryUser
implements Comparable<DirectoryUser> {
    protected String selfServiceUserId;
    protected String ssn;
    protected String ssnSpouse;
    protected String fullName;
    protected String email;
    protected String streetName;
    protected String streetNumber;
    protected String postcode;
    protected String city;
    protected String familyNumber;
    protected String countryCode;
    protected String municipalityCode;
    protected String organization;
    protected Date dateOfBirth;
    protected Gender gender;
    protected MaritialStatus maritialStatus;
    protected DirectoryUser spouse;
    protected List<DirectoryUser> children = new ArrayList<DirectoryUser>();
    protected Map<String, String> extradata = new HashMap<String, String>();

    public String getSelfServiceUserId() {
        return this.selfServiceUserId;
    }

    public void setSelfServiceUserId(String selfServiceUserId) {
        this.selfServiceUserId = selfServiceUserId;
    }

    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public String getSsnSpouse() {
        return this.ssnSpouse;
    }

    public void setSpouse(DirectoryUser spouse) {
        this.spouse = spouse;
    }

    public void setSsnSpouse(String ssnSpouse) {
        this.ssnSpouse = ssnSpouse;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getFamilyNumber() {
        return this.familyNumber;
    }

    public void setFamilyNumber(String familyNumber) {
        this.familyNumber = familyNumber;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getMunicipalityCode() {
        return this.municipalityCode;
    }

    public void setMunicipalityCode(String municipalityCode) {
        this.municipalityCode = municipalityCode;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public MaritialStatus getMaritialStatus() {
        return this.maritialStatus;
    }

    public void setMaritialStatus(MaritialStatus maritialStatus) {
        this.maritialStatus = maritialStatus;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public DirectoryUser getSpouse() {
        return this.spouse;
    }

    public List<DirectoryUser> getChildren() {
        return this.children;
    }

    public Map<String, String> getExtradata() {
        return this.extradata;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"directoryuser");
        Dom4JUtil.addElement(el, "fullname", this.fullName);
        Dom4JUtil.addElement(el, "city", this.city);
        Dom4JUtil.addElement(el, "countrycode", this.countryCode);
        if (this.dateOfBirth != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.dateOfBirth);
            Dom4JUtil.addCDATAElement(el, "birthdate", LocaleUtil.formatDateShort(cal.getTimeInMillis()));
            Dom4JUtil.addElement(el, "yearborn", String.valueOf(cal.get(1)));
        }
        Dom4JUtil.addElement(el, "email", this.email);
        Dom4JUtil.addCDATAElement(el, "familynumber", this.familyNumber);
        if (this.gender != null) {
            Dom4JUtil.addElement(el, "gender", this.gender.toString());
        }
        if (this.maritialStatus != null) {
            Dom4JUtil.addElement(el, "maritialstatus", this.maritialStatus.toString());
        }
        Dom4JUtil.addElement(el, "municipality", this.municipalityCode);
        Dom4JUtil.addElement(el, "organization", this.organization);
        Dom4JUtil.addElement(el, "postcode", this.postcode);
        Dom4JUtil.addCDATAElement(el, "ssn", this.ssn);
        Dom4JUtil.addCDATAElement(el, "ssnspouse", this.ssnSpouse);
        Dom4JUtil.addElement(el, "streetname", this.streetName);
        Dom4JUtil.addElement(el, "streetnumber", this.streetNumber);
        Element elFamily = el.addElement("family");
        if (this.spouse != null) {
            Element elSpouse = this.spouse.getXml();
            elSpouse.addAttribute("type", "spouse");
            elFamily.add(elSpouse);
        }
        if (this.children != null && this.children.size() > 0) {
            for (DirectoryUser child : this.children) {
                Element elChild = child.getXml();
                elChild.addAttribute("type", "child");
                elFamily.add(elChild);
            }
        }
        if (this.extradata.size() > 0) {
            Element els = el.addElement("extras");
            Set<String> keys = this.extradata.keySet();
            for (String key : keys) {
                String value = this.extradata.get(key);
                Dom4JUtil.addElement(els, key, value);
            }
        }
        return el;
    }

    @Override
    public int compareTo(DirectoryUser other) {
        int comparison;
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this.ssn != null && other.getSsn() != null) {
            return this.ssn.compareTo(other.getSsn());
        }
        if (this.fullName != null && other.getFullName() != null && (comparison = this.fullName.compareTo(other.getFullName())) != 0) {
            return comparison;
        }
        if (this.dateOfBirth != null && other.dateOfBirth != null && (comparison = this.dateOfBirth.compareTo(other.getDateOfBirth())) != 0) {
            return comparison;
        }
        if (this.selfServiceUserId != null && other.getSelfServiceUserId() != null) {
            return this.selfServiceUserId.compareTo(other.getSelfServiceUserId());
        }
        if (this.ssnSpouse != null) {
            if (other.getSsnSpouse() == null) {
                return 1;
            }
            return this.ssnSpouse.compareTo(other.getSsnSpouse());
        }
        return 0;
    }

    public static enum MaritialStatus {
        Married,
        Single,
        Divorced,
        Widowed;

    }

    public static enum Gender {
        Male,
        Female;

    }
}

