/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.GoProCompanyReference;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class Company
extends BaseDocument {
    private String name;
    private Address address;
    private List<User> contacts = new ArrayList<User>();
    private int contactCount = 0;
    protected Set<GoProCompanyReference> goproCompanyReferences = new HashSet<GoProCompanyReference>();

    public Company() {
    }

    public Company(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("company_id");
        this.name = rs.getString("name");
        this.address = new Address(rs);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<User> getContacts() {
        return this.contacts;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Set<GoProCompanyReference> getGoproCompanyReferences() {
        return this.goproCompanyReferences;
    }

    public GoProCompanyReference getGoProCompanyReference(String organizationId) {
        for (GoProCompanyReference ref : this.goproCompanyReferences) {
            if (!ref.getOrganizationId().equals(organizationId)) continue;
            return ref;
        }
        return null;
    }

    public int getContactCount() {
        if (this.contacts.size() == 0) {
            return this.contactCount;
        }
        return this.contacts.size();
    }

    public void setContactCount(int contactCount) {
        this.contactCount = contactCount;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("company");
        Dom4JUtil.addElement(el, "name", this.name);
        el.addAttribute("contacts", String.valueOf(this.getContactCount()));
        if (this.address != null) {
            el.add(this.address.getXml());
        }
        if (this.goproCompanyReferences.size() > 0) {
            Element elRef = el.addElement("reference");
            for (GoProCompanyReference ref : this.goproCompanyReferences) {
                elRef.add(ref.getXml());
            }
        }
        return el;
    }
}

