/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.IAccessControlled;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public abstract class BaseCase
extends BaseDocument
implements IAccessControlled {
    protected String createdById;
    protected String caseTemplateId;
    protected String organizationId;
    protected String goproId;
    protected String goproAlias;
    protected String goproCaseNumber;
    protected String referenceNumber;
    protected String statusId;
    protected String statusText;
    protected String subject;
    protected String body;
    protected long dateCompleted;
    protected String completedById;
    protected String modifiedById;
    protected boolean isSent;
    protected boolean isSigned = false;
    protected boolean isSignaturePending = false;
    protected boolean isReOpened = false;
    protected boolean isPersonalSensitive = false;
    protected int responseCount = 0;
    protected int subDocumentCount = 0;
    protected LinkedList<StatusListItem> caseFlow = new LinkedList();
    protected StatusListItem status = null;
    protected String contactId = null;
    protected String companyId = null;
    protected List<AccessControl> accessControlList = new ArrayList<AccessControl>();
    protected List<SubDocument> subDocuments = new ArrayList<SubDocument>();

    public abstract int getVisibleSubdocumentCount();

    public abstract boolean isCheckOutRequired();

    public void loadInstance(ResultSet rs) throws SQLException {
        this.documentId = rs.getString("case_id");
        this.createdById = rs.getString("createdby_id");
        this.caseTemplateId = rs.getString("casetemplate_id");
        this.organizationId = rs.getString("organization_id");
        this.contactId = rs.getString("contact_id");
        this.companyId = rs.getString("company_id");
        this.goproId = rs.getString("gopro_id");
        this.goproCaseNumber = rs.getString("gopro_casenumber");
        this.referenceNumber = rs.getString("reference_number");
        this.statusId = rs.getString("status_id");
        this.subject = rs.getString("subject");
        this.body = rs.getString("body");
        this.isSent = rs.getInt("is_sent") == 1;
        this.isSigned = rs.getInt("is_signed") == 1;
        this.isSignaturePending = rs.getInt("is_signaturepending") == 1;
        this.isReOpened = rs.getInt("is_reopened") == 1;
        this.isPersonalSensitive = rs.getInt("is_sensitive") == 1;
        this.responseCount = rs.getInt("responsecount");
        this.isDeleted = rs.getInt("is_deleted") == 1;
        this.dateCreated = rs.getTimestamp("created").getTime();
        this.dateModified = rs.getTimestamp("modified").getTime();
        Timestamp tsCompleted = rs.getTimestamp("completed");
        if (tsCompleted != null) {
            this.dateCompleted = tsCompleted.getTime();
        }
        this.modifiedById = rs.getString("modifiedby_id");
        this.completedById = rs.getString("completedby_id");
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setStatus(StatusListItem status) {
        this.status = status;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(String userId) {
        this.createdById = userId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getCaseTemplateId() {
        return this.caseTemplateId;
    }

    public void setCaseTemplateId(String caseTemplateId) {
        this.caseTemplateId = caseTemplateId;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public boolean isSent() {
        return this.isSent;
    }

    public void setSent(boolean isSent) {
        this.isSent = isSent;
    }

    public boolean isPersonalSensitive() {
        return this.isPersonalSensitive;
    }

    public void setPersonalSensitive(boolean isPersonalSensitive) {
        this.isPersonalSensitive = isPersonalSensitive;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public void setSigned(boolean isSigned) {
        this.isSigned = isSigned;
    }

    public boolean isSignaturePending() {
        return this.isSignaturePending;
    }

    public void setSignaturePending(boolean isSignaturePending) {
        this.isSignaturePending = isSignaturePending;
    }

    public boolean isReOpened() {
        return this.isReOpened;
    }

    public void setReOpened(boolean isReOpened) {
        this.isReOpened = isReOpened;
    }

    public String getGoProId() {
        return this.goproId;
    }

    public void setGoProId(String goProId) {
        this.goproId = goProId;
    }

    public StatusListItem getStatus() {
        if (this.status != null) {
            return this.status;
        }
        for (StatusListItem sli : this.caseFlow) {
            if (!sli.getId().equals(this.statusId)) continue;
            return sli;
        }
        return null;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getGoProAlias() {
        return this.goproAlias;
    }

    public void setGoProAlias(String goProAlias) {
        this.goproAlias = goProAlias;
    }

    public String getGoProCaseNumber() {
        return this.goproCaseNumber;
    }

    public void setGoProCaseNumber(String goproCaseNumber) {
        this.goproCaseNumber = goproCaseNumber;
    }

    public long getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(long dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public String getCompletedById() {
        return this.completedById;
    }

    public void setCompletedById(String completedById) {
        this.completedById = completedById;
    }

    public String getModifiedById() {
        return this.modifiedById;
    }

    public void setModifiedById(String modifiedById) {
        this.modifiedById = modifiedById;
    }

    public List<SubDocument> getSubDocuments() {
        return this.subDocuments;
    }

    public void addSubDocument(SubDocument doc) {
        this.subDocuments.add(doc);
    }

    public LinkedList<StatusListItem> getCaseFlow() {
        return this.caseFlow;
    }

    public void setCaseFlow(LinkedList<StatusListItem> caseFlow) {
        this.caseFlow = caseFlow;
    }

    public int getSubDocumentCount() {
        if (this.subDocuments.size() > 0) {
            return this.getSubDocuments().size();
        }
        return this.subDocumentCount;
    }

    public void setSubDocumentCount(int subDocumentCount) {
        this.subDocumentCount = subDocumentCount;
    }

    public int getResponseCount() {
        return this.responseCount;
    }

    public boolean isCompanyCase() {
        return this.companyId != null;
    }

    public boolean isLocked() {
        StatusListItem status = this.getStatus();
        if (status != null) {
            return StatusListItem.Status.LOCKED.equals((Object)status.getStatus());
        }
        return false;
    }

    @Override
    public List<AccessControl> getAccessControlList() {
        return this.accessControlList;
    }

    public List<Memo> getMemos() {
        ArrayList<Memo> memoList = new ArrayList<Memo>();
        for (SubDocument doc : this.subDocuments) {
            if (!(doc instanceof Memo)) continue;
            memoList.add((Memo)doc);
        }
        return memoList;
    }

    @Override
    protected Element getBaseXml(String rootName) {
        Element el = super.getBaseXml(rootName);
        el.addAttribute("type", this.getClass().getSimpleName());
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addElement(el, "organization_id", this.organizationId);
        Dom4JUtil.addElement(el, "casetemplate_id", this.caseTemplateId);
        Dom4JUtil.addElement(el, "user_id", this.createdById);
        Dom4JUtil.addElement(el, "modifiedby_id", String.valueOf(this.modifiedById));
        Dom4JUtil.addElement(el, "gopro_id", this.goproId);
        Dom4JUtil.addElement(el, "company_id", this.companyId);
        Dom4JUtil.addElement(el, "casenumber", this.goproCaseNumber);
        Dom4JUtil.addElement(el, "refnumber", this.referenceNumber);
        Dom4JUtil.addElement(el, "is_sent", String.valueOf(this.isSent));
        Dom4JUtil.addElement(el, "is_signed", String.valueOf(this.isSigned));
        Dom4JUtil.addElement(el, "is_signaturepending", String.valueOf(this.isSignaturePending));
        Dom4JUtil.addElement(el, "is_reopened", String.valueOf(this.isReOpened));
        Dom4JUtil.addElement(el, "responsecount", String.valueOf(this.responseCount));
        Dom4JUtil.addElement(el, "is_companycase", String.valueOf(this.isCompanyCase()));
        Dom4JUtil.addElement(el, "is_locked", String.valueOf(this.isLocked()));
        Dom4JUtil.addElement(el, "is_sensitive", String.valueOf(this.isPersonalSensitive));
        Dom4JUtil.addElement(el, "status_id", this.statusId);
        if (this.status != null) {
            Dom4JUtil.addElement(el, "status", this.status.getSubject());
        } else if (this.statusText != null && !this.statusText.equals("")) {
            Dom4JUtil.addElement(el, "status", this.statusText);
        }
        if (this.isSent && this.dateCompleted > 0L) {
            el.addElement("completed").setText(LocaleUtil.formatDateShort(this.dateCompleted));
            el.addElement("completed_alt").setText(LocaleUtil.formatDate(this.dateCompleted));
            Dom4JUtil.addElement(el, "completedby_id", this.completedById);
        }
        if (this.body != null) {
            Dom4JUtil.addCDATAElement(el, "body", this.body.replaceAll("\\n", "<br/>"));
        }
        if (this.subDocuments.size() > 0) {
            Element subEl = el.addElement("documents");
            for (SubDocument subDoc : this.subDocuments) {
                subEl.add(subDoc.getXml());
            }
        }
        this.setACLXml(el, this.accessControlList);
        this.createCaseFlowElement(el);
        return el;
    }

    private void createCaseFlowElement(Element root) {
        if (this.caseFlow != null && this.caseFlow.size() > 0) {
            Element elStatus = root.addElement("statusflow");
            String lastStatus = "";
            String previous = "";
            boolean proceessDone = true;
            for (StatusListItem listItem : this.caseFlow) {
                Element els = elStatus.addElement("status");
                els.setText(listItem.getSubject());
                if (listItem.getId().equals(this.statusId)) {
                    els.addAttribute("selected", "true");
                    els.addAttribute("process", "current");
                    proceessDone = false;
                } else if (proceessDone) {
                    els.addAttribute("process", "done");
                } else {
                    els.addAttribute("process", "unfinished");
                }
                if (!"".equals(lastStatus)) {
                    els.addAttribute("laststatus", lastStatus);
                }
                if (!"".equals(previous)) {
                    els.addAttribute("previous", previous);
                }
                previous = els.attributeValue("process");
                lastStatus = listItem.getSubject();
            }
        }
    }
}

