/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class Attachment
extends ExternalDocument {
    private boolean isSigned = false;
    private boolean isSignaturePending = false;
    private List<User> signerList = new ArrayList<User>();
    private int miniumSigner = 0;

    @Override
    public void loadInstance(ResultSet rs) throws SQLException {
        super.loadInstance(rs);
        this.isSigned = rs.getInt("is_signed") == 1;
        this.isSignaturePending = rs.getInt("is_signaturepending") == 1;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public void setSigned(boolean isSigned) {
        this.isSigned = isSigned;
    }

    public boolean isSignaturePending() {
        return this.isSignaturePending;
    }

    public void setSignaturePending(boolean isSignaturePending) {
        this.isSignaturePending = isSignaturePending;
    }

    public List<User> getSignerList() {
        return this.signerList;
    }

    public void setSignerList(List<User> signerList) {
        this.signerList = signerList;
    }

    public int getMiniumSigner() {
        MetaData m = this.getMetaDataByKey("Signing.MinNum");
        if (m != null) {
            return Integer.parseInt(m.getValue());
        }
        return this.miniumSigner;
    }

    public void setMiniumSigner(int miniumSigner) {
        this.miniumSigner = miniumSigner;
    }

    @Override
    public Element getXml() {
        Element el = this.getBaseXml("subdocument");
        Dom4JUtil.addElement(el, "is_signed", String.valueOf(this.isSigned));
        Dom4JUtil.addElement(el, "is_signature_pending", String.valueOf(this.isSignaturePending));
        if (!this.signerList.isEmpty()) {
            List<Signer> completedSigners = this.getCompletedSigners();
            for (User signer : this.signerList) {
                Element si = el.addElement("signer");
                si.addAttribute("id", signer.getId());
                Dom4JUtil.addElement(si, "name", signer.getFullname());
                Dom4JUtil.addElement(si, "email", signer.getEmail());
                Signer completedSigner = this.getSigner(completedSigners, signer.getId());
                if (completedSigner != null) {
                    Dom4JUtil.addElement(si, "completed", "true");
                    Dom4JUtil.addElement(si, "date", LocaleUtil.formatDate(completedSigner.date.getTime()));
                    continue;
                }
                Dom4JUtil.addElement(si, "completed", "false");
            }
            MetaData metaDeadline = this.getMetaDataByKey("Signing.Deadline");
            if (metaDeadline != null) {
                Dom4JUtil.addElement(el, "deadline", LocaleUtil.formatDate(Long.valueOf(metaDeadline.getValue())));
            }
        }
        return el;
    }

    public boolean isSigningCompleted() {
        List<Signer> completedList = this.getCompletedSigners();
        return completedList.size() >= this.getMiniumSigner();
    }

    private Signer getSigner(List<Signer> list, String userId) {
        for (Signer signer : list) {
            if (!signer.id.equals(userId)) continue;
            return signer;
        }
        return null;
    }

    private List<Signer> getCompletedSigners() {
        ArrayList<Signer> list = new ArrayList<Signer>();
        for (MetaData m : this.getMetadata()) {
            if (!"Signature.Instance".equals(m.getKey()) || m.isDeleted()) continue;
            Signer signer = new Signer(m.getUserId(), null, m.getDateCreated());
            list.add(signer);
        }
        return list;
    }

    private class Signer {
        private String id;
        private String name;
        private Date date;

        public Signer(String id, String name, long stamp) {
            this.id = id;
            this.name = name;
            this.date = new Date(stamp);
        }
    }
}

