/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.RecoveryTicket;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.UserRole;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.gopro.GoProCompanyReference;
import net.gopro.selfservice.data.gopro.GoProContactReference;
import net.gopro.selfservice.data.gopro.GoProIndividualReference;
import net.gopro.selfservice.filters.UserFilter;

public class UserDalc
extends BaseDalc {
    protected static final String TBL_CONTACTREF = "ss_contactreference";
    protected static final String TBL_INDIVIDUALREF = "ss_individualreference";
    protected static final String TBL_COMPANYREF = "ss_companyreference";
    protected static final String TBL_ADDRESSES = "ss_addresses";
    protected static final String TBL_RECOVERY = "ss_recoverytickets";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Company getCompany(String companyId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Company co = null;
        String sql = "SELECT c.company_id, c.name, c.is_deleted, c.created, c.modified,a.streetname, a.city, a.postcode, a.state, a.country, (SELECT COUNT(co.contact_id) FROM ss_contacts co  WHERE co.company_id = c.company_id) AS contacts FROM ss_companies c LEFT OUTER JOIN ss_addresses a ON a.reference_id = c.company_id WHERE c.company_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, companyId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                co = new Company(rs);
                co.setContactCount(rs.getInt("contacts"));
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return co;
    }

    public void createCompany(Company com) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"company_id", "name", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_companies", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, com.getId());
            stmt.setString(2, com.getName());
            stmt.setInt(3, com.isDeleted() ? 1 : 0);
            stmt.setTimestamp(4, new Timestamp(com.getDateCreated()));
            stmt.setTimestamp(5, new Timestamp(com.getDateModified()));
            stmt.executeUpdate();
            if (com.getAddress() != null) {
                this.createAddress(com.getId(), com.getAddress());
            }
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    public void updateCompany(Company com) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"name", "is_deleted", "modified", "company_id"};
        String sql = this.createUpdateSQL("ss_companies", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, com.getName());
            stmt.setInt(2, com.isDeleted() ? 1 : 0);
            stmt.setTimestamp(3, new Timestamp(com.getDateModified()));
            stmt.setString(4, com.getId());
            stmt.executeUpdate();
            if (com.getAddress() != null) {
                this.updateAddress(com.getId(), com.getAddress());
            }
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Company> getCompanies() throws SQLException {
        ArrayList<Company> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Company> list = new ArrayList<Company>();
        String sql = this.getQuery("getCompanies");
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Company comp = new Company(rs);
                comp.setContactCount(rs.getInt("contacts"));
                list.add(comp);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Company> getCompaniesWithContacts() throws SQLException {
        ArrayList<Company> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Company> list = new ArrayList<Company>();
        String sql = "SELECT DISTINCT c.company_id,  c.name, c.is_deleted, c.created, c.modified, a.streetname, a.city, a.postcode, a.state, a.country FROM ss_companies c INNER JOIN ss_contacts con ON con.company_id = c.company_id LEFT OUTER JOIN ss_addresses a ON a.reference_id = c.company_id WHERE c.is_deleted = 0 AND con.is_deleted = 0 AND con.is_confirmed = 1 ORDER BY c.name";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(new Company(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Company> getCompaniesByIds(Set<String> companyIds) throws SQLException {
        ArrayList<Company> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Company> list = new ArrayList<Company>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        if (companyIds.size() == 0) {
            return list;
        }
        String sql = "SELECT c.company_id,  c.name, c.is_deleted, c.created, c.modified,a.streetname, a.city, a.postcode, a.state, a.country, (SELECT COUNT(co.contact_id) FROM ss_contacts co  WHERE co.company_id = c.company_id) AS contacts FROM ss_companies c LEFT OUTER JOIN ss_addresses a ON a.reference_id = c.company_id WHERE c.is_deleted = 0 AND (";
        Iterator<String> it = companyIds.iterator();
        int counter = 0;
        while (it.hasNext()) {
            if (counter > 0) {
                sql = sql + " OR ";
            }
            sql = sql + "c.company_id = ?";
            paramList.add(new BaseDalc.FilterParam(12, it.next()));
            ++counter;
        }
        sql = sql + ") ORDER BY c.name";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                Company comp = new Company(rs);
                comp.setContactCount(rs.getInt("contacts"));
                list.add(comp);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Company> getCompaniesByOrganization(String organizationId) throws SQLException {
        ArrayList<Company> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Company> list = new ArrayList<Company>();
        String sql = "SELECT c.company_id,  c.name,c.is_deleted, c.created, c.modified,a.streetname, a.city, a.postcode, a.state, a.country, (SELECT COUNT(co.contact_id) FROM ss_contacts co  WHERE co.company_id = c.company_id) AS contacts FROM ss_companies c LEFT OUTER JOIN ss_addresses a ON a.reference_id = c.company_id INNER JOIN ss_companyreference r ON r.company_id = c.company_id WHERE r.organization_id = ? AND c.is_deleted = 0 ORDER BY c.name";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, organizationId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Company comp = new Company(rs);
                comp.setContactCount(rs.getInt("contacts"));
                list.add(comp);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    public void createUser(User user) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"user_id", "username", "fullname", "password", "email", "idnumber", "certificate", "homephone", "mobilephone", "communication", "profileimage", "lang", "is_readonly", "is_verified", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_users", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, user.getId());
            stmt.setString(2, user.getUsername());
            stmt.setString(3, user.getFullname());
            stmt.setString(4, user.getPassword());
            stmt.setString(5, user.getEmail());
            stmt.setString(6, user.getIdNumber());
            stmt.setBytes(7, user.getCertificate());
            stmt.setString(8, user.getHomephoneNumber());
            stmt.setString(9, user.getMobilephoneNumber());
            stmt.setString(10, user.getCommunication().toString());
            stmt.setString(11, user.getProfileImage());
            stmt.setString(12, user.getLocale());
            stmt.setInt(13, user.isReadOnlyRestricted() ? 1 : 0);
            stmt.setInt(14, user.isVerified() ? 1 : 0);
            stmt.setInt(15, user.isDeleted() ? 1 : 0);
            stmt.setTimestamp(16, new Timestamp(user.getDateCreated()));
            stmt.setTimestamp(17, new Timestamp(user.getDateModified()));
            stmt.executeUpdate();
            if (user.getAddress() != null) {
                this.createAddress(user.getId(), user.getAddress());
            }
            if (user.getUserRoles().size() > 0) {
                sql = this.createInsertSQL("ss_userrolemap", new String[]{"user_id", "role_id"});
                for (UserRole role : user.getUserRoles()) {
                    stmt = con.prepareStatement(sql);
                    stmt.setString(1, user.getId());
                    stmt.setString(2, role.getId());
                    stmt.executeUpdate();
                }
            }
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String userId) throws SQLException {
        User user;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        User user2 = null;
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id WHERE u.user_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                user2 = new User(rs);
            }
            rs.close();
            if (user2 != null) {
                this.assignUserRoleData(con, user2);
                this.assignContactData(con, user2);
            }
            user = user2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByIdNumber(String idNumber) throws SQLException {
        User user;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        User user2 = null;
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id WHERE u.idnumber = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, idNumber);
            rs = stmt.executeQuery();
            if (rs.next()) {
                user2 = new User(rs);
            }
            rs.close();
            if (user2 != null) {
                this.assignUserRoleData(con, user2);
                this.assignContactData(con, user2);
            }
            user = user2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByEmail(String email, boolean isDeleted) throws SQLException {
        User user;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        User user2 = null;
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id WHERE u.email = ? AND u.is_deleted = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, email);
            stmt.setInt(2, isDeleted ? 1 : 0);
            rs = stmt.executeQuery();
            if (rs.next()) {
                user2 = new User(rs);
            }
            rs.close();
            if (user2 != null) {
                this.assignUserRoleData(con, user2);
                this.assignContactData(con, user2);
            }
            user = user2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByUsername(String username, boolean isDeleted) throws SQLException {
        User user;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        User user2 = null;
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id WHERE u.username = ? AND u.is_deleted = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, username);
            stmt.setInt(2, isDeleted ? 1 : 0);
            rs = stmt.executeQuery();
            if (rs.next()) {
                user2 = new User(rs);
            }
            rs.close();
            if (user2 != null) {
                this.assignUserRoleData(con, user2);
                this.assignContactData(con, user2);
            }
            user = user2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByGoProClientReferenceId(String refId) throws SQLException {
        User user;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        User user2 = null;
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id LEFT OUTER JOIN ss_contactreference r ON r.user_id = u.user_id LEFT OUTER JOIN ss_individualreference i ON i.user_id = u.user_id WHERE r.gopro_id = ? OR i.gopro_id = ? AND u.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, refId);
            stmt.setString(2, refId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                user2 = new User(rs);
            }
            rs.close();
            if (user2 != null) {
                this.assignUserRoleData(con, user2);
                this.assignContactData(con, user2);
            }
            user = user2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUserRole(UserRole role) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"role_id", "rolename", "description", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_userroles", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, role.getId());
            stmt.setString(2, role.getSubject());
            stmt.setString(3, role.getDescription());
            stmt.setInt(4, role.isDeleted() ? 1 : 0);
            stmt.setTimestamp(5, new Timestamp(role.getDateCreated()));
            stmt.setTimestamp(6, new Timestamp(role.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserRole> getUserRoles() throws SQLException {
        ArrayList<UserRole> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<UserRole> list = new ArrayList<UserRole>();
        String sql = "SELECT r.role_id, r.rolename, r.description,r.is_deleted, r.created, r.modified FROM ss_userroles r ORDER BY r.rolename";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(new UserRole(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    public void updateUser(User user) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String[] cols = new String[]{"fullname", "password", "email", "idnumber", "certificate", "homephone", "mobilephone", "communication", "profileimage", "lang", "is_readonly", "is_verified", "is_deleted", "modified", "user_id"};
        String sql = this.createUpdateSQL("ss_users", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, user.getFullname());
            stmt.setString(2, user.getPassword());
            stmt.setString(3, user.getEmail());
            stmt.setString(4, user.getIdNumber());
            stmt.setBytes(5, user.getCertificate());
            stmt.setString(6, user.getHomephoneNumber());
            stmt.setString(7, user.getMobilephoneNumber());
            stmt.setString(8, user.getCommunication().toString());
            stmt.setString(9, user.getProfileImage());
            stmt.setString(10, user.getLocale());
            stmt.setInt(11, user.isReadOnlyRestricted() ? 1 : 0);
            stmt.setInt(12, user.isVerified() ? 1 : 0);
            stmt.setInt(13, user.isDeleted() ? 1 : 0);
            stmt.setTimestamp(14, new Timestamp(user.getDateModified()));
            stmt.setString(15, user.getId());
            stmt.executeUpdate();
            if (user.getAddress() != null) {
                this.updateAddress(user.getId(), user.getAddress());
            }
            ArrayList<String> dbRoles = new ArrayList<String>();
            sql = "SELECT r.role_id FROM ss_userrolemap r WHERE r.user_id=?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, user.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                dbRoles.add(rs.getString("role_id"));
            }
            rs.close();
            for (UserRole role : user.getUserRoles()) {
                if (dbRoles.contains(role.getId())) {
                    dbRoles.remove(role.getId());
                    continue;
                }
                sql = this.createInsertSQL("ss_userrolemap", new String[]{"user_id", "role_id"});
                stmt = con.prepareStatement(sql);
                stmt.setString(1, user.getId());
                stmt.setString(2, role.getId());
                stmt.executeUpdate();
            }
            for (String roleId : dbRoles) {
                sql = "DELETE FROM ss_userrolemap WHERE user_id = ? AND role_id =?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, user.getId());
                stmt.setString(2, roleId);
                stmt.executeUpdate();
            }
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserRole(UserRole role) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"rolename", "description", "is_deleted", "modified", "role_id"};
        String sql = this.createUpdateSQL("ss_userroles", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, role.getSubject());
            stmt.setString(2, role.getDescription());
            stmt.setInt(3, role.isDeleted() ? 1 : 0);
            stmt.setTimestamp(4, new Timestamp(role.getDateModified()));
            stmt.setString(5, role.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getContacts(String companyId, boolean confirmedOnly) throws SQLException {
        ArrayList<User> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<User> list = new ArrayList<User>();
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country, co.contact_id, co.company_id, co.email AS cmail, co.assignedby_id, (SELECT fullname from ss_users WHERE user_id = co.assignedby_id) AS assignee, co.is_manager, co.is_confirmed, co.created AS cc, co.modified AS cm FROM ss_users u INNER JOIN ss_contacts co ON co.user_id = u.user_id LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id WHERE co.company_id = ? AND co.is_deleted = 0 ";
        if (confirmedOnly) {
            sql = sql + " AND co.is_confirmed = 1 ";
        }
        sql = sql + " AND u.is_deleted = 0 ORDER BY u.fullname";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, companyId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                User user = new User(rs);
                Contact ct = new Contact();
                ct.setId(rs.getString("contact_id"));
                ct.setCompanyId(rs.getString("company_id"));
                ct.setAssignedById(rs.getString("assignedby_id"));
                ct.setAssignedByName(rs.getString("assignee"));
                ct.setManager(rs.getInt("is_manager") == 1);
                ct.setEmail(rs.getString("cmail"));
                ct.setDeleted(false);
                ct.setConfirmed(rs.getInt("is_confirmed") == 1);
                ct.setDateCreated(rs.getTimestamp("cc").getTime());
                ct.setDateModified(rs.getTimestamp("cm").getTime());
                user.getContactList().add(ct);
                list.add(user);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGoProClientReference(GoProClientBaseReference ref) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] colsIndividual = new String[]{"reference_id", "user_id", "organization_id", "gopro_id", "is_deleted", "created", "modified"};
        String[] colsContact = new String[]{"reference_id", "user_id", "organization_id", "gopro_id", "is_deleted", "created", "modified", "contact_id"};
        String sql = null;
        if (ref instanceof GoProIndividualReference) {
            sql = this.createInsertSQL(TBL_INDIVIDUALREF, colsIndividual);
        } else if (ref instanceof GoProContactReference) {
            sql = this.createInsertSQL(TBL_CONTACTREF, colsContact);
        } else {
            throw new IllegalArgumentException("Unsupported reference: " + ref.getClass().getName());
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ref.getId());
            stmt.setString(2, ref.getUserId());
            stmt.setString(3, ref.getOrganizationId());
            stmt.setString(4, ref.getGoproId());
            stmt.setInt(5, ref.isDeleted() ? 1 : 0);
            stmt.setTimestamp(6, new Timestamp(ref.getDateCreated()));
            stmt.setTimestamp(7, new Timestamp(ref.getDateModified()));
            if (ref instanceof GoProContactReference) {
                stmt.setString(8, ((GoProContactReference)ref).getContactId());
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGoProCompanyReference(GoProCompanyReference ref) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"reference_id", "company_id", "organization_id", "gopro_company_id", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_COMPANYREF, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ref.getId());
            stmt.setString(2, ref.getCompanyId());
            stmt.setString(3, ref.getOrganizationId());
            stmt.setString(4, ref.getGoproCompanyId());
            stmt.setInt(5, ref.isDeleted() ? 1 : 0);
            stmt.setTimestamp(6, new Timestamp(ref.getDateCreated()));
            stmt.setTimestamp(7, new Timestamp(ref.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GoProClientBaseReference> getClientReferences(String userId) throws SQLException {
        ArrayList<GoProClientBaseReference> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<GoProClientBaseReference> list = new ArrayList<GoProClientBaseReference>();
        String sql = "SELECT reference_id, user_id, '' AS contact_id, gopro_id, organization_id, is_deleted, created, modified, 'individual' AS clienttype FROM ss_individualreference WHERE user_id = ? AND is_deleted = 0 UNION SELECT reference_id, user_id, contact_id, gopro_id, organization_id, is_deleted, created, modified, 'contact' AS clienttype FROM ss_contactreference WHERE user_id = ? AND is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setString(2, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String clientType = rs.getString("clienttype");
                if ("individual".equals(clientType)) {
                    list.add(new GoProIndividualReference(rs));
                    continue;
                }
                if (!"contact".equals(clientType)) continue;
                list.add(new GoProContactReference(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GoProCompanyReference> getCompanyReferences(String companyId) throws SQLException {
        ArrayList<GoProCompanyReference> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<GoProCompanyReference> list = new ArrayList<GoProCompanyReference>();
        String sql = "SELECT r.reference_id, r.company_id, r.organization_id, r.gopro_company_id, r.is_deleted, r.created, r.modified FROM ss_companyreference r WHERE r.company_id = ? AND r.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, companyId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                GoProCompanyReference ref = new GoProCompanyReference(rs);
                list.add(ref);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers(List<String> userIds) throws SQLException {
        ArrayList<User> arrayList;
        int i;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<User> list = new ArrayList<User>();
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id WHERE u.user_id = ?";
        if (userIds.size() > 1) {
            for (i = 1; i < userIds.size(); ++i) {
                sql = sql + " OR u.user_id = ? ";
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            for (i = 0; i < userIds.size(); ++i) {
                stmt.setString(i + 1, userIds.get(i));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new User(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers(UserFilter filter) throws SQLException {
        ArrayList<User> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<User> list = new ArrayList<User>();
        String sql = "SELECT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id ";
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        if (filter.getRoleId() != null) {
            sql = sql + " INNER JOIN ss_userrolemap r ON r.user_id = u.user_id WHERE r.role_id = ?";
            paramList.add(new BaseDalc.FilterParam(12, filter.getRoleId()));
        }
        if (filter.getSearchString() != null) {
            sql = paramList.size() > 0 ? sql + " AND " : sql + " WHERE ";
            sql = sql + "(lower(u.username) LIKE ? OR lower(u.fullname) LIKE ? OR lower(u.email) LIKE ? OR lower(a.streetname) LIKE ? OR lower(a.city) LIKE ? or lower(a.state) LIKE ? OR lower(a.country) LIKE ?)";
            int conditionCount = 7;
            for (int i = 0; i < conditionCount; ++i) {
                paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchString().toLowerCase() + "%"));
            }
        } else if (filter.getLetterStartsWith() != null) {
            sql = paramList.size() > 0 ? sql + " AND " : sql + " WHERE ";
            sql = sql + "( lower(u.fullname) LIKE ? )";
            paramList.add(new BaseDalc.FilterParam(12, filter.getLetterStartsWith().toString().toLowerCase() + "%"));
        }
        if (!filter.getVerifiedStatus().equals((Object)UserFilter.VerifiedStatus.ALL)) {
            sql = paramList.size() > 0 ? sql + " AND " : sql + " WHERE ";
            sql = sql + "(u.is_verified = ?)";
            paramList.add(new BaseDalc.FilterParam(4, filter.getVerifiedStatus().equals((Object)UserFilter.VerifiedStatus.VERIFIED) ? 1 : 0));
        }
        if (!filter.getClientStatus().equals((Object)UserFilter.ClientStatus.ALL)) {
            sql = paramList.size() > 0 ? sql + " AND " : sql + " WHERE ";
            if (filter.getClientStatus().equals((Object)UserFilter.ClientStatus.CONTACT)) {
                sql = sql + "(u.user_id IN ( SELECT cl.user_id FROM ss_contacts cl WHERE cl.user_id = u.user_id AND cl.is_deleted = 0 AND cl.is_confirmed = 1) )";
            } else if (filter.getClientStatus().equals((Object)UserFilter.ClientStatus.INDIVIDUAL)) {
                sql = sql + "(u.user_id NOT IN ( SELECT cl.user_id FROM ss_contacts cl WHERE cl.user_id = u.user_id AND cl.is_deleted = 0 ) )";
            }
        }
        sql = sql + " ORDER BY u.fullname ASC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                if (param.getDataType() == 93) {
                    Long stamp = (Long)param.getValue();
                    stmt.setObject(paramCounter, (Object)new Timestamp(stamp), param.getDataType());
                } else {
                    stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                }
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new User(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    protected void createAddress(String referenceId, Address address) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"reference_id", "streetname", "city", "postcode", "state", "country"};
        String sql = this.createInsertSQL(TBL_ADDRESSES, cols);
        try {
            con = this.getTransactionConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, referenceId);
            stmt.setString(2, address.getStreetName());
            stmt.setString(3, address.getCity());
            stmt.setString(4, address.getPostcode());
            stmt.setString(5, address.getState());
            stmt.setString(6, address.getCountry());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
    }

    protected void updateAddress(String referenceId, Address address) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"streetname", "city", "postcode", "state", "country", "reference_id"};
        String sql = this.createUpdateSQL(TBL_ADDRESSES, cols);
        try {
            con = this.getTransactionConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, address.getStreetName());
            stmt.setString(2, address.getCity());
            stmt.setString(3, address.getPostcode());
            stmt.setString(4, address.getState());
            stmt.setString(5, address.getCountry());
            stmt.setString(6, referenceId);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGoProClientReference(GoProClientBaseReference ref) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"gopro_id", "is_deleted", "modified", "reference_id"};
        String table = ref instanceof GoProIndividualReference ? TBL_INDIVIDUALREF : TBL_CONTACTREF;
        String sql = this.createUpdateSQL(table, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ref.getGoproId());
            stmt.setInt(2, ref.isDeleted() ? 1 : 0);
            stmt.setTimestamp(3, new Timestamp(ref.getDateModified()));
            stmt.setString(4, ref.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGoProCompanyReference(GoProCompanyReference ref) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"gopro_company_id", "is_deleted", "modified", "reference_id"};
        String sql = this.createUpdateSQL(TBL_COMPANYREF, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ref.getGoproCompanyId());
            stmt.setInt(2, ref.isDeleted() ? 1 : 0);
            stmt.setTimestamp(3, new Timestamp(ref.getDateModified()));
            stmt.setString(4, ref.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Company> searchCompanies(String keyword) throws SQLException {
        ArrayList<Company> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Company> list = new ArrayList<Company>();
        String sql = "SELECT c.company_id,  c.name, c.is_deleted, c.created, c.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_companies c LEFT OUTER JOIN ss_addresses a ON a.reference_id = c.company_id WHERE c.is_deleted = 0 AND lower(c.name) LIKE ? ORDER BY c.name";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, "%" + keyword.toLowerCase() + "%");
            rs = stmt.executeQuery();
            while (rs.next()) {
                Company com = new Company(rs);
                list.add(com);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Company getCompanyByName(String companyName) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Company co = null;
        String sql = "SELECT c.company_id, c.name,c.is_deleted, c.created, c.modified,a.streetname, a.city, a.postcode, a.state, a.country FROM ss_companies c LEFT OUTER JOIN ss_addresses a ON a.reference_id = c.company_id WHERE c.name = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, companyName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                co = new Company(rs);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return co;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRecoveryTicket(RecoveryTicket ticket) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"ticket_id", "user_id", "request_ip", "expires", "is_used", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_RECOVERY, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ticket.getId());
            stmt.setString(2, ticket.getUserId());
            stmt.setString(3, ticket.getRequestIp());
            stmt.setTimestamp(4, new Timestamp(ticket.getExpiryDate()));
            stmt.setInt(5, ticket.isUsed() ? 1 : 0);
            stmt.setInt(6, ticket.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(ticket.getDateCreated()));
            stmt.setTimestamp(8, new Timestamp(ticket.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryTicket getRecoveryTicket(String ticketId) throws SQLException {
        RecoveryTicket recoveryTicket;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        RecoveryTicket ticket = null;
        String sql = "SELECT t.ticket_id, t.user_id, t.request_ip, t.expires, t.is_used, t.is_deleted, t.created, t.modified FROM ss_recoverytickets t WHERE t.ticket_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ticketId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ticket = new RecoveryTicket(rs);
            }
            rs.close();
            recoveryTicket = ticket;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return recoveryTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecoveryTicket(RecoveryTicket ticket) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"is_used", "is_deleted", "modified", "ticket_id"};
        String sql = this.createUpdateSQL(TBL_RECOVERY, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, ticket.isUsed() ? 1 : 0);
            stmt.setInt(2, ticket.isDeleted() ? 1 : 0);
            stmt.setTimestamp(3, new Timestamp(ticket.getDateModified()));
            stmt.setString(4, ticket.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserCount() throws SQLException {
        int n;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT COUNT(u.user_id) AS counter FROM ss_users u WHERE u.is_deleted = 0 AND u.is_verified = 1";
        try {
            int usercount = 0;
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                usercount = rs.getInt("counter");
            }
            rs.close();
            n = usercount;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getLicenseFile() throws SQLException {
        InputStream inputStream;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        InputStream in = null;
        String sql = "SELECT body from bird_file WHERE name = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, "__GoProLicenceData");
            rs = stmt.executeQuery();
            if (rs.next()) {
                in = rs.getBinaryStream("body");
            }
            rs.close();
            inputStream = in;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicenceServiceId() throws SQLException {
        String string;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String configKey = "bird:server_id";
        String serverId = null;
        String sql = "SELECT nvalue from bird_info WHERE name = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, "bird:server_id");
            rs = stmt.executeQuery();
            if (rs.next()) {
                serverId = rs.getString("nvalue");
            }
            rs.close();
            string = serverId;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsersByTargetGroup(UserFilter filter, List<String> targetGroupIds) throws SQLException {
        ArrayList<User> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<User> list = new ArrayList<User>();
        String sql = "SELECT DISTINCT u.user_id, u.username, u.fullname, u.password, u.email, u.idnumber, u.certificate, u.homephone, u.mobilephone, u.communication, u.profileimage, u.lang, u.is_readonly, u.is_verified, u.is_deleted, u.created, u.modified, a.streetname, a.city, a.postcode, a.state, a.country FROM ss_users u LEFT OUTER JOIN ss_addresses a ON a.reference_id = u.user_id INNER JOIN ss_targetgroupusers tu ON tu.user_id = u.user_id INNER JOIN ss_targetgroups t ON t.targetgroup_id = tu.targetgroup_id WHERE u.is_deleted = 0 AND t.is_deleted = 0 AND t.is_enabled = 1 AND ";
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        sql = sql + " ( ";
        for (int i = 0; i < targetGroupIds.size(); ++i) {
            String targetGroupId = targetGroupIds.get(i);
            if (i > 0) {
                sql = sql + " OR ";
            }
            sql = sql + "tu.targetgroup_id = ? ";
            paramList.add(new BaseDalc.FilterParam(12, targetGroupId));
        }
        sql = sql + " ) ";
        if (!filter.getClientStatus().equals((Object)UserFilter.ClientStatus.ALL)) {
            sql = sql + " AND ";
            if (filter.getClientStatus().equals((Object)UserFilter.ClientStatus.CONTACT)) {
                sql = sql + "( u.user_id IN ( SELECT cl.user_id FROM ss_contacts cl WHERE cl.user_id = u.user_id AND cl.is_deleted = 0 AND cl.is_confirmed = 1) )";
            } else if (filter.getClientStatus().equals((Object)UserFilter.ClientStatus.INDIVIDUAL)) {
                sql = sql + "( u.user_id NOT IN ( SELECT cl.user_id FROM ss_contacts cl WHERE cl.user_id = u.user_id AND cl.is_deleted = 0 AND cl.is_confirmed = 1) )";
            }
        }
        sql = sql + " ORDER BY u.fullname";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                if (param.getDataType() == 93) {
                    Long stamp = (Long)param.getValue();
                    stmt.setObject(paramCounter, (Object)new Timestamp(stamp), param.getDataType());
                } else {
                    stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                }
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new User(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    public void createContact(Contact contact) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"contact_id", "user_id", "company_id", "email", "assignedby_id", "is_deleted", "is_confirmed", "is_manager", "created", "modified"};
        String sql = this.createInsertSQL("ss_contacts", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, contact.getId());
            stmt.setString(2, contact.getUserId());
            stmt.setString(3, contact.getCompanyId());
            stmt.setString(4, contact.getEmail());
            stmt.setString(5, contact.getAssignedById());
            stmt.setInt(6, contact.isDeleted() ? 1 : 0);
            stmt.setInt(7, contact.isConfirmed() ? 1 : 0);
            stmt.setInt(8, contact.isManager() ? 1 : 0);
            stmt.setTimestamp(9, new Timestamp(contact.getDateCreated()));
            stmt.setTimestamp(10, new Timestamp(contact.getDateModified()));
            stmt.executeUpdate();
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getContact(String userId, String companyId) throws SQLException {
        Contact contact;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Contact contact2 = null;
        String sql = "SELECT c.contact_id, c.user_id, c.company_id, c.email, c.assignedby_id, c.is_deleted, c.is_confirmed, c.is_manager, c.created, c.modified FROM ss_contacts c WHERE c.user_id = ? AND c.company_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setString(2, companyId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                contact2 = new Contact(rs);
            }
            rs.close();
            contact = contact2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getContact(String contactId) throws SQLException {
        Contact contact;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Contact contact2 = null;
        String sql = "SELECT c.contact_id, c.user_id, c.company_id, c.email, c.assignedby_id, c.is_deleted, c.is_confirmed, c.is_manager, c.created, c.modified FROM ss_contacts c WHERE c.contact_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, contactId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                contact2 = new Contact(rs);
            }
            rs.close();
            contact = contact2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getContactByEmail(String email) throws SQLException {
        Contact contact;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Contact contact2 = null;
        String sql = "SELECT c.contact_id, c.user_id, c.company_id, c.email, c.assignedby_id, c.is_deleted, c.is_confirmed, c.is_manager, c.created, c.modified FROM ss_contacts c WHERE c.email = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, email);
            rs = stmt.executeQuery();
            if (rs.next()) {
                contact2 = new Contact(rs);
            }
            rs.close();
            contact = contact2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return contact;
    }

    public void updateContact(Contact contact) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"is_deleted", "is_manager", "is_confirmed", "email", "modified", "assignedby_id", "contact_id"};
        String sql = this.createUpdateSQL("ss_contacts", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, contact.isDeleted() ? 1 : 0);
            stmt.setInt(2, contact.isManager() ? 1 : 0);
            stmt.setInt(3, contact.isConfirmed() ? 1 : 0);
            stmt.setString(4, contact.getEmail());
            stmt.setTimestamp(5, new Timestamp(contact.getDateModified()));
            stmt.setString(6, contact.getAssignedById());
            stmt.setString(7, contact.getId());
            stmt.executeUpdate();
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignContactData(Connection con, User user) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT c.contact_id, c.user_id, c.company_id, com.name AS companyname, c.email, c.assignedby_id, c.is_confirmed, c.is_deleted, c.is_manager, c.created, c.modified FROM ss_contacts c INNER JOIN ss_companies com ON c.company_id = com.company_id WHERE c.user_id = ? AND c.is_deleted = 0 AND com.is_deleted = 0 ORDER BY companyname";
        try {
            stmt = con.prepareStatement(sql);
            stmt.setString(1, user.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                Contact contact = new Contact(rs);
                contact.setCompanyName(rs.getString("companyname"));
                user.getContactList().add(contact);
            }
            rs.close();
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignUserRoleData(Connection con, User user) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT r.role_id, r.rolename, r.description, r.is_deleted, r.created, r.modified FROM ss_userroles r INNER JOIN ss_userrolemap m ON r.role_id = m.role_id WHERE m.user_id = ?";
        try {
            stmt = con.prepareStatement(sql);
            stmt.setString(1, user.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                user.getUserRoles().add(new UserRole(rs));
            }
            rs.close();
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    static {
        queryPathMap.put(UserDalc.class.getSimpleName(), "users");
    }
}

