/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.communications;

import is.hugvit.util.Util;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.IBankMessageProvider;
import net.gopro.selfservice.communications.ITextMessageProvider;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.MessageService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;

public class Messenger {
    public static final boolean sendMessage(User user, String subject, String message, boolean sendInternal) throws CommunicationException, MessageException, SelfServiceException {
        if (user != null && message != null && message.length() > 0) {
            subject = Translator.translate((BaseDocument)user, subject);
            message = Translator.translate((BaseDocument)user, message);
            if (sendInternal) {
                Message m = new Message(user.getId(), subject, message);
                MessageService.createMessage(m);
            }
            switch (user.getCommunication()) {
                case EMAIL: {
                    return Messenger.sendEmailMessage(user.getEmail(), subject, message, true);
                }
                case SMS: {
                    return Messenger.sendTextMessage(user.getMobilephoneNumber(), message);
                }
                case BANK: {
                    return Messenger.sendBankMessage(user.getUsername(), message);
                }
                case NONE: {
                    return false;
                }
            }
        }
        return false;
    }

    public static final boolean sendMessage(User user, SimpleMessage sm, boolean sendInternal, Organization involvedOrganization, Organization.MailPreference mailPreference, String parentId) throws CommunicationException, MessageException, SelfServiceException {
        String subject = sm.getSubject();
        String message = sm.getMessage();
        if (user != null && message != null && message.length() > 0) {
            subject = Translator.translate((BaseDocument)user, subject);
            message = Translator.translate((BaseDocument)user, message);
            if (sendInternal) {
                Message m = new Message(user.getId(), subject, message);
                if (parentId != null) {
                    m.setParentId(parentId);
                }
                MessageService.createMessage(m);
            }
            switch (user.getCommunication()) {
                case EMAIL: {
                    if (Messenger.isMailEnabled(involvedOrganization, mailPreference)) {
                        if (involvedOrganization.isServiceAccountEnabled()) {
                            return Messenger.sendEmailMessage(user.getEmail(), subject, message, true, involvedOrganization.getServiceAccountEmail());
                        }
                        return Messenger.sendEmailMessage(user.getEmail(), subject, message, true);
                    }
                }
                case SMS: {
                    return Messenger.sendTextMessage(user.getMobilephoneNumber(), message);
                }
                case BANK: {
                    return Messenger.sendBankMessage(user.getUsername(), message);
                }
                case NONE: {
                    return false;
                }
            }
        }
        return false;
    }

    public static final boolean sendMessage(User user, Message message) throws MessageException, SelfServiceException, CommunicationException {
        if (user != null && message != null) {
            message.setSubject(Translator.translate((BaseDocument)user, message.getSubject()));
            message.setBody(Translator.translate((BaseDocument)user, message.getBody()));
            MessageService.createMessage(message);
            switch (user.getCommunication()) {
                case EMAIL: {
                    return Messenger.sendEmailMessage(user.getEmail(), message.getSubject(), message.getBody(), true);
                }
                case SMS: {
                    return Messenger.sendTextMessage(user.getMobilephoneNumber(), message.getBody());
                }
                case BANK: {
                    return Messenger.sendBankMessage(user.getUsername(), message.getBody());
                }
                case NONE: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean sendMessage(User user, Message message, Organization involvedOrganization, Organization.MailPreference mailPreference) throws MessageException, SelfServiceException, CommunicationException {
        if (user != null && message != null) {
            message.setSubject(Translator.translate((BaseDocument)user, message.getSubject()));
            message.setBody(Translator.translate((BaseDocument)user, message.getBody()));
            MessageService.createMessage(message);
            switch (user.getCommunication()) {
                case EMAIL: {
                    if (Messenger.isMailEnabled(involvedOrganization, mailPreference)) {
                        if (involvedOrganization.isServiceAccountEnabled()) {
                            return Messenger.sendEmailMessage(user.getEmail(), message.getSubject(), message.getBody(), true, involvedOrganization.getServiceAccountEmail());
                        }
                        return Messenger.sendEmailMessage(user.getEmail(), message.getSubject(), message.getBody(), true);
                    }
                    return Messenger.sendEmailMessage(user.getEmail(), message.getSubject(), message.getBody(), true);
                }
                case SMS: {
                    return Messenger.sendTextMessage(user.getMobilephoneNumber(), message.getBody());
                }
                case BANK: {
                    return Messenger.sendBankMessage(user.getUsername(), message.getBody());
                }
                case NONE: {
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean sendMessage(User user, SimpleMessage sm, User.Communications comm, boolean sendInternal) throws CommunicationException, MessageException, SelfServiceException {
        return Messenger.sendMessage(user, sm, comm, sendInternal, null);
    }

    public static final boolean sendMessage(User user, SimpleMessage sm, User.Communications comm, boolean sendInternal, String parentId) throws CommunicationException, MessageException, SelfServiceException {
        String subject = sm.getSubject();
        String message = sm.getMessage();
        if (user != null && message != null && message.length() > 0) {
            subject = Translator.translate((BaseDocument)user, subject);
            message = Translator.translate((BaseDocument)user, message);
            if (sendInternal) {
                Message m = new Message(user.getId(), subject, message);
                if (parentId != null) {
                    m.setParentId(parentId);
                }
                MessageService.createMessage(m);
            }
            switch (comm) {
                case EMAIL: {
                    return Messenger.sendEmailMessage(user.getEmail(), subject, message, true);
                }
                case SMS: {
                    return Messenger.sendTextMessage(user.getMobilephoneNumber(), message);
                }
                case BANK: {
                    return Messenger.sendBankMessage(user.getUsername(), message);
                }
            }
        }
        return false;
    }

    private static boolean sendBankMessage(String username, String message) throws CommunicationException {
        try {
            if (StringUtil.isValid(username) && StringUtil.isValid(message)) {
                message = Util.stripMarkup((String)message);
                IBankMessageProvider provider = Messenger.getBankMessageProvider();
                Properties properties = Messenger.getMessageProviderProperties(IBankMessageProvider.class);
                provider.setProperties(properties);
                String subject = SelfServiceEngine.getConfig("web.title");
                provider.sendMessage(username, subject, message);
                return true;
            }
            SelfServiceEngine.getLogger().warn("Error sending Bank message: invalid phonenumber or message.");
            return false;
        }
        catch (SelfServiceException ex) {
            throw new CommunicationException(ex);
        }
        catch (MessageException ex) {
            throw new CommunicationException(ex);
        }
    }

    public static final boolean sendEmailMessage(String recipient, String subject, String body, boolean ishtml) throws CommunicationException {
        return Messenger.sendEmailMessage(recipient, subject, body, ishtml, null);
    }

    public static final boolean sendEmailMessage(List<String> recipients, String subject, String body, boolean ishtml) throws CommunicationException {
        return Messenger.sendEmailMessage(recipients, subject, body, ishtml, null);
    }

    private static final boolean sendEmailMessage(List<String> recipients, String subject, String body, boolean ishtml, String bcc) throws CommunicationException {
        try {
            Email mailer = Messenger.getMailer(subject, body, ishtml);
            for (String recipient : recipients) {
                mailer.addCc(recipient);
            }
            if (bcc != null) {
                mailer.addBcc(bcc);
            }
            mailer.send();
            return true;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    private static final boolean sendEmailMessage(String recipient, String subject, String body, boolean ishtml, String bcc) throws CommunicationException {
        try {
            if (!StringUtil.isValidEmail(recipient)) {
                return false;
            }
            Email mailer = Messenger.getMailer(subject, body, ishtml);
            mailer.addTo(recipient);
            if (bcc != null) {
                mailer.addBcc(bcc);
            }
            mailer.send();
            return true;
        }
        catch (EmailException ex) {
            throw new CommunicationException((Exception)((Object)ex));
        }
    }

    private static Email getMailer(String subject, String body, boolean ishtml) throws CommunicationException {
        try {
            HtmlEmail mailer;
            if (ishtml) {
                mailer = new HtmlEmail();
                if (body != null) {
                    body = body.replaceAll("\\n", "<br/>");
                }
                mailer.setHtmlMsg("<html>" + body + "</html>");
            } else {
                mailer = new SimpleEmail();
                mailer.setMsg(body);
            }
            String senderEmail = SelfServiceEngine.getConfig("mail.sender");
            String senderName = SelfServiceEngine.getConfig("mail.sendername");
            String username = SelfServiceEngine.getConfig("mail.username");
            String password = SelfServiceEngine.getConfig("mail.password");
            String portNumber = SelfServiceEngine.getConfig("mail.port");
            String encryption = SelfServiceEngine.getConfig("mail.encryption");
            mailer.setSubject(subject);
            mailer.setCharset(SelfServiceEngine.getEncoding());
            mailer.setFrom(senderEmail, senderName);
            mailer.setHostName(SelfServiceEngine.getConfig("mail.hostname"));
            if (StringUtil.isValid(username) && StringUtil.isValid(password)) {
                mailer.setAuthentication(username, password);
            }
            if (StringUtil.isValid(portNumber)) {
                mailer.setSmtpPort(Integer.parseInt(portNumber));
            }
            if (StringUtil.isValid(encryption) && "TLS".equalsIgnoreCase(encryption)) {
                mailer.setStartTLSEnabled(true);
            } else if (StringUtil.isValid(encryption) && "SSL".equalsIgnoreCase(encryption)) {
                mailer.setSSLOnConnect(true);
            }
            return mailer;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    private static final boolean sendTextMessage(String phoneNumber, String message) throws CommunicationException {
        try {
            if (StringUtil.isValid(phoneNumber) && StringUtil.isValid(message)) {
                message = Util.stripMarkup((String)message);
                ITextMessageProvider provider = Messenger.getTextMessageProvider();
                Properties properties = Messenger.getMessageProviderProperties(ITextMessageProvider.class);
                provider.setProperties(properties);
                provider.sendMessage(phoneNumber, message);
                return true;
            }
            SelfServiceEngine.getLogger().warn("Error sending SMS: invalid phonenumber or message.");
            return false;
        }
        catch (SelfServiceException ex) {
            throw new CommunicationException(ex);
        }
        catch (MessageException ex) {
            throw new CommunicationException(ex);
        }
    }

    private static final IBankMessageProvider getBankMessageProvider() throws SelfServiceException {
        return EngineFactory.getCustomEngine(IBankMessageProvider.class);
    }

    private static final ITextMessageProvider getTextMessageProvider() throws SelfServiceException {
        return EngineFactory.getCustomEngine(ITextMessageProvider.class);
    }

    private static final Properties getMessageProviderProperties(Class clazz) throws SelfServiceException {
        Properties prop;
        block3: {
            block2: {
                prop = new Properties();
                if (!clazz.equals(IBankMessageProvider.class)) break block2;
                Set<ConfigEntry> config = ConfigService.getConfig("bank");
                BaseDocumentUtil.removeDeletedDocuments(config);
                for (ConfigEntry entry : config) {
                    prop.put(entry.getKey(), entry.getValue());
                }
                break block3;
            }
            if (!clazz.equals(ITextMessageProvider.class)) break block3;
            Set<ConfigEntry> config = ConfigService.getConfig("sms");
            BaseDocumentUtil.removeDeletedDocuments(config);
            for (ConfigEntry entry : config) {
                prop.put(entry.getKey(), entry.getValue());
            }
        }
        return prop;
    }

    private static final boolean isMailEnabled(Organization organization, Organization.MailPreference preference) throws SelfServiceException {
        return organization != null && organization.isMailOptionEnabled(preference);
    }
}

