/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import is.hugvit.bird.BirdException;
import is.hugvit.thread.ThreadContext;
import is.hugvit.thread.ThreadManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.agents.BirdThread;
import net.gopro.selfservice.util.ImpersonationUtil;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScheduleCheckerAgent
implements Job {
    private static final Logger logger = Logger.getLogger(ScheduleCheckerAgent.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ImpersonationUtil.impersonate();
            List<BirdThread> list = this.getThreads();
            for (BirdThread thread : list) {
                if (!thread.isRunning()) continue;
                Calendar dateStarted = Calendar.getInstance();
                dateStarted.setTime(thread.getLastRun());
                long runTime = Calendar.getInstance().getTimeInMillis() - dateStarted.getTimeInMillis();
                long minutes = TimeUnit.MILLISECONDS.toMinutes(runTime);
                logger.info((Object)("Thread " + thread.getName() + " is running. Runtime: " + minutes + " minutes."));
                boolean isStalled = minutes > 720L;
                if (!isStalled || !"RemoteGoProDataStore".equals(thread.getName())) continue;
                logger.warn((Object)"Datastore schedule is stalled.  Trying to shut it down");
                ThreadContext tc = ThreadManager.getContextByName((String)thread.getName());
                if (tc == null) continue;
                tc.stop();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (BirdException ex) {
            logger.error((Object)"Execution Error.", (Throwable)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        catch (SelfServiceException ex) {
            logger.error((Object)"Execution Error.", (Throwable)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private List<BirdThread> getThreads() throws BirdException {
        ArrayList<BirdThread> list = new ArrayList<BirdThread>();
        Connection conn = null;
        try {
            conn = SelfServiceEngine.getConnection();
            String table = "bird_thread";
            String fields = "name,enabled,id,lastrun";
            PreparedStatement stmt = conn.prepareStatement("select " + fields + " from " + table + " order by name");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                BirdThread bt = new BirdThread();
                int i = 1;
                StringTokenizer e = new StringTokenizer(fields, ",");
                String name = null;
                while (e.hasMoreElements()) {
                    String n = (String)e.nextElement();
                    Object obj = rs.getObject(i++);
                    String v = null;
                    if (obj instanceof Date) {
                        Date d = (Date)obj;
                        bt.setLastRun(d);
                    }
                    if (obj != null) {
                        v = obj.toString();
                    }
                    if (!n.equals("name")) continue;
                    name = v;
                    bt.setName(name);
                }
                ThreadContext tc = ThreadManager.getContextByName(name);
                if (tc != null) {
                    bt.setRunning(tc.isRunning());
                }
                list.add(bt);
            }
            rs.close();
            stmt.close();
            ArrayList<BirdThread> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                throw new BirdException((Exception)ex);
            }
        }
    }
}

