/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice;

import net.gopro.selfservice.ICaseEngine;
import net.gopro.selfservice.IConfigEngine;
import net.gopro.selfservice.IFormEngine;
import net.gopro.selfservice.ILogEngine;
import net.gopro.selfservice.IMessageEngine;
import net.gopro.selfservice.IQueueEngine;
import net.gopro.selfservice.ISearchEngine;
import net.gopro.selfservice.ISecurityEngine;
import net.gopro.selfservice.ITargetGroupEngine;
import net.gopro.selfservice.ITaskEngine;
import net.gopro.selfservice.IUserEngine;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;

public final class EngineFactory {
    public static final IUserEngine getUserEngine() throws SelfServiceException {
        return (IUserEngine)EngineFactory.getEngine(IUserEngine.class);
    }

    public static final ICaseEngine getCaseEngine() throws SelfServiceException {
        return (ICaseEngine)EngineFactory.getEngine(ICaseEngine.class);
    }

    public static final IFormEngine getFormEngine() throws SelfServiceException {
        return (IFormEngine)EngineFactory.getEngine(IFormEngine.class);
    }

    public static final ILogEngine getLogEngine() throws SelfServiceException {
        return (ILogEngine)EngineFactory.getEngine(ILogEngine.class);
    }

    public static final ITargetGroupEngine getTargetGroupEngine() throws SelfServiceException {
        return (ITargetGroupEngine)EngineFactory.getEngine(ITargetGroupEngine.class);
    }

    public static final ITaskEngine getTaskEngine() throws SelfServiceException {
        return (ITaskEngine)EngineFactory.getEngine(ITaskEngine.class);
    }

    public static final IQueueEngine getQueueEngine() throws SelfServiceException {
        return (IQueueEngine)EngineFactory.getEngine(IQueueEngine.class);
    }

    public static final ISearchEngine getSearchEngine() throws SelfServiceException {
        return (ISearchEngine)EngineFactory.getEngine(ISearchEngine.class);
    }

    public static final ISecurityEngine getSecurityEngine() throws SelfServiceException {
        return (ISecurityEngine)EngineFactory.getEngine(ISecurityEngine.class);
    }

    public static final IConfigEngine getConfigEngine() throws SelfServiceException {
        return (IConfigEngine)EngineFactory.getEngine(IConfigEngine.class);
    }

    public static final IMessageEngine getMessageEngine() throws SelfServiceException {
        return (IMessageEngine)EngineFactory.getEngine(IMessageEngine.class);
    }

    public static <T> T getCustomEngine(Class<T> c) throws SelfServiceException {
        return (T)EngineFactory.getEngine(c);
    }

    private static final Object getEngine(Class c) throws SelfServiceException {
        try {
            String className = SelfServiceEngine.getConfig(c.getName());
            Object engineObject = Class.forName(className).newInstance();
            return engineObject;
        }
        catch (Exception ex) {
            throw new SelfServiceException("Unable to get engine for: " + c.getName(), ex);
        }
    }
}

