SELECT e.email_id, e.case_id, e.parent_id, e.gopro_id, e.createdby_id, e.status_id,e.subject, 
e.body, e.fromname, e.fromemail, e.savecounter, e.responsecount, e.is_sent, e.is_fromgopro, e.is_sensitive,
e.is_deleted, e.created, e.modified, e.completed, l.subject AS statusname,
e.modifiedby_id, e.completedby_id, u.fullname AS authorName 
FROM ss_emails e 
LEFT OUTER JOIN ss_listitems l on e.status_id = l.item_id 
LEFT OUTER JOIN ss_users u on e.createdby_id = u.user_id

WHERE e.case_id = ? AND e.is_deleted = 0 AND e.email_id IN (

	-- User ACL
	SELECT a.document_id 
 	FROM ss_acl a 
  	WHERE a.entity_id = ? AND a.entity_type = 1 
	
	UNION
 
 	-- Target groups ACL 
	SELECT a.document_id 
	FROM ss_acl a
	INNER JOIN ss_targetgroups t ON t.targetgroup_id = a.entity_id
	INNER JOIN ss_targetgroupusers tu ON t.targetgroup_id = tu.targetgroup_id
	WHERE t.is_deleted = 0 AND tu.user_id = ? AND a.entity_type = 2
	
	UNION
	
  	-- Company ACL 
 	SELECT a.document_id
 	FROM ss_acl a 
    INNER JOIN ss_companies com ON com.company_id = a.entity_id
    INNER JOIN ss_contacts co ON com.company_id = co.company_id
    WHERE co.user_id = ? AND com.is_deleted = 0 AND co.is_deleted = 0 
    	AND co.is_confirmed = 1 AND a.entity_type = 3
	
	UNION 
 	
 	-- Role ACL
	SELECT a.document_id
  	FROM ss_acl a
    INNER JOIN ss_userroles r ON r.role_id = a.entity_id
    INNER JOIN ss_userrolemap rm ON r.role_id = rm.role_id
    WHERE r.is_deleted = 0 AND rm.user_id = ? AND a.entity_type = 4

)  

ORDER BY e.created