SELECT c.case_id, c.parent_id, c.createdby_id, c.organization_id, c.formtemplate_id, c.casetemplate_id,c.status_id, c.gopro_id, 
    c.gopro_casenumber, c.reference_number, c.subject, c.body, c.is_sent, c.is_deleted, c.is_fromgopro, c.is_signed, c.is_signaturepending, c.is_sensitive,
    c.is_reopened, c.is_shared, c.responsecount, c.created, c.modified, c.completed, c.classname, c.targetgroup_id, c.company_id, 
    c.contact_id, c.modifiedby_id, c.completedby_id 
FROM ss_cases c 
WHERE c.casetemplate_id = ? AND c.is_deleted = 0 AND c.case_id IN (

	-- User ACL
	SELECT a.document_id 
 	FROM ss_acl a 
  	WHERE a.entity_id = ? AND a.entity_type = 1 
	
	UNION
 
 	-- Target groups ACL 
	SELECT a.document_id 
	FROM ss_acl a
	INNER JOIN ss_targetgroups t ON t.targetgroup_id = a.entity_id
	INNER JOIN ss_targetgroupusers tu ON t.targetgroup_id = tu.targetgroup_id
	WHERE t.is_deleted = 0 AND tu.user_id = ? AND a.entity_type = 2
	
	UNION
	
  	-- Company ACL 
 	SELECT a.document_id
 	FROM ss_acl a 
    INNER JOIN ss_companies com ON com.company_id = a.entity_id
    INNER JOIN ss_contacts co ON com.company_id = co.company_id
    WHERE co.user_id = ? AND com.is_deleted = 0 AND co.is_deleted = 0 
    	AND co.is_confirmed = 1 AND a.entity_type = 3
	
	UNION 
 	
 	-- Role ACL
	SELECT a.document_id
  	FROM ss_acl a
    INNER JOIN ss_userroles r ON r.role_id = a.entity_id
    INNER JOIN ss_userrolemap rm ON r.role_id = rm.role_id
    WHERE r.is_deleted = 0 AND rm.user_id = ? AND a.entity_type = 4

)   

ORDER BY c.modified DESC