/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import java.security.Principal;
import java.util.Date;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.services.UserService;
import org.dom4j.Element;
import org.json.JSONObject;

public class TaskQuery
implements IWebFormQuery {
    private WebContext context;

    @Override
    public void setContext(WebContext context) {
        this.context = context;
    }

    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        try {
            Principal principal = this.context.getRequest().getUserPrincipal();
            User currentUser = UserService.getUserByUsername(principal.getName());
            if (action != null && "status".equals(action)) {
                String taskId;
                String string = taskId = data.has("id") ? data.getString("id") : null;
                if (taskId == null) {
                    throw new FormQueryException("Task id is missing");
                }
                if (!data.has("status")) {
                    throw new FormQueryException("Task status is missing");
                }
                int statusId = data.getInt("status");
                Task task = TaskService.getTask(taskId);
                if (task == null) {
                    throw new FormQueryException("Invalid task Id");
                }
                Task.TaskStatus newStatus = Task.TaskStatus.of(statusId);
                task.setStatus(newStatus);
                task.setModifiedById(currentUser.getId());
                if (Task.TaskStatus.Completed.equals((Object)newStatus)) {
                    task.setCompletedById(currentUser.getId());
                    task.setCompletedDate(new Date().getTime());
                }
                TaskService.updateTask(task);
                el.addElement("status").setText("success");
            } else if (action != null && "delete".equals(action)) {
                String taskId;
                String string = taskId = data.has("id") ? data.getString("id") : null;
                if (taskId == null) {
                    throw new FormQueryException("Task id is missing");
                }
                Task task = TaskService.getTask(taskId);
                if (task == null) {
                    throw new FormQueryException("Invalid task Id");
                }
                task.setDeleted(true);
                task.setModifiedById(currentUser.getId());
                TaskService.updateTask(task);
                el.addElement("status").setText("success");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FormQueryException(ex);
        }
    }
}

