/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.ConjunctionListType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.constants.FilterProperties;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.IGoProDataStore;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.datastore.DataStoreFactory;
import net.gopro.selfservice.datastore.RESTDataStore;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public class GoProLookupQuery
implements IWebFormQuery {
    private static Map<String, Integer> dataTypeMap = new HashMap<String, Integer>();

    @Override
    public void setContext(WebContext context) {
    }

    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        try {
            if ("lookup".equals(action)) {
                String lookupListType;
                String templateId;
                String string = templateId = data.has("id") ? data.getString("id") : null;
                if (templateId == null) {
                    throw new FormQueryException("Template Id is missing!");
                }
                Organization target = null;
                if (templateId.length() == 6) {
                    FormTemplate formTemplate = FormService.getFormTemplateByToken(templateId);
                    target = ConfigService.getOrganization(formTemplate.getOrganizationByLinkToken(templateId).getId());
                } else {
                    ExternalDocument doc = CaseService.getExternalDocument(templateId, false);
                    if (doc != null && doc instanceof ApplicationForm) {
                        BaseCase parentCase = CaseService.getCase(doc.getCaseId());
                        target = ConfigService.getOrganization(parentCase.getOrganizationId());
                    }
                }
                if (target == null) {
                    throw new FormQueryException("Could not resolve the GoPro Target!");
                }
                Map<String, String> params = this.getParameters(data);
                String string2 = lookupListType = data.has("type") ? data.getString("type") : null;
                if (lookupListType == null) {
                    throw new FormQueryException("No lookup list type has been specified");
                }
                Integer dataType = dataTypeMap.get(lookupListType);
                if (dataType == null || dataType == 0) {
                    throw new FormQueryException("Invalid lookup list type specified");
                }
                Dom4JUtil.addElement(el, "query", lookupListType);
                FlexibleDataSetType results = this.search(target, dataType, params);
                if (results != null && results.getData() != null && results.getData().getRowsCount() > 0) {
                    for (FlexibleDataRowType row : results.getData().getRows()) {
                        Element elItem = el.addElement("item");
                        elItem.addElement("id").setText(row.getID());
                        Dom4JUtil.addElement(elItem, "subject", row.getColumnValue(0));
                        Dom4JUtil.addElement(elItem, "email", row.getColumnValue(1));
                        Dom4JUtil.addElement(elItem, "doctype", String.valueOf(row.getDocumentType()));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FormQueryException(ex);
        }
    }

    private FlexibleDataSetType search(Organization target, int documentType, Map<String, String> params) throws SelfServiceException {
        try {
            DocumentFilterType filter = new DocumentFilterType();
            filter.setSubject("");
            filter.setDocumentFormType(documentType);
            filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
            filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
            if (params.size() > 0) {
                ArrayList<BinaryFilterExpressionType> filterList = new ArrayList<BinaryFilterExpressionType>();
                Set<Map.Entry<String, String>> entries = params.entrySet();
                for (Map.Entry<String, String> pair : entries) {
                    BinaryFilterExpressionType binaryFilter = new BinaryFilterExpressionType();
                    binaryFilter.setPropertyName(pair.getKey());
                    binaryFilter.setValue((Object)pair.getValue());
                    binaryFilter.setOperator(FilterOperatorType.EQUAL);
                    filterList.add(binaryFilter);
                }
                if (filterList.size() == 1) {
                    filter.setCustomFilter((FilterExpressionType)filterList.get(0));
                } else if (filterList.size() > 1) {
                    ConjunctionListType conjunctionFilter = new ConjunctionListType();
                    conjunctionFilter.setElements(filterList);
                    filter.setCustomFilter((FilterExpressionType)conjunctionFilter);
                }
            }
            filter.setLoadBinaryData(false);
            filter.setLoadDefaultColumns(false);
            filter.setSortColumn("_subject");
            filter.setLoadColumns(Arrays.asList("_subject"));
            if (documentType == 1017) {
                filter.addLoadColumn("_EMail");
            } else {
                filter.addLoadColumn("_emailAddresses");
            }
            return this.doSearch(target, filter);
        }
        catch (Exception ex) {
            throw new SelfServiceException(ex);
        }
    }

    private FlexibleDataSetType doSearch(Organization org, DocumentFilterType filter) throws GoProDataStoreException, SelfServiceException, GdfServiceException {
        IGoProDataStore dataStore = DataStoreFactory.getDataStore(org.getEndpoint());
        if (dataStore instanceof RESTDataStore) {
            return RestHelper.query(org, filter);
        }
        DocumentService service = this.getService(org);
        return service.getDocumentHeaders(filter);
    }

    private Map<String, String> getParameters(JSONObject data) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (data.has("parameters")) {
            JSONArray jsonArray = data.getJSONArray("parameters");
            for (int i = 0; i < jsonArray.length(); ++i) {
                String filterKey;
                JSONObject jo = jsonArray.getJSONObject(i);
                if (!jo.has("key") || !jo.has("value") || (filterKey = this.getFilterValue(jo.getString("key"))) == null) continue;
                params.put(filterKey, jo.getString("value"));
            }
        }
        return params;
    }

    private String getFilterValue(String filterKey) {
        try {
            if (filterKey.startsWith(FilterProperties.class.getSimpleName())) {
                filterKey = filterKey.substring(FilterProperties.class.getSimpleName().length() + 1, filterKey.length());
            }
            for (Class<?> clazz : FilterProperties.class.getDeclaredClasses()) {
                Field[] declaredFields;
                for (Field f : declaredFields = clazz.getDeclaredFields()) {
                    int start;
                    String generic = f.toGenericString();
                    String filterPropertyName = generic.substring((start = generic.indexOf("$")) + 1, generic.length());
                    if (!filterPropertyName.equalsIgnoreCase(filterKey)) continue;
                    f.setAccessible(true);
                    return f.get(null).toString();
                }
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private DocumentService getService(Organization org) throws SelfServiceException {
        String baseUrl = this.getBaseUrl(org.getEndpoint().getGoproType());
        if (baseUrl == null) {
            throw new SelfServiceException("The target organization does not support this operation.");
        }
        String documentServiceUrl = org.getEndpoint().getHostname();
        String authUsername = org.getEndpoint().getUsername();
        String authPassword = org.getEndpoint().getPassword();
        if (documentServiceUrl == null) {
            throw new SelfServiceException("GoPro Service Url is missing for the organization!");
        }
        if (authUsername == null) {
            throw new SelfServiceException("GoPro username is missing for the organization!");
        }
        if (authPassword == null) {
            throw new SelfServiceException("GoPro password is missing for the organization!");
        }
        documentServiceUrl = documentServiceUrl + baseUrl;
        return new DocumentService(documentServiceUrl, authUsername, authPassword, false);
    }

    private final String getBaseUrl(RemoteGoPro.GoPro type) {
        switch (type) {
            case GOPRO_NET: {
                return "WebServices/Gdf/BaseDocumentWebService.asmx";
            }
            case GOPRO_CASE: 
            case GOPRO_PORTAL: {
                return "services/DocumentService";
            }
        }
        return null;
    }

    static {
        dataTypeMap.put("Clients", 1006);
        dataTypeMap.put("Contacts", 1010);
        dataTypeMap.put("Companies", 1008);
        dataTypeMap.put("Individuals", 1009);
        dataTypeMap.put("Users", 1017);
        dataTypeMap.put("Category", 1013);
    }
}

