/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.util.SaxReader;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class XMLSignatureUtil {
    private Document doc;
    private Namespace signatureNamespace;
    private Map namespaceUris = new HashMap();

    public XMLSignatureUtil() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public final String getSignedContent(byte[] signature) throws SelfServiceException {
        try {
            SAXReader reader = SaxReader.createReader();
            this.doc = reader.read((InputStream)new ByteArrayInputStream(signature));
            this.setNameSpaces();
            String xquery = "Signature/SignatureValue";
            if (this.signatureNamespace != null) {
                String prefix = this.signatureNamespace.getPrefix();
                xquery = String.format("%s:Signature/%s:SignatureValue", prefix, prefix);
            }
            XPath xpath = this.doc.createXPath(xquery);
            xpath.setNamespaceURIs(this.namespaceUris);
            Node signedContentNode = xpath.selectSingleNode((Object)this.doc.getRootElement());
            if (signedContentNode != null) {
                return XMLSignatureUtil.stripInvalidChars(signedContentNode.getText());
            }
            return null;
        }
        catch (DocumentException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public List<X509Certificate> getCertificates(byte[] stream) throws SelfServiceException, CertificateException {
        try {
            ArrayList<X509Certificate> signatureList = new ArrayList<X509Certificate>();
            SAXReader reader = SaxReader.createReader();
            this.doc = reader.read((InputStream)new ByteArrayInputStream(stream));
            this.setNameSpaces();
            String xquery = "Signature/KeyInfo/X509Data/X509Certificate";
            if (this.signatureNamespace != null) {
                String prefix = this.signatureNamespace.getPrefix();
                xquery = String.format("%s:Signature/%s:KeyInfo/%s:X509Data/%s:X509Certificate", prefix, prefix, prefix, prefix);
            }
            XPath xpath = this.doc.createXPath(xquery);
            xpath.setNamespaceURIs(this.namespaceUris);
            List certNodes = xpath.selectNodes((Object)this.doc.getRootElement());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (Element el : certNodes) {
                byte[] bytes = Base64.decodeBase64((String)XMLSignatureUtil.stripInvalidChars(el.getText()));
                signatureList.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes)));
            }
            this.orderSignatureList(signatureList);
            return this.orderSignatureList(signatureList);
        }
        catch (DocumentException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private List<X509Certificate> orderSignatureList(List<X509Certificate> list) {
        ArrayList<X509Certificate> orderedList = new ArrayList<X509Certificate>();
        for (X509Certificate cert : list) {
            boolean[] keyUsage = cert.getKeyUsage();
            if (keyUsage != null && keyUsage[0] && keyUsage[1]) {
                orderedList.add(0, cert);
                continue;
            }
            if (cert.getBasicConstraints() > 1) {
                orderedList.add(orderedList.size(), cert);
                continue;
            }
            orderedList.add(cert);
        }
        return orderedList;
    }

    private void setNameSpaces() {
        Node signatureNode;
        Element root = this.doc.getRootElement();
        Namespace ns = root.getNamespace();
        if (ns != null) {
            this.namespaceUris.put(ns.getPrefix(), ns.getURI());
        }
        if ((signatureNode = root.selectSingleNode("*[1]")) != null) {
            this.signatureNamespace = ((Element)signatureNode).getNamespace();
            if (this.signatureNamespace != null) {
                this.namespaceUris.put(this.signatureNamespace.getPrefix(), this.signatureNamespace.getURI());
            }
        } else {
            throw new RuntimeException("Invalid XML Signature");
        }
    }

    private static String stripInvalidChars(String base64string) {
        return base64string.replaceAll("[^A-Za-z0-9+/=]", "");
    }
}

